/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.ConvertorJsonCommonMethod;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.service.KnowledgemapsService;
import com.digiwin.chatbi.service.TranslateService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetPermissionFilterExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(DataSetPermissionFilterExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_dataSet");
    }

    public Output doProcess(JSONObject context) {
        CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
        ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
        context.put("appCodesCondition", applicationCodes);
        Question question = (Question)context.getObject("question", Question.class);
        if (CollectionUtils.isNotEmpty((Collection)question.getDatasetIdList())) {
            context.put("datasetIds", (Object)question.getDatasetIdList());
        }
        String productVersion = question.getProductVersion();
        List dataSets = ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion) ? Optional.ofNullable(Retrieve.DATASET_V2.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList()) : Optional.ofNullable(Retrieve.DATASET_V1.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
        int oldSize = dataSets.size();
        if (CollectionUtils.isEmpty((Collection)dataSets)) {
            LogCheckDto logCheckDto = new LogCheckDto();
            JSONObject input = new JSONObject();
            input.put("applicationCodes", applicationCodes);
            input.put("version", (Object)context.getString("version"));
            String result = "\u7528\u6237\u5df2\u8ba2\u8d2d\u5e94\u7528\u4e0b\u65e0\u4efb\u4f55\u6307\u6807\uff0c\u53ef\u80fd\u662f\u79df\u6237\u3010" + context.getString("tenantId") + "\u3011" + "\u548c\u5e94\u7528\u7248\u672c\u4e0d\u76f8\u540c\u6216\u672a\u914d\u7f6e\u5e94\u7528\u6743\u9650";
            logCheckDto.buildParams("DataSetPermissionFilter", "U.SCRUMBI.901.0129", input.toJSONString(), result, "1.\u786e\u8ba4\u7528\u6237\u6743\u9650\u5728\u6743\u9650\u7ba1\u7406\u754c\u9762\u662f\u5426\u6b63\u786e\u3002\n2.\u95ee\u9898\u662f\u5728\u6d4b\u8bd5\u533a\uff0c\u79df\u6237\u7248\u672c1.0\u9700\u53d1\u7248\u6570\u636e\u96c6\u6240\u5728\u7684\u5e94\u7528\uff0c2.0\u9700\u5207\u7248\u6570\u636e\u96c6\u6240\u5728\u7684\u5e94\u7528\u3002\n3.\u8fdb\u5165\u7cfb\u7edf\u7684\u53d1\u7248\u6216\u5207\u7248\u64cd\u4f5c\u754c\u9762\uff0c\u6267\u884c\u64cd\u4f5c\u3002\n4.\u5907\u4efd\u6570\u636e\u540e\u53d1\u7248\u6216\u5207\u7248\uff0c\u5b8c\u6210\u540e\u68c0\u67e5\u7cfb\u7edf\u662f\u5426\u6b63\u5e38\uff0c\u5426\u5219\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.no.metric.error").keep("logCheckDtos", logCheckDtos);
        }
        List dataSetNames = dataSets.stream().map(dataSet -> dataSet.getString("datasetId")).collect(Collectors.toList());
        if (ConvertorJsonCommonMethod.queryMetricSwitch((JSONObject)context).booleanValue()) {
            dataSets = this.filterMetricPermission(context, dataSets);
        }
        if (CollectionUtils.isEmpty((Collection)dataSets)) {
            LogCheckDto logCheckDto = new LogCheckDto();
            StringBuilder result = new StringBuilder();
            JSONObject input = new JSONObject();
            input.put("dataSetIds", dataSetNames);
            input.put("applicationCodes", applicationCodes);
            input.put("version", (Object)context.getString("version"));
            result.append("\u8fc7\u6ee4\u6743\u9650\u540e\u6570\u636e\u96c6\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u672a\u914d\u7f6e\u6307\u6807\u6743\u9650");
            logCheckDto.buildParams("DataSetPermissionFilter", "U.SCRUMBI.901.0130", input.toJSONString(), result.toString(), "\u8bf7\u5728\u9f0e\u6377\u4e91\u4e2d\u914d\u7f6e\u6307\u6807\u6743\u9650");
            logCheckDtos.add(logCheckDto);
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.no.metric.permission").keep("no_metric_permission_flag", (Object)1).keep("logCheckDtos", logCheckDtos);
        }
        int newSize = dataSets.size();
        LogCheckDto logCheckDto = new LogCheckDto();
        JSONObject result = new JSONObject();
        JSONObject input = new JSONObject();
        input.put("applicationCodes", applicationCodes);
        input.put("version", (Object)context.getString("version"));
        result.put("dataSetIds", dataSets.stream().map(dataSet -> dataSet.getString("datasetId")).collect(Collectors.toList()));
        logCheckDto.buildParams("SearchAppAndVersion", LogUtils.SUCCESS, input.toJSONString(), result.toJSONString(), "");
        logCheckDtos.add(logCheckDto);
        return Output.through((String)"dataSets_with_permission", (Object)dataSets).keep("dataSets_all_permission", (Object)(oldSize == newSize ? 1 : 0));
    }

    public List<JSONObject> filterMetricPermission(JSONObject context, List<JSONObject> dataSets) {
        List dataSetIds = this.queryPermission4DataSet(context, dataSets);
        if (dataSetIds == null || CollectionUtils.isEmpty((Collection)dataSetIds)) {
            context.put("noPermissionMetrics", dataSets.stream().map(metric -> metric.getString("datasetId")).collect(Collectors.toSet()));
            return null;
        }
        return dataSets.stream().filter(dataSet -> dataSetIds.contains(dataSet.getString("datasetId"))).collect(Collectors.toList());
    }

    private List<String> queryPermission4DataSet(JSONObject context, List<JSONObject> dataSets) {
        String userId = ((Question)context.getObject("question", Question.class)).getUserId();
        String token = ((Question)context.getObject("question", Question.class)).getToken();
        String routerKey = ((Question)context.getObject("question", Question.class)).getRouterKey();
        ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
        List datasetIds = dataSets.stream().map(t -> t.getString("datasetId")).distinct().collect(Collectors.toList());
        KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
        try {
            JSONObject res = bean.queryPermissionSceneOrMetric(token, routerKey, userId, applicationCodes, datasetIds);
            if (res != null) {
                ArrayList<String> permissionList;
                List<String> list = permissionList = Objects.isNull(res.getObject("response", List.class)) ? new ArrayList<String>() : (List)res.getObject("response", List.class);
                if (CollectionUtils.isNotEmpty(permissionList)) {
                    return permissionList;
                }
                return null;
            }
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u6570\u636e\u96c6\u6743\u9650\u83b7\u53d6\u5931\u8d25:{}", (Throwable)e);
        }
        return null;
    }

    private JSONObject translateMetric(String key) {
        TranslateService bean = (TranslateService)SpringContextUtil.getBean(TranslateService.class);
        JSONObject cnAndTw = bean.cnAndTw(key);
        return cnAndTw;
    }
}

