/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.FilterKnowLedgeTypeEnum;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SearchTableExecutor
implements Executor {
    private static final String search_table_query_fields = "search_table_query_fields";
    private static final String search_table_query_module = "search_table_query_module";
    private static final String search_table_query_system = "search_table_query_system";
    private static final int METRIC_KEYWORD_BOOST = 30;
    private static final int SIMILAR_METRICS_KEYWORD_BOOST = 20;
    private static final int MODULE_KEYWORD_BOOST = 20;
    private static final int SUBSYSTEM_KEYWORD_BOOST = 5;
    private static final int RELATED_FIELDS_KEYWORD_BOOST = 3;

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_dataSet");
    }

    public Output doProcess(JSONObject context) {
        JSONObject dslParam = SearchTableExecutor.logicFormToDsl((JSONObject)context);
        if (context.containsKey((Object)"appCodesCondition")) {
            dslParam.put("appCodesCondition", context.get((Object)"appCodesCondition"));
        }
        if (context.containsKey((Object)"version")) {
            dslParam.put("version", context.get((Object)"version"));
        }
        if (context.containsKey((Object)"datasetIds")) {
            dslParam.put("datasetIds", context.get((Object)"datasetIds"));
        }
        List matched_table_ids_es = Collections.emptyList();
        if (StringUtils.isBlank((CharSequence)dslParam.getString("search_table_query_module")) || StringUtils.isBlank((CharSequence)dslParam.getString("search_table_query_fields"))) {
            return Output.through().keep("matched_table_ids_es", matched_table_ids_es);
        }
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        Retrieve retrieve = ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion) ? Retrieve.MATCH_TABLE_V2 : Retrieve.MATCH_TABLE_V1;
        JSONObject tables = retrieve.retrieve(dslParam);
        matched_table_ids_es = tables.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source").getString("datasetId")).collect(Collectors.toList());
        return Output.through().keep("matched_table_ids_es", matched_table_ids_es).keep("matched_tables", (Object)tables).keep("matched_tables_md", (Object)SearchTableExecutor.generateMarkdownFromEsHits((JSONObject)tables)).keep("filter_knowledge_type", (Object)FilterKnowLedgeTypeEnum.MATCH_TABLE_FIRST.getCode());
    }

    public static List<Map<String, Object>> mergeAndDeduplicate(List<Map<String, Object>> ... lists) {
        HashMap<String, Double> merged = new HashMap<String, Double>();
        for (List<Map<String, Object>> lst : lists) {
            if (CollectionUtils.isEmpty(lst)) continue;
            for (Map<String, Object> item : lst) {
                for (Map.Entry<String, Object> entry : item.entrySet()) {
                    String normalizedKey = entry.getKey().toLowerCase();
                    double newVal = ((Number)entry.getValue()).doubleValue();
                    if (merged.containsKey(normalizedKey) && !(newVal > ((Number)merged.get(normalizedKey)).doubleValue())) continue;
                    merged.put(normalizedKey, newVal);
                }
            }
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : merged.entrySet()) {
            HashMap item = new HashMap();
            item.put(entry.getKey(), entry.getValue());
            result.add(item);
        }
        return result;
    }

    public static JSONObject logicFormToDsl(JSONObject context) {
        List queryTokens;
        JSONObject logicForm = context.getJSONObject("logicForm");
        ArrayList metricTerms = new ArrayList();
        JSONArray metricArray = logicForm.getJSONArray("metric");
        if (metricArray != null) {
            for (int i = 0; i < metricArray.size(); ++i) {
                String metric = metricArray.getString(i);
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put(metric, 30);
                metricTerms.add(map);
            }
        }
        ArrayList similarMetricsMatch = new ArrayList();
        JSONArray similarMetricsArray = logicForm.getJSONArray("similar_metrics");
        if (similarMetricsArray != null) {
            for (int i = 0; i < similarMetricsArray.size(); ++i) {
                JSONObject metricObj = similarMetricsArray.getJSONObject(i);
                String metric = metricObj.getString("metric");
                JSONArray matchWithArray = metricObj.getJSONArray("match_with");
                if (metric.length() < 3 || matchWithArray.size() > 10 || matchWithArray == null) continue;
                for (int j = 0; j < matchWithArray.size(); ++j) {
                    String match = matchWithArray.getString(j);
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put(match, 20 / matchWithArray.size());
                    similarMetricsMatch.add(map);
                }
            }
        }
        ArrayList entityTokens = new ArrayList();
        ArrayList entityFields = new ArrayList();
        JSONArray entityArray = logicForm.getJSONArray("entity");
        if (entityArray != null) {
            for (int i = 0; i < entityArray.size(); ++i) {
                String token;
                JSONObject entity = entityArray.getJSONObject(i);
                double weight = entity.getDoubleValue("weight");
                JSONArray fieldsArray = entity.getJSONArray("field");
                if (fieldsArray != null) {
                    for (int j = 0; j < fieldsArray.size(); ++j) {
                        JSONObject field = fieldsArray.getJSONObject(j);
                        String name = field.getString("name");
                        double boost = field.getDoubleValue("boost");
                        HashMap<String, Double> map = new HashMap<String, Double>();
                        map.put(name, boost * weight);
                        entityTokens.add(map);
                    }
                }
                if ((token = entity.getString("token")) == null) continue;
                HashMap<String, Double> map = new HashMap<String, Double>();
                map.put(token, weight);
                entityFields.add(map);
            }
        }
        ArrayList relatedFieldsTokens = new ArrayList();
        JSONArray relatedFieldsArray = logicForm.getJSONArray("related_fields");
        if (relatedFieldsArray != null) {
            for (int i = 0; i < relatedFieldsArray.size(); ++i) {
                String phrase = relatedFieldsArray.getString(i);
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put(phrase, 3);
                relatedFieldsTokens.add(map);
            }
        }
        StringBuilder modulesTokens = new StringBuilder();
        StringBuilder subsystemTokens = new StringBuilder();
        JSONArray modulesArray = logicForm.getJSONArray("modules");
        if (modulesArray != null) {
            for (int i = 0; i < modulesArray.size(); ++i) {
                JSONObject module = modulesArray.getJSONObject(i);
                modulesTokens.append(SearchTableExecutor.replaceSpecialChar((String)module.getString("name"))).append("^").append(20).append(" ");
                JSONArray systemArray = module.getJSONArray("system");
                if (systemArray == null) continue;
                for (int j = 0; j < systemArray.size(); ++j) {
                    subsystemTokens.append(SearchTableExecutor.replaceSpecialChar((String)systemArray.getString(j))).append("^").append(5).append(" ");
                }
            }
        }
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        if (ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
            List originalStandardWords = (List)context.getOrDefault((Object)"originalStandardWords", new ArrayList());
            List standard_synonyms_words = (List)context.getOrDefault((Object)"standardSynonymsWords", new ArrayList());
            List dimension_standard_synonyms_words = (List)context.getOrDefault((Object)"dimension_standard_synonyms_words", new ArrayList());
            queryTokens = SearchTableExecutor.mergeAndDeduplicate((List[])new List[]{metricTerms, similarMetricsMatch, entityTokens, entityFields, relatedFieldsTokens, SearchTableExecutor.getStandardTokens((List)originalStandardWords), SearchTableExecutor.getStandardTokens((List)standard_synonyms_words), SearchTableExecutor.getStandardTokens((List)dimension_standard_synonyms_words)});
        } else {
            queryTokens = SearchTableExecutor.mergeAndDeduplicate((List[])new List[]{metricTerms, similarMetricsMatch, entityTokens, entityFields, relatedFieldsTokens});
        }
        StringBuilder queryStr = new StringBuilder();
        for (Map item : queryTokens) {
            for (Map.Entry entry : item.entrySet()) {
                queryStr.append(SearchTableExecutor.replaceSpecialChar((String)((String)entry.getKey()))).append("^").append(entry.getValue()).append(" ");
            }
        }
        JSONObject dslParams = new JSONObject();
        dslParams.put("search_table_query_fields", (Object)queryStr.toString().trim());
        dslParams.put("search_table_query_module", (Object)modulesTokens.toString().trim());
        dslParams.put("search_table_query_system", (Object)subsystemTokens.toString().trim());
        return dslParams;
    }

    private static String replaceSpecialChar(String key) {
        return key.replaceAll("/", "\\\\/");
    }

    private static List<Map<String, Object>> getStandardTokens(List<JSONObject> originalStandardWords) {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isNotEmpty(originalStandardWords)) {
            List standardNames = originalStandardWords.stream().map(o -> o.getString("standard_name")).distinct().collect(Collectors.toList());
            for (int i = 0; i < standardNames.size(); ++i) {
                String phrase = (String)standardNames.get(i);
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put(phrase, 3);
                res.add(map);
            }
        }
        return res;
    }

    public static String generateMarkdownFromEsHits(JSONObject esResult) {
        StringBuilder markdown = new StringBuilder();
        JSONArray hits = esResult.getJSONObject("hits").getJSONArray("hits");
        for (int i = 0; i < hits.size(); ++i) {
            JSONObject hit = hits.getJSONObject(i);
            JSONObject source = hit.getJSONObject("_source");
            String datasetId = source.getString("datasetId");
            String datasetName = source.getString("datasetName");
            JSONArray fieldSchema = source.getJSONArray("fieldSchema");
            markdown.append("### Dataset: ").append(datasetName).append(" (`datasetId`: ").append(datasetId).append(")\n\n");
            markdown.append("| \u5b57\u6bb5\u6807\u9898 (fieldTitle) | \u5b57\u6bb5\u540d (fieldName) |\n");
            markdown.append("|-----------------------|--------------------|\n");
            if (fieldSchema != null) {
                for (int j = 0; j < fieldSchema.size(); ++j) {
                    JSONObject field = fieldSchema.getJSONObject(j);
                    String fieldTitle = field.getString("title");
                    String fieldName = field.getString("name");
                    markdown.append("| ").append(fieldTitle).append(" | ").append(fieldName).append(" |\n");
                }
            }
            markdown.append("\n");
        }
        return markdown.toString();
    }
}

