/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.pptGeneration;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindDatasetByMetricExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(FindDatasetByMetricExecutor.class);

    public Output doProcess(JSONObject context) {
        Map metricAndDataSetIdsMap = (Map)context.get((Object)"metricAndDataSetIdsMap");
        List dataSets = (List)context.get((Object)"final_dataSet");
        try {
            JSONObject indicator_mining = context.getJSONObject("indicator_mining");
            JSONArray metrics = indicator_mining.getJSONArray("metrics");
            List dataSetIds = metrics.stream().flatMap(metric -> {
                List ids = (List)metricAndDataSetIdsMap.get(metric);
                return ids != null ? ids.stream() : Stream.empty();
            }).distinct().collect(Collectors.toList());
            dataSets = dataSets.stream().filter(dataSet -> dataSetIds.contains(dataSet.getString("datasetId"))).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.warn("\u67e5\u627e\u6570\u636e\u96c6\u5f02\u5e38{}", (Throwable)e);
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"\u6ca1\u6709\u6570\u636e\u96c6");
        }
        return Output.through((String)"final_dataSet", dataSets);
    }
}

