/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.pptGeneration;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.PPTGenerateReq;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.PlanningQuestionAndAnswer;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class PPTAssemblyOutlineExecutor
implements Executor {
    public Output doProcess(JSONObject context) {
        PPTGenerateReq pptGenerateReq = (PPTGenerateReq)context.getObject("pPTGenerateReq", PPTGenerateReq.class);
        JSONArray datas = new JSONArray();
        datas.add((Object)this.AssemblyCover(pptGenerateReq.getPlanningTopic(), pptGenerateReq.getLocale()));
        datas.add((Object)this.AssemblyIntroduction(context, pptGenerateReq.getLocale()));
        datas.addAll((Collection)this.AssemblyCharts(pptGenerateReq, pptGenerateReq.getLocale()));
        datas.add((Object)this.AssemblyFinallySummary(context, pptGenerateReq.getLocale()));
        JSONObject ppt_content = new JSONObject();
        ppt_content.put("name", (Object)(pptGenerateReq.getPlanningTopic() + ".pptx"));
        ppt_content.put("userId", (Object)pptGenerateReq.getUserId());
        ppt_content.put("userName", (Object)pptGenerateReq.getUserName());
        ppt_content.put("tenantId", (Object)pptGenerateReq.getTenantId());
        ppt_content.put("datas", (Object)datas);
        return Output.through((String)"ppt_content", (Object)ppt_content);
    }

    private JSONObject AssemblyCover(String topic, String locale) {
        JSONObject summary = new JSONObject();
        summary.put("title", (Object)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)topic) : topic));
        summary.put("content", (Object)"");
        summary.put("chart", null);
        return summary;
    }

    private JSONArray AssemblyCharts(PPTGenerateReq pptGenerateReq, String locale) {
        JSONArray tables = new JSONArray();
        for (PlanningQuestionAndAnswer planningQuestionAndAnswer : pptGenerateReq.getPlanningQuestionAndAnswers()) {
            JSONObject table = new JSONObject();
            String title = planningQuestionAndAnswer.getAnswer().getString("title");
            table.put("title", (Object)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)title) : title));
            table.put("content", (Object)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)planningQuestionAndAnswer.getSummary()) : planningQuestionAndAnswer.getSummary()));
            JSONObject jsonObject = this.convertChartType(planningQuestionAndAnswer.getAnswer(), pptGenerateReq.getChartTypeMap());
            if (Objects.nonNull(jsonObject.getJSONObject("option"))) {
                for (Map.Entry option : jsonObject.getJSONObject("option").entrySet()) {
                    jsonObject.put((String)option.getKey(), option.getValue());
                }
            }
            jsonObject.remove((Object)"option");
            table.put("chart", (Object)jsonObject);
            tables.add((Object)table);
        }
        return tables;
    }

    private JSONObject convertChartType(JSONObject answer, Map<String, String> map) {
        answer.put("type", (Object)map.get(answer.getString("type")));
        return answer;
    }

    private JSONObject AssemblyIntroduction(JSONObject context, String locale) {
        JSONObject introduction_generation = context.getJSONObject("introduction_generation");
        JSONObject introduction = new JSONObject();
        introduction.put("title", (Object)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"\u5f15\u8a00") : "\u5f15\u8a00"));
        introduction.put("content", (Object)(Objects.isNull(introduction_generation) ? "" : ("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)introduction_generation.getString("splitLogic")) : introduction_generation.getString("splitLogic"))));
        introduction.put("chart", null);
        return introduction;
    }

    private JSONObject AssemblyFinallySummary(JSONObject context, String locale) {
        JSONObject ppt_summary = context.getJSONObject("ppt_summary");
        JSONObject summary = new JSONObject();
        summary.put("title", (Object)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"\u603b\u7ed3") : "\u603b\u7ed3"));
        summary.put("content", (Object)(Objects.isNull(ppt_summary) ? "" : ("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)ppt_summary.getString("conclusion")) : ppt_summary.getString("conclusion"))));
        summary.put("chart", null);
        return summary;
    }
}

