/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.output;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.vos.ChatResultMetricVo;
import com.digiwin.chatbi.common.enums.ChatResult4MetricCode;
import com.digiwin.chatbi.common.enums.MetricIntentType;
import com.digiwin.chatbi.common.enums.MetricSearchResultEnum;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.ExecutorFactory;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputDataMetricExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(OutputDataMetricExecutor.class);
    public static final String OUTPUT_KEY = "finalResult";
    private final EnumMap<MetricIntentType, Function<JSONObject, Output>> intentMap = new EnumMap(MetricIntentType.class);

    public OutputDataMetricExecutor() {
        this.intentMap.put(MetricIntentType.GRAPH, context -> this.finishWithResultVo(context, arg_0 -> this.ofSolutionStep(arg_0), ChatResult4MetricCode.GRAPH));
        this.intentMap.put(MetricIntentType.APP, context -> Output.finish((String)OUTPUT_KEY, (Object)ChatResultMetricVo.createResult((JSONObject)context, (String)(context.containsKey((Object)"reply") ? context.getString("reply") : ""), (ChatResult4MetricCode)ChatResult4MetricCode.APP)));
        this.intentMap.put(MetricIntentType.REPLY, context -> Output.finish((String)OUTPUT_KEY, (Object)ChatResultMetricVo.createResult((JSONObject)context, (String)(context.containsKey((Object)"reply") ? context.getString("reply") : ""), (ChatResult4MetricCode)ChatResult4MetricCode.REPLY)));
        this.intentMap.put(MetricIntentType.METRIC, context -> Output.finish((String)OUTPUT_KEY, (Object)ChatResultMetricVo.createResult((JSONObject)context, (String)(context.containsKey((Object)"reply") ? context.getString("reply") : ""), (ChatResult4MetricCode)ChatResult4MetricCode.METRIC)));
    }

    public Output doProcess(JSONObject context) {
        if (context.containsKey((Object)"scelect_metric") || context.containsKey((Object)"scelect_dataSet")) {
            Boolean success = (Boolean)context.getOrDefault((Object)"success", (Object)false);
            MetricIntentType intentType = MetricIntentType.REPLY;
            if (StringUtils.isNotEmpty((CharSequence)context.getString(MetricSearchResultEnum.MORE_APP_MORE_METRIC.getKey()))) {
                log.info("\u771f\u8d70\u5230\u591a\u5e94\u7528\u4e86\u5417\uff1a{}", (Object)context);
                intentType = MetricIntentType.APP;
            } else if (Boolean.TRUE.equals(success)) {
                intentType = MetricIntentType.GRAPH;
            }
            Function<JSONObject, Output> action = this.intentMap.getOrDefault(intentType, data -> this.finishWithResultVo(data, jsonObject -> {
                JSONArray array = new JSONArray();
                array.add(jsonObject);
                return array;
            }, ChatResult4MetricCode.UNKNOWN));
            this.buildApplicationList(context);
            this.matchSynonymShow(context);
            return action.apply(context);
        }
        return ExecutorFactory.ALIGN_OUTPUT_WITH_API.doProcess(context);
    }

    private void buildApplicationList(JSONObject context) {
        try {
            List metricList = context.containsKey((Object)"scelect_dataSet") ? (List)context.getOrDefault((Object)"final_dataSet", new ArrayList()) : (List)context.getOrDefault((Object)"final_metric", new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)metricList)) {
                JSONObject application = new JSONObject();
                application.put("appName", (Object)((JSONObject)metricList.get(0)).getString("applicationName"));
                application.put("appCode", (Object)((JSONObject)metricList.get(0)).getString("applicationCode"));
                ArrayList<JSONObject> applicationList = new ArrayList<JSONObject>();
                applicationList.add(application);
                context.put("application_list", applicationList);
            }
        }
        catch (Exception e) {
            log.error("buildApplicationList is error", (Throwable)e);
        }
    }

    private void matchSynonymShow(JSONObject context) {
        try {
            List otherList;
            List dimensionList;
            if (StringUtils.isNotEmpty((CharSequence)context.getString(MetricSearchResultEnum.MORE_APP_MORE_METRIC.getKey()))) {
                return;
            }
            if (context.containsKey((Object)"no_metric_permission_flag")) {
                return;
            }
            ArrayList<JSONObject> synonymMatchingList = new ArrayList<JSONObject>();
            List metricList = (List)context.getOrDefault((Object)"distinctMetricStandardWords", new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)metricList)) {
                for (Object jsonObject : metricList) {
                    JSONObject synonymMatch = new JSONObject();
                    String compareField = jsonObject.getString("compare_field");
                    String standardName = jsonObject.getString("standard_name");
                    String entityType = jsonObject.getString("entity_type");
                    synonymMatch.put("standardWord", (Object)standardName);
                    if (StringUtils.isBlank((CharSequence)entityType)) {
                        synonymMatch.put("description", (Object)"\u76f4\u63a5\u5339\u914d\u6307\u6807");
                    } else {
                        synonymMatch.put("entityType", (Object)"\u76ee\u6807");
                        synonymMatch.put("matchWord", (Object)compareField);
                    }
                    synonymMatchingList.add(synonymMatch);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(dimensionList = (List)context.getOrDefault((Object)"distinctDimensionStandardWords", new ArrayList())))) {
                for (Object jsonObject : dimensionList) {
                    JSONObject synonymMatch = new JSONObject();
                    String compareField = jsonObject.getString("compare_field");
                    String standardName = jsonObject.getString("standard_name");
                    String entityType = jsonObject.getString("entity_type");
                    synonymMatch.put("standardWord", (Object)standardName);
                    if (StringUtils.isBlank((CharSequence)entityType)) {
                        synonymMatch.put("description", (Object)"\u76f4\u63a5\u5339\u914d\u6307\u6807");
                    } else {
                        synonymMatch.put("entityType", (Object)entityType);
                        synonymMatch.put("matchWord", (Object)compareField);
                    }
                    synonymMatchingList.add(synonymMatch);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(otherList = (List)context.getOrDefault((Object)"distinctOtherStandardWords", new ArrayList())))) {
                for (JSONObject jsonObject : otherList) {
                    JSONObject synonymMatch = new JSONObject();
                    String compareField = jsonObject.getString("compare_field");
                    String standardName = jsonObject.getString("standard_name");
                    String entityType = jsonObject.getString("entity_type");
                    synonymMatch.put("standardWord", (Object)standardName);
                    synonymMatch.put("entityType", (Object)entityType);
                    synonymMatch.put("matchWord", (Object)compareField);
                    synonymMatchingList.add(synonymMatch);
                }
            }
            if (CollectionUtils.isNotEmpty(synonymMatchingList)) {
                JSONObject synonymMatching = new JSONObject();
                synonymMatching.put("synonymMatching", synonymMatchingList);
                context.put("synonymDebug", (Object)synonymMatching);
            }
        }
        catch (Exception e) {
            log.error("scrumbi match synonym info error\uff1a", (Throwable)e);
        }
    }

    private JSONArray ofSolutionStep(JSONObject context) {
        return context.getJSONArray("solutionStep");
    }

    private Output finishWithResultVo(JSONObject context, Function<JSONObject, JSONArray> replyGetter, ChatResult4MetricCode resultCode) {
        return Output.finish((String)OUTPUT_KEY, (Object)ChatResultMetricVo.createResult((JSONObject)context, replyGetter, (ChatResult4MetricCode)resultCode));
    }
}

