/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.optimizer.rule;

import com.digiwin.chatbi.reasoning.optimizer.ast.CNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.StepNode;
import com.digiwin.chatbi.reasoning.optimizer.rule.OptimizationRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class R6RemoveUnreferencedFieldsRule
implements OptimizationRule {
    public boolean apply(List<StepNode> steps) {
        boolean changed = false;
        for (StepNode step : steps) {
            List groupByFields;
            List selectFields = step.getS() != null ? step.getS().getField() : null;
            if (selectFields == null || selectFields.isEmpty()) continue;
            Set referencedFields = this.collectReferencedFields(selectFields);
            CNode cNode = step.getC();
            if (cNode != null && cNode.getCalculations() != null) {
                Map calculations = cNode.getCalculations();
                HashMap newCalculations = new HashMap();
                for (Map.Entry entry : calculations.entrySet()) {
                    String key = (String)entry.getKey();
                    List exprs = (List)entry.getValue();
                    ArrayList<String> newExprs = new ArrayList<String>();
                    for (String expr : exprs) {
                        String alias;
                        String[] parts = expr.split("#");
                        if (parts.length < 2 || !referencedFields.contains(alias = parts[1])) continue;
                        newExprs.add(expr);
                    }
                    if (newExprs.isEmpty()) continue;
                    newCalculations.put(key, newExprs);
                }
                if (!newCalculations.equals(calculations)) {
                    cNode.setCalculations(newCalculations);
                    changed = true;
                }
            }
            if ((groupByFields = step.getG()) == null || groupByFields.isEmpty()) continue;
            ArrayList<String> newGroupByFields = new ArrayList<String>();
            for (String field : groupByFields) {
                if (!referencedFields.contains(field)) continue;
                newGroupByFields.add(field);
            }
            if (newGroupByFields.equals(groupByFields)) continue;
            step.setG(newGroupByFields.isEmpty() ? null : newGroupByFields);
            changed = true;
        }
        return changed;
    }

    private Set<String> collectReferencedFields(List<String> selectFields) {
        HashSet<String> fields = new HashSet<String>();
        for (String field : selectFields) {
            String[] parts = field.split("#");
            fields.add(parts[0]);
            if (parts.length < 2) continue;
            fields.add(parts[1]);
        }
        return fields;
    }

    public String getName() {
        return "R6: \u79fb\u9664\u672a\u88ab\u5f15\u7528\u5b57\u6bb5";
    }
}

