/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.optimizer.rule;

import com.digiwin.chatbi.reasoning.optimizer.ast.CNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.StepNode;
import com.digiwin.chatbi.reasoning.optimizer.ast.WNode;
import com.digiwin.chatbi.reasoning.optimizer.rule.OptimizationRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class R8MergeStepsRule
implements OptimizationRule {
    public boolean apply(List<StepNode> steps) {
        boolean changed = false;
        if (steps.size() < 2) {
            return false;
        }
        ArrayList<StepNode> newSteps = new ArrayList<StepNode>();
        int i = 0;
        while (i < steps.size()) {
            StepNode next;
            StepNode current = steps.get(i);
            if (i + 1 < steps.size() && this.canMerge(current, next = steps.get(i + 1))) {
                StepNode merged = this.mergeSteps(current, next);
                newSteps.add(merged);
                i += 2;
                changed = true;
                continue;
            }
            newSteps.add(current);
            ++i;
        }
        if (changed) {
            steps.clear();
            steps.addAll(newSteps);
        }
        return changed;
    }

    private boolean canMerge(StepNode step1, StepNode step2) {
        if (step1.getF() == null || step2.getF() == null || !step1.getF().equals((Object)step2.getF())) {
            return false;
        }
        if (step2.getJ() != null && !step2.getJ().isEmpty()) {
            return false;
        }
        if (step2.getG() != null && !step2.getG().isEmpty()) {
            return false;
        }
        if (step2.getH() != null) {
            return false;
        }
        if (step2.getO() != null && !step2.getO().isEmpty()) {
            return false;
        }
        if (step2.getL() != null && !step2.getL().isEmpty()) {
            return false;
        }
        return step2.getS() == null;
    }

    private StepNode mergeSteps(StepNode step1, StepNode step2) {
        StepNode merged = new StepNode();
        merged.setAs(step1.getAs());
        merged.setF(step1.getF());
        merged.setC(this.mergeCNode(step1.getC(), step2.getC()));
        merged.setJ(step1.getJ());
        merged.setG(step1.getG());
        merged.setW(this.mergeWNode(step1.getW(), step2.getW()));
        merged.setH(step1.getH());
        merged.setO(step1.getO());
        merged.setL(step1.getL());
        merged.setS(step1.getS());
        return merged;
    }

    private CNode mergeCNode(CNode c1, CNode c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        CNode merged = new CNode();
        HashMap calculations = new HashMap(c1.getCalculations());
        if (c2.getCalculations() != null) {
            for (Map.Entry entry : c2.getCalculations().entrySet()) {
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                if (calculations.containsKey(key)) {
                    ((List)calculations.get(key)).addAll(values);
                    continue;
                }
                calculations.put(key, new ArrayList(values));
            }
        }
        merged.setCalculations(calculations);
        return merged;
    }

    private WNode mergeWNode(WNode w1, WNode w2) {
        if (w1 == null) {
            return w2;
        }
        if (w2 == null) {
            return w1;
        }
        WNode merged = new WNode();
        HashMap conditions = new HashMap(w1.getConditions());
        if (w2.getConditions() != null) {
            conditions.putAll(w2.getConditions());
        }
        merged.setConditions(conditions);
        return merged;
    }

    public String getName() {
        return "R8: \u5408\u5e76\u76f8\u90bb\u6b65\u9aa4";
    }
}

