/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.pipeline;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.exception.PipelineAssert;
import com.digiwin.chatbi.common.util.MdcUtil;
import com.digiwin.chatbi.config.ThreadPoolManager;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.PipelineExecutor;
import com.digiwin.chatbi.reasoning.pipeline.PipelineWithoutTrace;
import com.digiwin.chatbi.reasoning.pipeline.condition.Condition;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PipelineWithoutTraceExecutor
extends PipelineExecutor {
    private static final Logger log = LoggerFactory.getLogger(PipelineWithoutTraceExecutor.class);
    private final JSONObject context = new JSONObject();
    private boolean finish = false;
    private Output lastOutput;

    public PipelineWithoutTraceExecutor execute(Executor ... executors) {
        if (this.finish) {
            return this;
        }
        if (executors == null || executors.length == 0) {
            return this;
        }
        HashMap currentTimeTracking = new HashMap();
        HashMap outputTrace = new HashMap();
        String ptxId = null;
        if (Objects.nonNull(this.context) && Objects.nonNull(this.context.get((Object)"question")) && this.context.get((Object)"question") instanceof Question) {
            ptxId = ((Question)this.context.getObject("question", Question.class)).getPtxId();
        }
        ExecutorService customThreadPool = ThreadPoolManager.getPipelineExecutorPool();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (Executor pipeline : executors) {
            if (!pipeline.onCondition(this.context)) continue;
            String finalPtxId = ptxId;
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                block11: {
                    try {
                        log.info("PipelineExecutor_execute_ptxId:{}", (Object)finalPtxId);
                        if (StringUtils.isNotEmpty((CharSequence)finalPtxId)) {
                            MdcUtil.setTraceId((String)finalPtxId);
                        }
                        Arrays.stream(pipeline.requiredParams()).forEach(requiredParam -> PipelineAssert.PIPE_LINE_PARAM_MISSING_ASSERT.isTrue(this.context.containsKey(requiredParam), new Object[0]));
                        Output output = (Output)PipelineAssert.PIPELINE_EXECUTE_FAIL_ASSERT.tryCatch(() -> {
                            StopWatch stopWatch = StopWatch.createStarted();
                            Output result = pipeline.doProcess(this.context);
                            stopWatch.stop();
                            log.info("Pipeline: " + pipeline.pipelineName() + " execution time: " + stopWatch.getTime() + "ms");
                            if (stopWatch.getTime() > 0L) {
                                currentTimeTracking.put(pipeline.pipelineName(), String.valueOf(stopWatch.getTime()));
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                                Date date = new Date(stopWatch.getStartTime());
                                String formattedDate = sdf.format(date);
                                currentTimeTracking.put(pipeline.pipelineName() + " startTime ", formattedDate);
                            }
                            outputTrace.put(pipeline.pipelineName(), result);
                            return result;
                        }, e -> {
                            log.error("Pipeline\u5f02\u5e38\uff1a{}", (Throwable)e);
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("error", e);
                            return Output.finish((JSONObject)jsonObject);
                        });
                        this.context.putAll((Map)output.getOutputContext());
                        PipelineWithoutTraceExecutor pipelineWithoutTraceExecutor = this;
                        synchronized (pipelineWithoutTraceExecutor) {
                            this.lastOutput = output;
                        }
                        if (!output.isEndpoint()) break block11;
                        pipelineWithoutTraceExecutor = this;
                        synchronized (pipelineWithoutTraceExecutor) {
                            this.finish = true;
                        }
                    }
                    finally {
                        if (StringUtils.isNotEmpty((CharSequence)finalPtxId)) {
                            MDC.clear();
                        }
                    }
                }
            }, customThreadPool);
            futures.add(future);
        }
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        try {
            allFutures.get();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("\u6267\u884c\u4efb\u52a1\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        if (!currentTimeTracking.isEmpty()) {
            PipelineWithoutTrace.addTimeTrace(currentTimeTracking);
        }
        if (!outputTrace.isEmpty()) {
            PipelineWithoutTrace.addOutputTrace(outputTrace);
        }
        return this;
    }

    public void executeWhen(Condition condition) {
        this.execute(condition.choose(this.context));
    }

    public PipelineWithoutTraceExecutor finallyExecute(Executor executor) {
        this.lastOutput = (Output)PipelineAssert.PIPELINE_EXECUTE_FAIL_ASSERT.tryCatch(() -> executor.doProcess(this.context), e -> {
            log.error("Pipeline\u5f02\u5e38\uff1a{}", (Throwable)e);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("error", e);
            return Output.finish((JSONObject)jsonObject);
        });
        this.context.putAll((Map)this.lastOutput.getOutputContext());
        return this;
    }

    public Output getResult() {
        return this.lastOutput;
    }

    public String toString() {
        return this.context.toJSONString();
    }
}

