/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.process;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.autoData.IntentionConfirmReq;
import com.digiwin.chatbi.beans.pojos.autoData.ReportCreateReq;
import com.digiwin.chatbi.reasoning.constant.Strategy;
import com.digiwin.chatbi.reasoning.context.SseContext;
import com.digiwin.chatbi.reasoning.pipeline.Pipeline;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.SseSendService4AutoData;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutoDataProcess {
    private static final Logger log = LoggerFactory.getLogger(AutoDataProcess.class);
    @Autowired
    private SseSendService4AutoData sseSendService;

    public JSONObject intentionConfirm(IntentionConfirmReq intentionConfirmReq) {
        Output output = Strategy.INTENTION_CONFIRM.getPipeline().accept("intentionConfirmReq", (Object)intentionConfirmReq);
        JSONObject res = output.getOutputContext().getJSONObject("finalResult");
        return res;
    }

    public JSONObject doReportCreate(ReportCreateReq req) {
        Output output = Strategy.REPORT_CREATE.getPipeline().accept("reportCreateReq", (Object)req);
        JSONObject res = output.getOutputContext().getJSONObject("finalResult");
        List timeTrace = Pipeline.getTimeTrace();
        List outputTrace = Pipeline.getOutputTrace();
        res.put("timeTrace", (Object)timeTrace);
        res.put("outputTrace", (Object)outputTrace);
        log.info("doReportCreate#res: {}", (Object)JSONObject.toJSONString((Object)res));
        return res;
    }

    public void doReportCreate4Stream(ReportCreateReq req) {
        JSONObject res = this.doReportCreate(req);
        res.remove((Object)"timeTrace");
        res.remove((Object)"outputTrace");
        this.sseSendService.sendResult(req.getId(), JSONObject.toJSONString((Object)res));
        SseContext.removeIntentionAnalysic((String)req.getId());
        SseContext.removePPTResult((String)req.getId());
        if (Objects.nonNull(SseContext.getSseEmitter((String)req.getId()))) {
            SseContext.getSseEmitter((String)req.getId()).complete();
        }
    }
}

