/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.process;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.common.util.MdcUtil;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogRecordUtil {
    private static final Logger log = LoggerFactory.getLogger(LogRecordUtil.class);

    public static void recordLog(List<Map<String, Output>> outputTrace) {
        LogRecordUtil.log.info("recordLog,\u5f53\u524d\u7684\u94fe\u8defid\uff1a{},mid:{}", (Object)MdcUtil.getTraceId(), (Object)MdcUtil.getMasterTraceId());
        ArrayList<CopyOnWriteArrayList> logs = new ArrayList<CopyOnWriteArrayList>();
        for (Map<String, Output> stringOutputMap : outputTrace) {
            for (Output value : stringOutputMap.values()) {
                if (!value.getOutputContext().containsKey((Object)"logCheckDtos")) continue;
                CopyOnWriteArrayList logCheckDtos = (CopyOnWriteArrayList)value.getOutputContext().getOrDefault((Object)"logCheckDtos", new CopyOnWriteArrayList());
                logs.add(logCheckDtos);
                value.getOutputContext().remove((Object)"logCheckDtos");
            }
        }
        CopyOnWriteArrayList logCheckDtos = logs.stream().max(Comparator.comparingInt(log -> log.size())).orElse(new CopyOnWriteArrayList());
        logCheckDtos = LogRecordUtil.updateErrorLogCode(logCheckDtos);
        for (LogCheckDto logCheckDto : logCheckDtos) {
            JSONObject input = new JSONObject();
            input.put("input", (Object)logCheckDto.getInput());
            JSONObject output = new JSONObject();
            output.put("output", (Object)logCheckDto.getResult());
            LogUtils.buildAgileLog((String)LogUtils.MODULE_SCRUMBI, (String)logCheckDto.getStep(), (String)logCheckDto.getCode(), (String)JSONObject.toJSONString((Object)input), (String)JSONObject.toJSONString((Object)output), (String)logCheckDto.getSuggestion());
        }
    }

    public static CopyOnWriteArrayList updateErrorLogCode(CopyOnWriteArrayList<LogCheckDto> logCheckDtos) {
        if (CollectionUtils.isEmpty(logCheckDtos)) {
            return logCheckDtos;
        }
        int lastZeroIndex = -1;
        try {
            int i;
            for (i = 0; i < logCheckDtos.size(); ++i) {
                LogCheckDto logCheckDto = logCheckDtos.get(i);
                if (LogUtils.WARING.equals(logCheckDto.getCode()) || LogUtils.SUCCESS.equals(logCheckDto.getCode())) continue;
                lastZeroIndex = i;
            }
            if (lastZeroIndex != -1) {
                for (i = 0; i < lastZeroIndex; ++i) {
                    if (LogUtils.WARING.equals(logCheckDtos.get(i).getCode()) || LogUtils.SUCCESS.equals(logCheckDtos.get(i).getCode())) continue;
                    logCheckDtos.get(i).setCode(LogUtils.WARING);
                }
            }
        }
        catch (Exception e) {
            log.error("updateErrorLogCode\u66f4\u65b0\u65e5\u5fd7code\u5f02\u5e38", (Throwable)e);
        }
        return logCheckDtos;
    }
}

