/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.prompt;

import com.digiwin.chatbi.common.exception.PromptAssert;
import com.digiwin.chatbi.common.util.TemplateBroker;
import com.digiwin.chatbi.reasoning.search.template.Dsl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class TemplateLocalFileBroker
implements TemplateBroker {
    private static final Logger log = LoggerFactory.getLogger(TemplateLocalFileBroker.class);

    @PostConstruct
    public void loadPrompts() {
        Resource[] resources = (Resource[])PromptAssert.PROMPT_LOAD_FILE_FAILED_ASSERT.tryCatch(() -> new PathMatchingResourcePatternResolver().getResources("classpath:prompts/**/*.prompt"), new Object[0]);
        this.put(Arrays.stream(resources).map(resource -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                String[] split = resource.getURI().toString().replace("/", "&&").replace("\\", "&&").split("&&");
                String type = split[split.length - 2];
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
                Dsl dsl = Dsl.New((String)Objects.requireNonNull(resource.getFilename()).replace(".prompt", ""), (String)type, (String)content.toString());
                return dsl;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get file from resource: " + resource, e);
            }
        }).collect(Collectors.toList()));
    }
}

