/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.retrieve;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.search.EsQueryExecutor;
import com.digiwin.chatbi.reasoning.search.dto.BulkDto;
import com.digiwin.chatbi.reasoning.search.facade.EsIndexFacade;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;

public enum Retrieve {
    TARGET("scrumbi_target", "MATCH_TARGET"),
    TARGET_NOQUESTION("scrumbi_target", "MATCH_TARGET_NOQUESTION"),
    TARGET_V2("scrumbi_target", "MATCH_TARGET_V2"),
    METRIC("scrumbi_metric", "MATCH_METRIC"),
    METRIC_V2("scrumbi_metric", "MATCH_METRIC_V2"),
    METRIC_ALIKE("scrumbi_metric", "MATCH_METRIC_ALIKE"),
    METRIC_NOQUESTION("scrumbi_metric", "MATCH_METRIC_NOQUESTION"),
    DIMENSION("scrumbi_dimension", "MATCH_DIMENSION"),
    TEMPLATE("scrumbi_template", "MATCH_TEMPLATE"),
    ENTITY("scrumbi_entity", "MATCH_ENTITY", "filter_path=hits.hits.fields,hits.hits.inner_hits.entity_collection.hits.hits"),
    WORDS("scrumbi_words", "MATCH_WORDS", "filter_path=hits.hits.fields,hits.hits.inner_hits.entity_collection.hits.hits"),
    WORDS_FOR_LONG("scrumbi_words", "MATCH_WORDS_FOR_LONG", "filter_path=hits.hits.fields,hits.hits.inner_hits.entity_collection.hits.hits"),
    WORDS_FOR_LOOOONG("scrumbi_words", "MATCH_WORDS_FOR_LOOOONG", "filter_path=hits.hits.fields,hits.hits.inner_hits.entity_collection.hits.hits"),
    APP_WORDS("scrumbi_app_words", "MATCH_APP_WORDS", "filter_path=hits.hits.fields,hits.hits.inner_hits.entity_collection.hits.hits"),
    APP_WORDS_FOR_LONG("scrumbi_app_words", "MATCH_APP_WORDS_FOR_LONG", "filter_path=hits.hits.fields,hits.hits.inner_hits.entity_collection.hits.hits"),
    TARGET_SEN("scrumbi_target", "GET_TARGET_SEN"),
    DIMENSION_ALL("scrumbi_dimension", "GET_TARGET_SEN"),
    DICTIONARY("scrumbi_dictionary", "MATCH_DICT"),
    FEW_SHOT("scrumbi_new_fewshot", "MATCH_FEWSHOT"),
    METRIC_FEW_SHOT("scrumbi_metric_fewshot", "MATCH_METRIC_FEWSHOT"),
    DATASET_V1_FEW_SHOT("scrumbi_dataset_v1_fewshot", "MATCH_METRIC_FEWSHOT"),
    DATASET_V2_FEW_SHOT("scrumbi_dataset_v2_fewshot", "MATCH_METRIC_FEWSHOT"),
    MOCK("scrumbi_mock", "GET_TARGET_SEN"),
    SCENE("scrumbi_scene", "MATCH_SCENE"),
    SCENE_AGG("scrumbi_scene", "MATCH_SCENE_AGG"),
    REPORT("scrumbi_report", "MATCH_REPORT"),
    SWITCH_CONFIG("scrumbi_switch_config", "MATCH_SWITCH_CONFIG"),
    Match_Rule_Pattern("scrumbi_{0}_pattern", "Match_Rule_Pattern"),
    DATASET_V1("scrumbi_dataset_v1", "MATCH_DATASET_V1"),
    DATASET_ALIKE_V1("scrumbi_dataset_v1", "MATCH_DATASET_ALIKE_V2"),
    DATASET_V2("scrumbi_dataset_v2", "MATCH_DATASET_V2"),
    DATASET_ALIKE_V2("scrumbi_dataset_v2", "MATCH_DATASET_ALIKE_V2"),
    NOUNKNOWLEDGE("scrumbi_nounknowledge", "MATCH_NOUNKNOWLEDGE"),
    NOUNKNOWLEDGE_FOR_LONG("scrumbi_nounknowledge", "MATCH_NOUNKNOWLEDGE_FOR_LONG"),
    HABITUALKNOWLEDGE("scrumbi_habitualknowledge", "MATCH_HABITUALKNOWLEDGE"),
    MATCH_TABLE_V2("scrumbi_dataset_v2", "MATCH_TABLE"),
    MATCH_ALL_TABLE_INFO_V2("scrumbi_dataset_v2", "MATCH_ALL_TABLE_INFO"),
    MATCH_TABLE_V1("scrumbi_dataset_v1", "MATCH_TABLE"),
    MATCH_ALL_TABLE_INFO_V1("scrumbi_dataset_v1", "MATCH_ALL_TABLE_INFO"),
    MATCH_TENANT_ENTITY("scrumbi_tenant_entity", "MATCH_TENANT_ENTITY"),
    MATCH_SIMILAR_QUESTION_V1("scrumbi_dataset_v1", "SIMILAR_QUESTION"),
    MATCH_SIMILAR_QUESTION_V2("scrumbi_dataset_v2", "SIMILAR_QUESTION");

    private String indexName;
    private final String dslName;
    private final String queryString;

    private Retrieve(String indexName, String dslName) {
        this.indexName = indexName;
        this.dslName = dslName;
        this.queryString = null;
    }

    public JSONObject retrieveQuestion(String question) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("use_question", (Object)question);
        return this.retrieve(jsonObject);
    }

    public JSONObject retrieveQuestion(String question, JSONObject context) {
        if (StringUtils.isEmpty((CharSequence)context.getString("use_question"))) {
            context.put("use_question", (Object)question);
        }
        return this.retrieve(context);
    }

    public JSONObject retrieveSentence(String ... fileds) {
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("fileds", (Object)fileds);
        return this.retrieve(paramsObject);
    }

    public JSONObject retrieveSentenceByApplicationCodes(List<String> applicationCodes, String version, String ... fileds) {
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("fileds", (Object)fileds);
        paramsObject.put("applicationCodes", applicationCodes);
        paramsObject.put("version", (Object)version);
        return this.retrieve(paramsObject);
    }

    public JSONObject retrieve(JSONObject param, Object ... indexPattern) {
        return ((EsQueryExecutor)SpringContextUtil.getBean(EsQueryExecutor.class)).queryByDslTemplate(MessageFormat.format(this.resetIndex(), indexPattern), this.dslName, (Map)param, this.queryString);
    }

    public JSONObject retrieve(JSONObject param) {
        return ((EsQueryExecutor)SpringContextUtil.getBean(EsQueryExecutor.class)).queryByDslTemplate(this.resetIndex(), this.dslName, (Map)param, this.queryString);
    }

    public JSONObject index(Function<JSONObject, String> id, JSONObject data) {
        return ((EsIndexFacade)SpringContextUtil.getBean(EsIndexFacade.class)).mergeById(this.resetIndex(), id.apply(data), data);
    }

    public JSONObject indexDoc(JSONObject data) {
        return ((EsIndexFacade)SpringContextUtil.getBean(EsIndexFacade.class)).insert(this.resetIndex(), data);
    }

    public JSONObject insertByIdDoc(JSONObject data, String id) {
        return ((EsIndexFacade)SpringContextUtil.getBean(EsIndexFacade.class)).insertById(this.resetIndex(), id, data, true);
    }

    public JSONObject bulkInsert(List<BulkDto> param) {
        return ((EsIndexFacade)SpringContextUtil.getBean(EsIndexFacade.class)).bulkInsert(this.resetIndex(), param);
    }

    public JSONObject update(String id, JSONObject data) {
        return ((EsIndexFacade)SpringContextUtil.getBean(EsIndexFacade.class)).updateById(this.resetIndex(), id, data);
    }

    public JSONObject update(Function<JSONObject, String> id, JSONObject data) {
        return ((EsIndexFacade)SpringContextUtil.getBean(EsIndexFacade.class)).updateById(this.resetIndex(), id.apply(data), data);
    }

    public JSONObject updateByQuery(JSONObject param) {
        return ((EsIndexFacade)SpringContextUtil.getBean(EsIndexFacade.class)).updateByQuery(this.resetIndex(), param);
    }

    public JSONObject deleteAll() {
        JSONObject matchJsonObject = new JSONObject();
        JSONObject queryJsonObject = new JSONObject();
        matchJsonObject.put("match_all", (Object)new JSONObject());
        queryJsonObject.put("query", (Object)matchJsonObject);
        return ((EsIndexFacade)SpringContextUtil.getBean(EsIndexFacade.class)).deleteByQuery(this.resetIndex(), queryJsonObject);
    }

    public JSONObject deleteByCondition(Map<String, String> condition, Boolean ifConcatKeyword) {
        if (Objects.isNull(condition)) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        condition.entrySet().forEach(e -> {
            JSONObject jsonObject = new JSONObject();
            JSONObject termJsonObject = new JSONObject();
            if (ifConcatKeyword.booleanValue()) {
                termJsonObject.put(((String)e.getKey()).concat(".keyword"), e.getValue());
            } else {
                termJsonObject.put((String)e.getKey(), e.getValue());
            }
            jsonObject.put("term", (Object)termJsonObject);
            jsonArray.add((Object)jsonObject);
        });
        JSONObject queryJsonObject = new JSONObject();
        JSONObject boolJsonObject = new JSONObject();
        JSONObject mustJsonObject = new JSONObject();
        mustJsonObject.put("must", (Object)jsonArray);
        boolJsonObject.put("bool", (Object)mustJsonObject);
        queryJsonObject.put("query", (Object)boolJsonObject);
        return ((EsIndexFacade)SpringContextUtil.getBean(EsIndexFacade.class)).deleteByQuery(this.resetIndex(), queryJsonObject);
    }

    public JSONObject deleteAllExceptId(List<String> valuesIn, List<JSONObject> applicationCodesAndVersions) {
        return this.deleteAllExcept("_id", valuesIn, applicationCodesAndVersions);
    }

    public JSONObject deleteAllExcept(String fieldName, List<String> valuesIn, List<JSONObject> applicationCodesAndVersions) {
        JSONObject param = new JSONObject();
        JSONObject query = new JSONObject();
        JSONObject bool = new JSONObject();
        JSONArray should = new JSONArray();
        for (JSONObject applicationCodesAndVersion : applicationCodesAndVersions) {
            JSONObject shouldParam = new JSONObject();
            JSONObject shouldBool = new JSONObject();
            JSONArray must = new JSONArray();
            JSONObject appCodeObject = new JSONObject();
            JSONObject mustTermObject = new JSONObject();
            appCodeObject.put("applicationCode.keyword", (Object)applicationCodesAndVersion.getString("applicationCode"));
            mustTermObject.put("term", (Object)appCodeObject);
            must.add((Object)mustTermObject);
            JSONObject termObject = new JSONObject();
            JSONObject versionObject = new JSONObject();
            versionObject.put("version.keyword", (Object)applicationCodesAndVersion.getString("version"));
            termObject.put("term", (Object)versionObject);
            must.add((Object)termObject);
            JSONObject mustNot = new JSONObject();
            JSONObject termsObject = new JSONObject();
            termsObject.put(fieldName, valuesIn);
            mustNot.put("terms", (Object)termsObject);
            shouldBool.put("must", (Object)must);
            shouldBool.put("must_not", (Object)mustNot);
            shouldParam.put("bool", (Object)shouldBool);
            should.add((Object)shouldParam);
        }
        bool.put("should", (Object)should);
        query.put("bool", (Object)bool);
        param.put("query", (Object)query);
        return ((EsIndexFacade)SpringContextUtil.getBean(EsIndexFacade.class)).deleteByQuery(this.resetIndex(), param);
    }

    public JSONObject deleteByConditionList(List<Map<String, String>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        list.forEach(condition -> {
            JSONArray terms = new JSONArray();
            condition.entrySet().forEach(e -> {
                JSONObject termObject = new JSONObject();
                JSONObject keyWordObject = new JSONObject();
                keyWordObject.put(((String)e.getKey()).concat(".keyword"), e.getValue());
                termObject.put("term", (Object)keyWordObject);
                terms.add((Object)termObject);
            });
            JSONObject jsonObject = new JSONObject();
            JSONObject mustObject = new JSONObject();
            mustObject.put("must", (Object)terms);
            jsonObject.put("bool", (Object)mustObject);
            jsonArray.add((Object)jsonObject);
        });
        JSONObject queryObject = new JSONObject();
        JSONObject boolObject = new JSONObject();
        JSONObject shouldObject = new JSONObject();
        shouldObject.put("should", (Object)jsonArray);
        boolObject.put("bool", (Object)shouldObject);
        queryObject.put("query", (Object)boolObject);
        return ((EsIndexFacade)SpringContextUtil.getBean(EsIndexFacade.class)).deleteByQuery(this.resetIndex(), queryObject);
    }

    public JSONObject deleteByConditionListWithOutKeyWord(List<Map<String, String>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        list.forEach(condition -> {
            JSONArray terms = new JSONArray();
            condition.entrySet().forEach(e -> {
                JSONObject termObject = new JSONObject();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((String)e.getKey(), e.getValue());
                termObject.put("term", (Object)jsonObject);
                terms.add((Object)termObject);
            });
            JSONObject mustJsonObject = new JSONObject();
            mustJsonObject.put("must", (Object)terms);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("bool", (Object)mustJsonObject);
            jsonArray.add((Object)jsonObject);
        });
        JSONObject queryObject = new JSONObject();
        JSONObject boolObject = new JSONObject();
        JSONObject shouldObject = new JSONObject();
        shouldObject.put("should", (Object)jsonArray);
        boolObject.put("bool", (Object)shouldObject);
        queryObject.put("query", (Object)boolObject);
        return ((EsIndexFacade)SpringContextUtil.getBean(EsIndexFacade.class)).deleteByQuery(this.resetIndex(), queryObject);
    }

    private String resetIndex() {
        Environment environment = (Environment)SpringContextUtil.getBean(Environment.class);
        String[] activeProfiles = environment.getActiveProfiles();
        if ("aliyun-paas".equals(activeProfiles[0])) {
            return this.indexName + "_paas";
        }
        if ("aliyun-test".equals(activeProfiles[0])) {
            return this.indexName + "_huzhou";
        }
        return this.indexName;
    }

    public JSONObject retrieveIndicatorByApplicationCodes(String question, List<String> applicationCodes, String version) {
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("version", (Object)version);
        if (StringUtils.isEmpty((CharSequence)question)) {
            paramsObject.put("use_question", null);
        } else {
            paramsObject.put("use_question", (Object)question);
        }
        paramsObject.put("applicationCodes", applicationCodes);
        return this.retrieve(paramsObject);
    }

    private Retrieve(String indexName, String dslName, String queryString) {
        this.indexName = indexName;
        this.dslName = dslName;
        this.queryString = queryString;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getDslName() {
        return this.dslName;
    }

    public String getQueryString() {
        return this.queryString;
    }
}

