/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.SysUserInfo;
import com.digiwin.chatbi.beans.vos.iam.Role;
import com.digiwin.chatbi.beans.vos.iam.TenantVo;
import com.digiwin.chatbi.common.IamServiceInvoker;
import com.digiwin.chatbi.common.UserThreadLocal;
import com.digiwin.chatbi.common.exception.BussinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="IamService")
public class IamService {
    @Autowired
    private IamServiceInvoker iamServiceInvoker;
    @Value(value="${tbb.user}")
    private String user;
    @Value(value="${tbb.password}")
    private String password;
    @Value(value="${tbb.pro-user}")
    private String proUser;
    @Value(value="${tbb.pro-password}")
    private String proPassword;
    @Value(value="${iam.url}")
    private String iamUrl;
    @Value(value="${iam.pro-url}")
    private String iamProUrl;
    @Value(value="${iam.url-login}")
    private String loginUrl;
    @Value(value="${iam.app-id}")
    private String appId;

    public Role getIamUserInfo(String token) throws Exception {
        Role role = this.iamServiceInvoker.iamUserPermissionInfo(token);
        return role;
    }

    public List<TenantVo> getTenants() throws Exception {
        SysUserInfo sysUserInfo = UserThreadLocal.get();
        return this.iamServiceInvoker.tenants(sysUserInfo.getTbbToken());
    }

    public JSONObject changeTenant(String tenantId) throws BussinessException {
        return this.iamServiceInvoker.changeTenant(tenantId);
    }

    public List<JSONObject> getUserHistoryMessage(String token, String routerKey, String sessionId, String asaCode) throws Exception {
        return this.iamServiceInvoker.getUserHistoryMessage(token, routerKey, sessionId, asaCode);
    }

    public List<JSONObject> getLastedUserHistoryMessage(String token, String routerKey, String sessionId, String asaCode) throws Exception {
        return this.iamServiceInvoker.getLastedUserHistoryMessage(token, routerKey, sessionId, asaCode);
    }

    public JSONObject getLastedUserHistoryMessageV2(String token, String routerKey, String conversationId, String asaCode, String messageId, String sectionId) throws Exception {
        return this.iamServiceInvoker.getLastedUserHistoryMessageV2(token, routerKey, conversationId, asaCode, messageId, sectionId);
    }

    public List<JSONObject> getUserHistoryMessageV2WithCount(String token, String routerKey, String conversationId, String asaCode, String messageId, String sectionId, int count) throws Exception {
        return this.iamServiceInvoker.getLastedUserHistoryMessageV2WithCount(token, routerKey, conversationId, asaCode, messageId, sectionId, count);
    }
}

