/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.KnowledgemapsServiceInvoker;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="KnowledgemapsService")
public class KnowledgemapsService {
    @Autowired
    private KnowledgemapsServiceInvoker knowledgemapsServiceInvoker;

    public JSONObject getTenantAppAndVersion(String token, String routerKey) throws Exception {
        return this.knowledgemapsServiceInvoker.getTenantAppAndVersion(token, routerKey);
    }

    public JSONObject getUserAppAndVersion(String token, String routerKey, String userId) throws Exception {
        return this.knowledgemapsServiceInvoker.getUserAppAndVersion(token, routerKey, userId);
    }

    public List<JSONObject> getKmScenes(JSONObject params, String locale, JSONObject context) {
        List res = this.knowledgemapsServiceInvoker.getKmScenes(params, locale);
        if (CollectionUtils.isNotEmpty((Collection)res)) {
            return res;
        }
        String token = ((Question)context.getObject("question", Question.class)).getToken();
        String routerKey = ((Question)context.getObject("question", Question.class)).getRouterKey();
        HashMap stringObjectHashMap = new HashMap(params);
        stringObjectHashMap.remove("applicationCodes");
        stringObjectHashMap.remove("version");
        stringObjectHashMap.remove("checkDimension");
        return this.knowledgemapsServiceInvoker.getKmScenes(stringObjectHashMap, locale, token, routerKey, context);
    }

    public JSONObject getSchemasBySceneCode(String sceneCode, JSONObject context) {
        JSONObject res = this.knowledgemapsServiceInvoker.getSchemasBySceneCode(sceneCode, context);
        if (!Objects.isNull(res)) {
            return res;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sceneCode", sceneCode);
        String token = ((Question)context.getObject("question", Question.class)).getToken();
        String routerKey = ((Question)context.getObject("question", Question.class)).getRouterKey();
        return this.knowledgemapsServiceInvoker.getSchemasBySceneCode(map, token, routerKey);
    }

    public JSONObject querySceneMaps(JSONObject params, JSONObject context) {
        JSONObject res = this.knowledgemapsServiceInvoker.querySceneMaps(params);
        if (!Objects.isNull(res)) {
            return res;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", params.getString("sceneCode"));
        String token = ((Question)context.getObject("question", Question.class)).getToken();
        String routerKey = ((Question)context.getObject("question", Question.class)).getRouterKey();
        return this.knowledgemapsServiceInvoker.querySceneMaps(map, token, routerKey, context);
    }

    public JSONObject queryPermissionSceneOrMetric(String token, String routerKey, String userId, List<String> appCodes, List<String> metricOrSceneCodes) throws Exception {
        return this.knowledgemapsServiceInvoker.queryPermissionSceneOrMetric(token, routerKey, userId, appCodes, metricOrSceneCodes);
    }

    public List<JSONObject> queryApplicationName(String token, List<String> appCodes) throws Exception {
        return this.knowledgemapsServiceInvoker.queryApplicationName(token, appCodes);
    }
}

