/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.EventData;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.beans.pojos.pPTGeneration.QuestionPlanningReq;
import com.digiwin.chatbi.common.enums.SseEventlEnum;
import com.digiwin.chatbi.common.enums.SseStepEnum;
import com.digiwin.chatbi.common.util.SseEmitterUtils;
import com.digiwin.chatbi.reasoning.context.SseContext;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SseSendService {
    private static final Logger log = LoggerFactory.getLogger(SseSendService.class);
    @Resource
    private Executor sseSendExecutor;
    @Value(value="${Analysic.Question.Title.Milliseconds:300}")
    private int analysicQuestionTitleMilliseconds;
    @Value(value="${AQDetail.PSTitle.Milliseconds:100}")
    private int aQDetailAndPSTitleMilliseconds;
    @Value(value="${Problem.Solving.Detail.Milliseconds:30}")
    private int problemSolvingDetailMilliseconds;

    public void asyncSendAnalysicQuestionTitle(Question question) {
        SseContext.initAnalysicQuestion((String)question.getId());
        String requestId = question.getId();
        CompletableFuture.runAsync(() -> {
            try {
                String answer = "zh_TW".equals(question.getLocale()) ? ZhConverterUtil.toTraditional((String)"\u95ee\u53e5\u5206\u6790\u63a8\u7406") : "\u95ee\u53e5\u5206\u6790\u63a8\u7406";
                String[] answerSplit = answer.split("");
                Boolean analysicQuestionState = SseContext.getAnalysicQuestionState((String)requestId);
                CountDownLatch analysicQuestionLatch = SseContext.getAnalysicQuestionLatch((String)requestId);
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.QUESTION_ANALYSIC_START.getCode());
                EventData analysicEventData = new EventData(SseEventlEnum.SCRUMBI_ANALYSIC.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANALYSIC.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer, "success");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)analysicEventData);
                analysicQuestionLatch.countDown();
            }
            catch (Exception e) {
                log.error("\u5f02\u6b65\u53d1\u9001\u95ee\u53e5\u5206\u6790\u63a8\u7406title\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }, this.sseSendExecutor);
    }

    public void asyncSendAQDetailAndSCTitle(Question question, String metricNames, boolean ifStream, JSONObject context) {
        this.buildQuestionAnalysicAndSchemasCheckTitle(context, question.getLocale(), metricNames, question.getMessage());
        if (!ifStream) {
            return;
        }
        this.asyncSendAnalysicQuestionTitle(question);
        SseContext.initSchemasCheck((String)question.getId());
        String requestId = question.getId();
        CompletableFuture.runAsync(() -> {
            try {
                SseContext.putAnalysicQuestionState((String)requestId, (Boolean)true);
                CountDownLatch analysicQuestionLatch = SseContext.getAnalysicQuestionLatch((String)requestId);
                boolean await = analysicQuestionLatch.await(60L, TimeUnit.SECONDS);
                if (await) {
                    log.info("asyncSendAQDetailAndSCTitleAwait\u6210\u529f");
                }
                String answer = "zh_TW".equals(question.getLocale()) ? ZhConverterUtil.toTraditional((String)("\u6211\u5c06\u95ee\u9898\u7406\u89e3\u4e3a\uff1a" + question.getMessage() + "\n" + "\u5c06\u5c1d\u8bd5\u7528" + metricNames + "\u6570\u636e\u96c6\u8fdb\u884c\u56de\u7b54")) : "\u6211\u5c06\u95ee\u9898\u7406\u89e3\u4e3a\uff1a" + question.getMessage() + "\n" + "\u5c06\u5c1d\u8bd5\u7528" + metricNames + "\u6570\u636e\u96c6\u8fdb\u884c\u56de\u7b54";
                String[] answerSplit = answer.split("");
                CountDownLatch schemasCheckLatch = SseContext.getSchemasCheckLatch((String)requestId);
                for (int i = 0; i < answerSplit.length; ++i) {
                    EventData analysicDetailEventData;
                    if (SseContext.getSchemasCheckState((String)requestId).booleanValue()) {
                        analysicDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.QUESTIONANALYSIC.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer.substring(i), "success");
                        SseEmitterUtils.sendEventData((String)question.getId(), (EventData)analysicDetailEventData);
                        break;
                    }
                    Thread.sleep(this.aQDetailAndPSTitleMilliseconds);
                    analysicDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.QUESTIONANALYSIC.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answerSplit[i], "success");
                    SseEmitterUtils.sendEventData((String)question.getId(), (EventData)analysicDetailEventData);
                }
                EventData analysicCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "success");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)analysicCompleateEventData);
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.QUESTION_ANALYSIC_COMPLEATE.getCode());
                String schemasCheckTitle = "zh_TW".equals(question.getLocale()) ? ZhConverterUtil.toTraditional((String)"\u5b57\u6bb5\u6821\u9a8c") : "\u5b57\u6bb5\u6821\u9a8c";
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.SCHEMAS_CHECK_START.getCode());
                EventData schemasCheckTitleEventData = new EventData(SseEventlEnum.SCRUMBI_ANALYSIC.getEvent(), SseEventlEnum.SseEventDataTypeEnum.SCHEMASCHECK.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), schemasCheckTitle, "success");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)schemasCheckTitleEventData);
                schemasCheckLatch.countDown();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u5f02\u6b65\u53d1\u9001\u95ee\u53e5\u5206\u6790\u63a8\u7406\u5185\u5bb9\u548c\u6784\u5efa\u89e3\u9898\u601d\u8def\u6807\u9898\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }, this.sseSendExecutor);
    }

    public void asyncSendSCDetailAndPSTitle(Question question, Boolean schemasCheckResult, Boolean ifStream, JSONObject context) {
        this.buidlSchemasCheckDetailAndQuestionWayTitle(context, schemasCheckResult, question.getLocale());
        if (!ifStream.booleanValue()) {
            return;
        }
        SseContext.initProblemSolving((String)question.getId());
        String requestId = question.getId();
        CompletableFuture.runAsync(() -> {
            try {
                SseContext.putSchemasCheckState((String)requestId, (Boolean)true);
                CountDownLatch schemasCheckLatch = SseContext.getSchemasCheckLatch((String)requestId);
                boolean await = schemasCheckLatch.await(60L, TimeUnit.SECONDS);
                if (await) {
                    log.info("asyncSendSCDetailAndPSTitleAwait\u6210\u529f");
                }
                String schemasCheckDetail = schemasCheckResult != false ? "\u5b57\u6bb5\u6821\u9a8c\u6210\u529f" : "\u5b57\u6bb5\u6821\u9a8c\u5931\u8d25";
                String answer = "zh_TW".equals(question.getLocale()) ? ZhConverterUtil.toTraditional((String)schemasCheckDetail) : schemasCheckDetail;
                CountDownLatch problemSolvingLatch = SseContext.getProblemSolvingLatch((String)requestId);
                EventData analysicDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.SCHEMASCHECK.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer, "success");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)analysicDetailEventData);
                EventData analysicCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, schemasCheckResult != false ? "success" : "fail");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)analysicCompleateEventData);
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.SCHEMAS_CHECK_COMPLEATE.getCode());
                if (!schemasCheckResult.booleanValue()) {
                    problemSolvingLatch.countDown();
                    return;
                }
                String problemSolvingTitle = "zh_TW".equals(question.getLocale()) ? ZhConverterUtil.toTraditional((String)"\u6784\u5efa\u89e3\u9898\u601d\u8def") : "\u6784\u5efa\u89e3\u9898\u601d\u8def";
                String[] problemSolvingTitleSplit = problemSolvingTitle.split("");
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.QUESTION_WAY_START.getCode());
                EventData problemSolvingTitleEventData = new EventData(SseEventlEnum.SCRUMBI_ANALYSIC.getEvent(), SseEventlEnum.SseEventDataTypeEnum.QUESTIONWAY.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), problemSolvingTitle, "success");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)problemSolvingTitleEventData);
                problemSolvingLatch.countDown();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u5f02\u6b65\u53d1\u9001\u95ee\u53e5\u5206\u6790\u63a8\u7406\u5185\u5bb9\u548c\u6784\u5efa\u89e3\u9898\u601d\u8def\u6807\u9898\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }, this.sseSendExecutor);
    }

    public void asyncSendProblemSolvingDetail(Question question, String msg, Boolean ifStream, JSONObject context) {
        this.buildProblemSolvingDetail(context, msg, question.getLocale());
        if (!ifStream.booleanValue()) {
            return;
        }
        SseContext.initReturnResult((String)question.getId());
        String requestId = question.getId();
        CompletableFuture.runAsync(() -> {
            try {
                SseContext.putProblemSolvingState((String)requestId, (Boolean)true);
                CountDownLatch problemSolvingLatch = SseContext.getProblemSolvingLatch((String)requestId);
                boolean await = problemSolvingLatch.await(60L, TimeUnit.SECONDS);
                if (await) {
                    log.info("asyncSendProblemSolvingDetailAwait\u6210\u529f");
                }
                String answer = "zh_TW".equals(question.getLocale()) ? ZhConverterUtil.toTraditional((String)msg) : msg;
                String[] answerSplit = answer.split("");
                CountDownLatch returnResultLatch = SseContext.getReturnResultLatch((String)requestId);
                for (int i = 0; i < answerSplit.length; ++i) {
                    EventData problemSolvingDetailEventData;
                    if (SseContext.getReturnResultStateState((String)requestId).booleanValue()) {
                        problemSolvingDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.QUESTIONWAY.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer.substring(i), "success");
                        SseEmitterUtils.sendEventData((String)question.getId(), (EventData)problemSolvingDetailEventData);
                        break;
                    }
                    Thread.sleep(this.problemSolvingDetailMilliseconds);
                    problemSolvingDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.QUESTIONWAY.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answerSplit[i], "success");
                    SseEmitterUtils.sendEventData((String)question.getId(), (EventData)problemSolvingDetailEventData);
                }
                EventData problemSolvingCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "success");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)problemSolvingCompleateEventData);
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.QUESTION_WAY_COMPLEATE.getCode());
                returnResultLatch.countDown();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u5f02\u6b65\u53d1\u9001\u6784\u5efa\u89e3\u9898\u601d\u8def\u5185\u5bb9\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }, this.sseSendExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResult(Question question, String res) {
        try {
            EventData problemSolvingCompleateEventData;
            boolean await;
            CountDownLatch returnResultLatch;
            boolean await2;
            CountDownLatch problemSolvingLatch;
            boolean await3;
            CountDownLatch schemasCheckLatch;
            boolean await4;
            String requestId = question.getId();
            SseContext.putAnalysicQuestionState((String)requestId, (Boolean)true);
            SseContext.putSchemasCheckState((String)requestId, (Boolean)true);
            SseContext.putProblemSolvingState((String)requestId, (Boolean)true);
            SseContext.putReturnResultStateState((String)requestId, (Boolean)true);
            CountDownLatch analysicQuestionLatch = SseContext.getAnalysicQuestionLatch((String)requestId);
            if (Objects.nonNull(analysicQuestionLatch) && (await4 = analysicQuestionLatch.await(60L, TimeUnit.SECONDS))) {
                log.info("analysicQuestionLatch\u6210\u529f");
            }
            if (Objects.nonNull(schemasCheckLatch = SseContext.getSchemasCheckLatch((String)requestId)) && (await3 = schemasCheckLatch.await(60L, TimeUnit.SECONDS))) {
                log.info("schemasCheckLatch\u6210\u529f");
            }
            if (Objects.nonNull(problemSolvingLatch = SseContext.getProblemSolvingLatch((String)requestId)) && (await2 = problemSolvingLatch.await(60L, TimeUnit.SECONDS))) {
                log.info("problemSolvingLatch\u6210\u529f");
            }
            if (Objects.nonNull(returnResultLatch = SseContext.getReturnResultLatch((String)requestId)) && (await = returnResultLatch.await(60L, TimeUnit.SECONDS))) {
                log.info("returnResultLatch\u6210\u529f");
            }
            String sseStep = SseContext.getSseStep((String)requestId);
            if (SseStepEnum.QUESTION_ANALYSIC_START.getCode().equalsIgnoreCase(sseStep)) {
                EventData analysicCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "fail");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)analysicCompleateEventData);
            } else if (SseStepEnum.SCHEMAS_CHECK_START.getCode().equalsIgnoreCase(sseStep)) {
                problemSolvingCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "fail");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)problemSolvingCompleateEventData);
            } else if (SseStepEnum.QUESTION_WAY_START.getCode().equalsIgnoreCase(sseStep)) {
                problemSolvingCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "fail");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)problemSolvingCompleateEventData);
            }
            SseContext.putSseStep((String)requestId, (String)SseStepEnum.RESULT.getCode());
            EventData resultEventData = new EventData(SseEventlEnum.SCRUMBI_RESULT.getEvent(), SseEventlEnum.SseEventDataTypeEnum.RESULT.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), res, "success");
            SseEmitterUtils.sendEventData((String)question.getId(), (EventData)resultEventData);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("\u5f02\u6b65\u53d1\u9001\u6700\u7ec8\u7ed3\u679c\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        finally {
            EventData doneEventData = new EventData(SseEventlEnum.SCRUMBI_DONE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "success");
            SseEmitterUtils.sendEventData((String)question.getId(), (EventData)doneEventData);
        }
    }

    public void asyncSendIntentionAnalysicTitle(QuestionPlanningReq question) {
        SseContext.initIntentionAnalysic((String)question.getId());
        String requestId = question.getId();
        CompletableFuture.runAsync(() -> {
            try {
                String answer = "zh_TW".equals(question.getLocale()) ? ZhConverterUtil.toTraditional((String)"\u610f\u56fe\u89e3\u8bfb\u5206\u6790") : "\u610f\u56fe\u89e3\u8bfb\u5206\u6790";
                CountDownLatch analysicQuestionLatch = SseContext.getIntentionAnalysicLatch((String)requestId);
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.INTENTION_ANALYSIC_START.getCode());
                EventData analysicEventData = new EventData(SseEventlEnum.SCRUMBI_ANALYSIC.getEvent(), SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer, "success");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)analysicEventData);
                analysicQuestionLatch.countDown();
            }
            catch (Exception e) {
                log.error("\u5f02\u6b65\u53d1\u9001\u95ee\u53e5\u5206\u6790\u63a8\u7406title\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }, this.sseSendExecutor);
    }

    public void asyncSendIntentionAnalysicDetail(QuestionPlanningReq question, String msg, Boolean intentionAnalysicRes, Boolean ifStream, JSONObject context) {
        this.buildIntentionAnalysicDetail(context, msg, question.getLocale(), intentionAnalysicRes);
        if (!ifStream.booleanValue()) {
            return;
        }
        this.asyncSendIntentionAnalysicTitle(question);
        SseContext.initPPTResult((String)question.getId());
        String requestId = question.getId();
        CompletableFuture.runAsync(() -> {
            try {
                SseContext.putIntentionAnalysicState((String)requestId, (Boolean)true);
                CountDownLatch intentionAnalysicLatch = SseContext.getIntentionAnalysicLatch((String)requestId);
                boolean await = intentionAnalysicLatch.await(60L, TimeUnit.SECONDS);
                if (await) {
                    log.info("\u610f\u56fe\u89e3\u6790\u6807\u9898\u53d1\u9001\u6210\u529f");
                }
                String answer = "zh_TW".equals(question.getLocale()) ? ZhConverterUtil.toTraditional((String)msg) : msg;
                String[] answerSplit = answer.split("");
                CountDownLatch returnResultLatch = SseContext.getPPTResultLatch((String)requestId);
                for (int i = 0; i < answerSplit.length; ++i) {
                    EventData intentionAnalysicDetailEventData;
                    if (SseContext.getPPTResultStateState((String)requestId).booleanValue()) {
                        intentionAnalysicDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer.substring(i), intentionAnalysicRes != false ? "success" : "fail");
                        SseEmitterUtils.sendEventData((String)question.getId(), (EventData)intentionAnalysicDetailEventData);
                        break;
                    }
                    Thread.sleep(this.problemSolvingDetailMilliseconds);
                    intentionAnalysicDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answerSplit[i], intentionAnalysicRes != false ? "success" : "fail");
                    SseEmitterUtils.sendEventData((String)question.getId(), (EventData)intentionAnalysicDetailEventData);
                }
                EventData intentionAnalysicCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, intentionAnalysicRes != false ? "success" : "fail");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)intentionAnalysicCompleateEventData);
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.INTENTION_ANALYSIC_COMPLEATE.getCode());
                returnResultLatch.countDown();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u5f02\u6b65\u53d1\u9001\u610f\u56fe\u89e3\u6790\u5185\u5bb9\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }, this.sseSendExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPPTResult(QuestionPlanningReq question, String res) {
        try {
            boolean await;
            CountDownLatch pPTResultLatch;
            boolean await2;
            String requestId = question.getId();
            SseContext.putIntentionAnalysicState((String)requestId, (Boolean)true);
            SseContext.putPPTResultStateState((String)requestId, (Boolean)true);
            CountDownLatch intentionAnalysicLatch = SseContext.getIntentionAnalysicLatch((String)requestId);
            if (Objects.nonNull(intentionAnalysicLatch) && (await2 = intentionAnalysicLatch.await(60L, TimeUnit.SECONDS))) {
                log.info("intentionAnalysicLatch\u6210\u529f");
            }
            if (Objects.nonNull(pPTResultLatch = SseContext.getPPTResultLatch((String)requestId)) && (await = pPTResultLatch.await(60L, TimeUnit.SECONDS))) {
                log.info("PPTResultLatch\u6210\u529f");
            }
            String sseStep = SseContext.getSseStep((String)requestId);
            if (SseStepEnum.INTENTION_ANALYSIC_START.getCode().equalsIgnoreCase(sseStep)) {
                EventData analysicCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "fail");
                SseEmitterUtils.sendEventData((String)question.getId(), (EventData)analysicCompleateEventData);
            }
            SseContext.putSseStep((String)requestId, (String)SseStepEnum.RESULT.getCode());
            EventData resultEventData = new EventData(SseEventlEnum.SCRUMBI_RESULT.getEvent(), SseEventlEnum.SseEventDataTypeEnum.RESULT.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), res, "success");
            SseEmitterUtils.sendEventData((String)question.getId(), (EventData)resultEventData);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("\u5f02\u6b65\u53d1\u9001\u6700\u7ec8\u7ed3\u679c\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        finally {
            EventData doneEventData = new EventData(SseEventlEnum.SCRUMBI_DONE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "success");
            SseEmitterUtils.sendEventData((String)question.getId(), (EventData)doneEventData);
        }
    }

    private void buildQuestionAnalysicAndSchemasCheckTitle(JSONObject context, String locale, String dataSetNames, String msg) {
        JSONObject processStreamData = (JSONObject)context.getOrDefault((Object)"processStreamData", (Object)new JSONObject());
        String detail = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)("\u6211\u5c06\u95ee\u9898\u7406\u89e3\u4e3a\uff1a" + msg + "\n" + "\u5c06\u5c1d\u8bd5\u7528" + dataSetNames + "\u6570\u636e\u96c6\u8fdb\u884c\u56de\u7b54")) : "\u6211\u5c06\u95ee\u9898\u7406\u89e3\u4e3a\uff1a" + msg + "\n" + "\u5c06\u5c1d\u8bd5\u7528" + dataSetNames + "\u6570\u636e\u96c6\u8fdb\u884c\u56de\u7b54";
        String questionAnalysicTitle = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"\u95ee\u53e5\u5206\u6790\u63a8\u7406") : "\u95ee\u53e5\u5206\u6790\u63a8\u7406";
        JSONObject questionAnalysic = new JSONObject();
        questionAnalysic.put("title", (Object)questionAnalysicTitle);
        questionAnalysic.put("content", (Object)detail);
        questionAnalysic.put("status", (Object)true);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.QUESTIONANALYSIC.getType(), (Object)questionAnalysic);
        String schemasCheckTitle = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"\u5b57\u6bb5\u6821\u9a8c") : "\u5b57\u6bb5\u6821\u9a8c";
        JSONObject schemasCheck = new JSONObject();
        schemasCheck.put("title", (Object)schemasCheckTitle);
        schemasCheck.put("status", (Object)false);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.SCHEMASCHECK.getType(), (Object)schemasCheck);
        context.put("processStreamData", (Object)processStreamData);
    }

    private void buidlSchemasCheckDetailAndQuestionWayTitle(JSONObject context, Boolean res, String locale) {
        JSONObject processStreamData = (JSONObject)context.getOrDefault((Object)"processStreamData", (Object)new JSONObject());
        String schemasCheckDetail = res != false ? "\u5b57\u6bb5\u6821\u9a8c\u6210\u529f" : "\u5b57\u6bb5\u6821\u9a8c\u5931\u8d25";
        schemasCheckDetail = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)schemasCheckDetail) : schemasCheckDetail;
        JSONObject schemasCheck = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.SCHEMASCHECK.getType(), (Object)new JSONObject());
        schemasCheck.put("content", (Object)schemasCheckDetail);
        schemasCheck.put("status", (Object)res);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.SCHEMASCHECK.getType(), (Object)schemasCheck);
        if (!res.booleanValue()) {
            context.put("processStreamData", (Object)processStreamData);
            return;
        }
        String problemSolvingTitle = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"\u6784\u5efa\u89e3\u9898\u601d\u8def") : "\u6784\u5efa\u89e3\u9898\u601d\u8def";
        JSONObject questionWay = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.QUESTIONWAY.getType(), (Object)new JSONObject());
        questionWay.put("title", (Object)problemSolvingTitle);
        questionWay.put("status", (Object)false);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.QUESTIONWAY.getType(), (Object)questionWay);
        context.put("processStreamData", (Object)processStreamData);
    }

    private void buildProblemSolvingDetail(JSONObject context, String msg, String locale) {
        JSONObject processStreamData = (JSONObject)context.getOrDefault((Object)"processStreamData", (Object)new JSONObject());
        String detail = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)msg) : msg;
        JSONObject questionWay = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.QUESTIONWAY.getType(), (Object)new JSONObject());
        questionWay.put("content", (Object)detail);
        questionWay.put("status", (Object)true);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.QUESTIONWAY.getType(), (Object)questionWay);
        context.put("processStreamData", (Object)processStreamData);
    }

    private void buildIntentionAnalysicDetail(JSONObject context, String msg, String locale, Boolean intentionAnalysicRes) {
        JSONObject processStreamData = (JSONObject)context.getOrDefault((Object)"processStreamData", (Object)new JSONObject());
        String detail = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)msg) : msg;
        JSONObject intentionAnalysis = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS.getType(), (Object)new JSONObject());
        intentionAnalysis.put("content", (Object)detail);
        intentionAnalysis.put("status", (Object)intentionAnalysicRes);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS.getType(), (Object)intentionAnalysis);
        context.put("processStreamData", (Object)processStreamData);
    }
}

