/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.EventData;
import com.digiwin.chatbi.common.enums.SseEventlEnum;
import com.digiwin.chatbi.common.enums.SseStepEnum;
import com.digiwin.chatbi.common.util.SseEmitterUtils;
import com.digiwin.chatbi.reasoning.context.SseContext;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SseSendService4AutoData {
    private static final Logger log = LoggerFactory.getLogger(SseSendService4AutoData.class);
    @Resource
    private Executor sseSendExecutor;
    private static int otherMilliseconds = 100;
    private static int TPMilliseconds = 350;
    private static int dataQueryMilliseconds = 10;

    public void asyncSendIntentionAnalysicTitle4AutoData(String requestId, String locale) {
        SseContext.initIntentionAnalysic4AutoData((String)requestId);
        CompletableFuture.runAsync(() -> {
            try {
                String answer = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"# \u610f\u56fe\u5206\u6790\n") : "# \u610f\u56fe\u5206\u6790\n";
                CountDownLatch latch = SseContext.getIntentionAnalysic4AutoDataLatch((String)requestId);
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.INTENTION_ANALYSIC_4_AUTODATA_START.getCode());
                EventData analysicEventData = new EventData(SseEventlEnum.SCRUMBI_ANALYSIC.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANALYSIC.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer, "success");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)analysicEventData);
                latch.countDown();
            }
            catch (Exception e) {
                log.error("\u5f02\u6b65\u53d1\u9001\u610f\u56fe\u5206\u6790title\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }, this.sseSendExecutor);
    }

    public void asyncSendIADetailAndTPTitle(String requestId, String msg, String locale, boolean ifStream, JSONObject context) {
        msg = msg + "\n";
        this.buildIntentionAnalysicAndTaskPlanTitle(context, locale, msg);
        if (!ifStream) {
            return;
        }
        this.asyncSendIntentionAnalysicTitle4AutoData(requestId, locale);
        SseContext.initTaskPlan((String)requestId);
        String finalMsg = msg;
        CompletableFuture.runAsync(() -> {
            try {
                SseContext.putIntentionAnalysicState4AutoData((String)requestId, (Boolean)true);
                CountDownLatch intentionAnalysic4AutoDataLatch = SseContext.getIntentionAnalysic4AutoDataLatch((String)requestId);
                boolean await = intentionAnalysic4AutoDataLatch.await(60L, TimeUnit.SECONDS);
                if (await) {
                    log.info("asyncSendIADetailAndTPTitleAwait\u6210\u529f");
                }
                String answer = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)finalMsg) : finalMsg;
                String[] answerSplit = answer.split("");
                CountDownLatch taskPlanLatch = SseContext.getTaskPlanLatch((String)requestId);
                for (int i = 0; i < answerSplit.length; ++i) {
                    EventData analysicDetailEventData;
                    if (SseContext.getTaskPlanState((String)requestId).booleanValue()) {
                        analysicDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS_4_AUTODATA.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer.substring(i), "success");
                        SseEmitterUtils.sendEventData((String)requestId, (EventData)analysicDetailEventData);
                        break;
                    }
                    Thread.sleep(otherMilliseconds);
                    analysicDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS_4_AUTODATA.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answerSplit[i], "success");
                    SseEmitterUtils.sendEventData((String)requestId, (EventData)analysicDetailEventData);
                }
                EventData analysicCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "success");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)analysicCompleateEventData);
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.INTENTION_ANALYSIC_4_AUTODATA_COMPLEATE.getCode());
                String taskPlanTitle = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"\n# \u4efb\u52a1\u89c4\u5212\n") : "\n# \u4efb\u52a1\u89c4\u5212\n";
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.TASK_PLAN_START.getCode());
                EventData taskPlanTitleEventData = new EventData(SseEventlEnum.SCRUMBI_ANALYSIC.getEvent(), SseEventlEnum.SseEventDataTypeEnum.TASK_PLAN.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), taskPlanTitle, "success");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)taskPlanTitleEventData);
                taskPlanLatch.countDown();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u5f02\u6b65\u53d1\u9001\u610f\u56fe\u5206\u6790\u5185\u5bb9\u548c\u4efb\u52a1\u89c4\u5212\u6807\u9898\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }, this.sseSendExecutor);
    }

    public void asyncSendTPDetailAndDQTitle(String requestId, String tasks, String locale, Boolean ifStream, JSONObject context) {
        tasks = tasks + "\n";
        this.buildTaskPlanDetailAndDataQueryTitle(context, locale, tasks);
        if (!ifStream.booleanValue()) {
            return;
        }
        SseContext.initDataQuery((String)requestId);
        String finalTasks = tasks;
        CompletableFuture.runAsync(() -> {
            try {
                SseContext.putTaskPlanState((String)requestId, (Boolean)true);
                CountDownLatch taskPlanLatch = SseContext.getTaskPlanLatch((String)requestId);
                boolean await = taskPlanLatch.await(60L, TimeUnit.SECONDS);
                if (await) {
                    log.info("asyncSendTPDetailAndDQTitleAwait\u6210\u529f");
                }
                String answer = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)finalTasks) : finalTasks;
                String[] answerSplit = answer.split("");
                CountDownLatch dataQueryLatch = SseContext.getDataQueryLatch((String)requestId);
                for (int i = 0; i < answerSplit.length; ++i) {
                    EventData taskDetailEventData;
                    if (SseContext.getDataQueryState((String)requestId).booleanValue()) {
                        taskDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.TASK_PLAN.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer, "success");
                        SseEmitterUtils.sendEventData((String)requestId, (EventData)taskDetailEventData);
                        break;
                    }
                    Thread.sleep(TPMilliseconds);
                    taskDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.TASK_PLAN.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answerSplit[i], "success");
                    SseEmitterUtils.sendEventData((String)requestId, (EventData)taskDetailEventData);
                }
                EventData analysicCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "success");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)analysicCompleateEventData);
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.TASK_PLAN_COMPLEATE.getCode());
                String dataQueryTitle = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"# \u6570\u636e\u67e5\u8be2\n") : "# \u6570\u636e\u67e5\u8be2\n";
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.DATA_QUERY_START.getCode());
                EventData dataQueryTitleEventData = new EventData(SseEventlEnum.SCRUMBI_ANALYSIC.getEvent(), SseEventlEnum.SseEventDataTypeEnum.DATA_QUERY.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), dataQueryTitle, "success");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)dataQueryTitleEventData);
                dataQueryLatch.countDown();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u5f02\u6b65\u53d1\u9001\u95ee\u53e5\u5206\u6790\u63a8\u7406\u5185\u5bb9\u548c\u6784\u5efa\u89e3\u9898\u601d\u8def\u6807\u9898\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }, this.sseSendExecutor);
    }

    public void asyncSendDQDetailAndFATitle(String requestId, String msg, String locale, Boolean ifStream, JSONObject context) {
        log.info("\u5f00\u59cb\u8ba1\u7b97\u65f6\u95f41");
        msg = msg + "\n";
        this.buildDataQueryDetailAndFusionTitle(context, locale, msg);
        if (!ifStream.booleanValue()) {
            return;
        }
        SseContext.initDataFusionAnalysis((String)requestId);
        String finalMsg = msg;
        CompletableFuture.runAsync(() -> {
            try {
                log.info("\u5f00\u59cb\u8ba1\u7b97\u65f6\u95f42");
                SseContext.putDataQueryState((String)requestId, (Boolean)true);
                CountDownLatch dataQueryLatch = SseContext.getDataQueryLatch((String)requestId);
                boolean await = dataQueryLatch.await(60L, TimeUnit.SECONDS);
                if (await) {
                    log.info("asyncSendDQDetailAndFATitle\u6210\u529f");
                }
                log.info("\u5f00\u59cb\u8ba1\u7b97\u65f6\u95f43");
                String answer = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)finalMsg) : finalMsg;
                String[] answerSplit = answer.split("");
                CountDownLatch dataFusionAnalysisLatch = SseContext.getDataFusionAnalysisLatch((String)requestId);
                for (int i = 0; i < answerSplit.length; ++i) {
                    EventData dataQueryEventData;
                    if (SseContext.getDataFusionAnalysisState((String)requestId).booleanValue()) {
                        dataQueryEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.DATA_QUERY.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer, "success");
                        SseEmitterUtils.sendEventData((String)requestId, (EventData)dataQueryEventData);
                        break;
                    }
                    Thread.sleep(dataQueryMilliseconds);
                    dataQueryEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.DATA_QUERY.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answerSplit[i], "success");
                    SseEmitterUtils.sendEventData((String)requestId, (EventData)dataQueryEventData);
                }
                EventData analysicCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "success");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)analysicCompleateEventData);
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.DATA_QUERY_COMPLEATE.getCode());
                String dataFusionAnalysicTitle = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"# \u6570\u636e\u878d\u5408\u5206\u6790\n") : "# \u6570\u636e\u878d\u5408\u5206\u6790\n";
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.DATA_FUSION_ANALYSIS_START.getCode());
                EventData dataFusionAnalysisTitleEventData = new EventData(SseEventlEnum.SCRUMBI_ANALYSIC.getEvent(), SseEventlEnum.SseEventDataTypeEnum.DATA_FUSION_ANALYSIS.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), dataFusionAnalysicTitle, "success");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)dataFusionAnalysisTitleEventData);
                dataFusionAnalysisLatch.countDown();
                log.info("\u5f00\u59cb\u8ba1\u7b97\u65f6\u95f44");
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u5f02\u6b65\u53d1\u9001\u95ee\u53e5\u5206\u6790\u63a8\u7406\u5185\u5bb9\u548c\u6784\u5efa\u89e3\u9898\u601d\u8def\u6807\u9898\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }, this.sseSendExecutor);
    }

    public void asyncSendFADetailAndRGTitle(String requestId, String msg, String locale, Boolean ifStream, JSONObject context) {
        msg = msg + "\n";
        this.buildFusionAnalysicDetailAndReportGenerationTitle(context, locale, msg);
        if (!ifStream.booleanValue()) {
            return;
        }
        SseContext.initReportGenerate((String)requestId);
        String finalMsg = msg;
        CompletableFuture.runAsync(() -> {
            try {
                SseContext.putDataFusionAnalysisState((String)requestId, (Boolean)true);
                CountDownLatch dataFusionAnalysisLatch = SseContext.getDataFusionAnalysisLatch((String)requestId);
                boolean await = dataFusionAnalysisLatch.await(60L, TimeUnit.SECONDS);
                if (await) {
                    log.info("asyncSendFADetailAndRGTitle\u6210\u529f");
                }
                String answer = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)finalMsg) : finalMsg;
                String[] answerSplit = answer.split("");
                CountDownLatch reportGenerateLatch = SseContext.getReportGenerateLatch((String)requestId);
                for (int i = 0; i < answerSplit.length; ++i) {
                    EventData dataFusionAnalysisEventData;
                    if (SseContext.getReportGenerateState((String)requestId).booleanValue()) {
                        dataFusionAnalysisEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.DATA_FUSION_ANALYSIS.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer, "success");
                        SseEmitterUtils.sendEventData((String)requestId, (EventData)dataFusionAnalysisEventData);
                        break;
                    }
                    Thread.sleep(otherMilliseconds);
                    dataFusionAnalysisEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.DATA_FUSION_ANALYSIS.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answerSplit[i], "success");
                    SseEmitterUtils.sendEventData((String)requestId, (EventData)dataFusionAnalysisEventData);
                }
                EventData analysicCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "success");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)analysicCompleateEventData);
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.DATA_FUSION_ANALYSIS_COMPLEATE.getCode());
                String reportGenerationTitle = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"\n# \u7ed3\u679c\u751f\u6210\n") : "\n# \u7ed3\u679c\u751f\u6210\n";
                SseContext.putSseStep((String)requestId, (String)SseStepEnum.REPORT_GENERATE_START.getCode());
                EventData reportGenerationTitleEventData = new EventData(SseEventlEnum.SCRUMBI_ANALYSIC.getEvent(), SseEventlEnum.SseEventDataTypeEnum.REPORT_GENERATION.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), reportGenerationTitle, "success");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)reportGenerationTitleEventData);
                reportGenerateLatch.countDown();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("\u5f02\u6b65\u53d1\u9001\u95ee\u53e5\u5206\u6790\u63a8\u7406\u5185\u5bb9\u548c\u6784\u5efa\u89e3\u9898\u601d\u8def\u6807\u9898\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }, this.sseSendExecutor);
    }

    public void sendReportGenerationDetail(String requestId, String locale, String msg, JSONObject context, Boolean ifStream) {
        if (!context.containsKey((Object)"reportGenerationFirstSendFlag")) {
            context.put("reportGenerationFirstSendFlag", (Object)true);
        } else {
            context.put("reportGenerationFirstSendFlag", (Object)false);
        }
        Boolean reportGenerationFirstSendFlag = context.getBoolean("reportGenerationFirstSendFlag");
        this.buildReportGenerationDetail(context, msg, locale);
        if (!ifStream.booleanValue()) {
            return;
        }
        CountDownLatch reportGenerateLatch = null;
        try {
            if (reportGenerationFirstSendFlag.booleanValue()) {
                SseContext.putReportGenerateState((String)requestId, (Boolean)true);
                reportGenerateLatch = SseContext.getReportGenerateLatch((String)requestId);
                boolean await = reportGenerateLatch.await(60L, TimeUnit.SECONDS);
                if (await) {
                    log.info("sendReportGenerationDetailAwait\u6210\u529f");
                }
            }
            String answer = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)msg) : msg;
            EventData reportGenerationDetailEventData = new EventData(SseEventlEnum.MESSAGE_DETAIL.getEvent(), SseEventlEnum.SseEventDataTypeEnum.REPORT_GENERATION.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer, "success");
            SseEmitterUtils.sendEventData((String)requestId, (EventData)reportGenerationDetailEventData);
            if (Objects.nonNull(reportGenerateLatch)) {
                reportGenerateLatch.countDown();
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("\u5f02\u6b65\u53d1\u9001\u6784\u5efa\u89e3\u9898\u601d\u8def\u5185\u5bb9\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    public void sendReportGenerationEnd(JSONObject context, String requestId, boolean success, boolean ifStream) {
        try {
            this.buildReportGenerationEnd(context, Boolean.valueOf(success));
            if (!ifStream) {
                return;
            }
            CountDownLatch reportGenerateLatch = SseContext.getReportGenerateLatch((String)requestId);
            boolean await = reportGenerateLatch.await(60L, TimeUnit.SECONDS);
            if (await) {
                log.info("sendReportGenerationDetailAwait\u6210\u529f");
            }
            EventData reportGenerationDetailEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, success ? "success" : "fail");
            SseEmitterUtils.sendEventData((String)requestId, (EventData)reportGenerationDetailEventData);
            SseContext.putSseStep((String)requestId, (String)SseStepEnum.REPORT_GENERATE_COMPLEATE.getCode());
            reportGenerateLatch.countDown();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u53d1\u9001\u6784\u5efa\u89e3\u9898\u601d\u8def\u5185\u5bb9\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResult(String requestId, String res) {
        try {
            EventData problemSolvingCompleateEventData;
            boolean await;
            CountDownLatch getReportGenerateLatch;
            boolean await2;
            CountDownLatch getDataFusionAnalysisLatch;
            boolean await3;
            CountDownLatch dataQueryLatch;
            boolean await4;
            CountDownLatch taskPlanLatch;
            boolean await5;
            SseContext.putIntentionAnalysicState4AutoData((String)requestId, (Boolean)true);
            SseContext.putTaskPlanState((String)requestId, (Boolean)true);
            SseContext.putDataQueryState((String)requestId, (Boolean)true);
            SseContext.putDataFusionAnalysisState((String)requestId, (Boolean)true);
            SseContext.putReportGenerateState((String)requestId, (Boolean)true);
            SseContext.putAutoDataResultState((String)requestId, (Boolean)true);
            CountDownLatch analysicQuestionLatch = SseContext.getIntentionAnalysic4AutoDataLatch((String)requestId);
            if (Objects.nonNull(analysicQuestionLatch) && (await5 = analysicQuestionLatch.await(60L, TimeUnit.SECONDS))) {
                log.info("analysicQuestionLatch\u6210\u529f");
            }
            if (Objects.nonNull(taskPlanLatch = SseContext.getTaskPlanLatch((String)requestId)) && (await4 = taskPlanLatch.await(60L, TimeUnit.SECONDS))) {
                log.info("taskPlanLatch\u6210\u529f");
            }
            if (Objects.nonNull(dataQueryLatch = SseContext.getDataQueryLatch((String)requestId)) && (await3 = dataQueryLatch.await(60L, TimeUnit.SECONDS))) {
                log.info("dataQueryLatch\u6210\u529f");
            }
            if (Objects.nonNull(getDataFusionAnalysisLatch = SseContext.getDataFusionAnalysisLatch((String)requestId)) && (await2 = getDataFusionAnalysisLatch.await(60L, TimeUnit.SECONDS))) {
                log.info("getDataFusionAnalysisLatch\u6210\u529f");
            }
            if (Objects.nonNull(getReportGenerateLatch = SseContext.getReportGenerateLatch((String)requestId)) && (await = getReportGenerateLatch.await(60L, TimeUnit.SECONDS))) {
                log.info("getReportGenerateLatch\u6210\u529f");
            }
            String sseStep = SseContext.getSseStep((String)requestId);
            if (SseStepEnum.INTENTION_ANALYSIC_4_AUTODATA_START.getCode().equalsIgnoreCase(sseStep)) {
                EventData analysicCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "fail");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)analysicCompleateEventData);
            } else if (SseStepEnum.TASK_PLAN_START.getCode().equalsIgnoreCase(sseStep)) {
                problemSolvingCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "fail");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)problemSolvingCompleateEventData);
            } else if (SseStepEnum.DATA_QUERY_START.getCode().equalsIgnoreCase(sseStep)) {
                problemSolvingCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "fail");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)problemSolvingCompleateEventData);
            } else if (SseStepEnum.DATA_FUSION_ANALYSIS_START.getCode().equalsIgnoreCase(sseStep)) {
                problemSolvingCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "fail");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)problemSolvingCompleateEventData);
            } else if (SseStepEnum.REPORT_GENERATE_START.getCode().equalsIgnoreCase(sseStep)) {
                problemSolvingCompleateEventData = new EventData(SseEventlEnum.SCRUMBI_COMPLEATE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "fail");
                SseEmitterUtils.sendEventData((String)requestId, (EventData)problemSolvingCompleateEventData);
            }
            SseContext.putSseStep((String)requestId, (String)SseStepEnum.RESULT.getCode());
            EventData resultEventData = new EventData(SseEventlEnum.SCRUMBI_RESULT.getEvent(), SseEventlEnum.SseEventDataTypeEnum.RESULT.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), res, "success");
            SseEmitterUtils.sendEventData((String)requestId, (EventData)resultEventData);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("\u5f02\u6b65\u53d1\u9001\u6700\u7ec8\u7ed3\u679c\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        finally {
            EventData doneEventData = new EventData(SseEventlEnum.SCRUMBI_DONE.getEvent(), null, SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), null, "success");
            SseEmitterUtils.sendEventData((String)requestId, (EventData)doneEventData);
        }
    }

    private void buildIntentionAnalysicAndTaskPlanTitle(JSONObject context, String locale, String msg) {
        JSONObject processStreamData = (JSONObject)context.getOrDefault((Object)"processStreamData", (Object)new JSONObject());
        String detail = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)msg) : msg;
        String intentionAnalysicTitle = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"# \u610f\u56fe\u5206\u6790\n") : "# \u610f\u56fe\u5206\u6790\n";
        JSONObject intentionAnalysic = new JSONObject();
        intentionAnalysic.put("title", (Object)intentionAnalysicTitle);
        intentionAnalysic.put("content", (Object)detail);
        intentionAnalysic.put("status", (Object)true);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS_4_AUTODATA.getType(), (Object)intentionAnalysic);
        String taskPlanTitle = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"\n# \u4efb\u52a1\u89c4\u5212\n") : "\n# \u4efb\u52a1\u89c4\u5212\n";
        JSONObject taskPlan = new JSONObject();
        taskPlan.put("title", (Object)taskPlanTitle);
        taskPlan.put("status", (Object)false);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.TASK_PLAN.getType(), (Object)taskPlan);
        context.put("processStreamData", (Object)processStreamData);
    }

    private void buildTaskPlanDetailAndDataQueryTitle(JSONObject context, String locale, String tasks) {
        JSONObject processStreamData = (JSONObject)context.getOrDefault((Object)"processStreamData", (Object)new JSONObject());
        String taskPlanDetail = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)tasks) : tasks;
        JSONObject taskPlan = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.TASK_PLAN.getType(), (Object)new JSONObject());
        taskPlan.put("content", (Object)taskPlanDetail);
        taskPlan.put("status", (Object)true);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.TASK_PLAN.getType(), (Object)taskPlan);
        String dataQueryTitle = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"# \u6570\u636e\u67e5\u8be2\n") : "# \u6570\u636e\u67e5\u8be2\n";
        JSONObject dataQuery = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.DATA_QUERY.getType(), (Object)new JSONObject());
        dataQuery.put("title", (Object)dataQueryTitle);
        dataQuery.put("status", (Object)false);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.DATA_QUERY.getType(), (Object)dataQuery);
        context.put("processStreamData", (Object)processStreamData);
    }

    private void buildDataQueryDetailAndFusionTitle(JSONObject context, String locale, String msg) {
        JSONObject processStreamData = (JSONObject)context.getOrDefault((Object)"processStreamData", (Object)new JSONObject());
        String dataQueryDetail = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)msg) : msg;
        JSONObject dataQuery = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.DATA_QUERY.getType(), (Object)new JSONObject());
        dataQuery.put("content", (Object)dataQueryDetail);
        dataQuery.put("status", (Object)true);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.DATA_QUERY.getType(), (Object)dataQuery);
        String dataFusionAnalysicTitle = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"# \u6570\u636e\u878d\u5408\u5206\u6790\n") : "# \u6570\u636e\u878d\u5408\u5206\u6790\n";
        JSONObject dataFusionAnalysic = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.DATA_FUSION_ANALYSIS.getType(), (Object)new JSONObject());
        dataFusionAnalysic.put("title", (Object)dataFusionAnalysicTitle);
        dataFusionAnalysic.put("status", (Object)false);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.DATA_FUSION_ANALYSIS.getType(), (Object)dataFusionAnalysic);
        context.put("processStreamData", (Object)processStreamData);
    }

    private void buildFusionAnalysicDetailAndReportGenerationTitle(JSONObject context, String locale, String msg) {
        JSONObject processStreamData = (JSONObject)context.getOrDefault((Object)"processStreamData", (Object)new JSONObject());
        String dataFusionAnalysicDetail = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)msg) : msg;
        JSONObject dataFusionAnalysic = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.DATA_FUSION_ANALYSIS.getType(), (Object)new JSONObject());
        dataFusionAnalysic.put("content", (Object)dataFusionAnalysicDetail);
        dataFusionAnalysic.put("status", (Object)true);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.DATA_FUSION_ANALYSIS.getType(), (Object)dataFusionAnalysic);
        String reportGenerationTitle = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)"\n# \u7ed3\u679c\u751f\u6210\n") : "\n# \u7ed3\u679c\u751f\u6210\n";
        JSONObject reportGeneration = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.REPORT_GENERATION.getType(), (Object)new JSONObject());
        reportGeneration.put("title", (Object)reportGenerationTitle);
        reportGeneration.put("status", (Object)false);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.REPORT_GENERATION.getType(), (Object)reportGeneration);
        context.put("processStreamData", (Object)processStreamData);
    }

    private void buildReportGenerationDetail(JSONObject context, String msg, String locale) {
        JSONObject processStreamData = (JSONObject)context.getOrDefault((Object)"processStreamData", (Object)new JSONObject());
        String detailChar = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)msg) : msg;
        JSONObject reportGeneration = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.REPORT_GENERATION.getType(), (Object)new JSONObject());
        reportGeneration.put("content", (Object)(reportGeneration.getOrDefault((Object)"content", (Object)"") + detailChar));
        reportGeneration.put("status", (Object)true);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.REPORT_GENERATION.getType(), (Object)reportGeneration);
        context.put("processStreamData", (Object)processStreamData);
    }

    private void buildReportGenerationEnd(JSONObject context, Boolean success) {
        JSONObject processStreamData = (JSONObject)context.getOrDefault((Object)"processStreamData", (Object)new JSONObject());
        JSONObject reportGeneration = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.REPORT_GENERATION.getType(), (Object)new JSONObject());
        reportGeneration.put("status", (Object)success);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.REPORT_GENERATION.getType(), (Object)reportGeneration);
        context.put("processStreamData", (Object)processStreamData);
    }

    private void buildIntentionAnalysicDetail(JSONObject context, String msg, String locale, Boolean intentionAnalysicRes) {
        JSONObject processStreamData = (JSONObject)context.getOrDefault((Object)"processStreamData", (Object)new JSONObject());
        String detail = "zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)msg) : msg;
        JSONObject intentionAnalysis = (JSONObject)processStreamData.getOrDefault((Object)SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS.getType(), (Object)new JSONObject());
        intentionAnalysis.put("content", (Object)detail);
        intentionAnalysis.put("status", (Object)intentionAnalysicRes);
        processStreamData.put(SseEventlEnum.SseEventDataTypeEnum.INTENTION_ANALYSIS.getType(), (Object)intentionAnalysis);
        context.put("processStreamData", (Object)processStreamData);
    }
}

