{
    "query": {
        "bool": {
            "filter": {
                "bool":{
                    "must":[
                        <#if appCodesCondition??>
                        {
                            "terms": {
                                "applicationCode": [<#list appCodesCondition as item>"${item}"<#sep>, </#list>]
                            }
                        },
                        </#if>
                        <#if version??>
                        {
                            "term": {
                                "version": "${version}"
                            }
                        },
                        </#if>
                        <#if metricIds??>
                        {
                            "terms": {
                                "metricId": [<#list metricIds as item>"${item}"<#sep>, </#list>]
                            }
                        },
                        </#if>
                        <#if not_query_all??>
                        {"bool":{"should":[
                            <#if simplified_use_question??>
                            {
                                "match": {
                                    "metricName": {
                                        "query": "${simplified_use_question}",
                                        "boost": 7,
                                        "analyzer": "ngram_analyzer"
                                    }
                                }
                            }
                            </#if>
                            <#if traditional_use_question??>
                            ,{
                                "match": {
                                    "metricName": {
                                        "query": "${traditional_use_question}",
                                        "boost": 7,
                                        "analyzer": "ngram_analyzer"
                                    }
                                }
                            }
                            </#if>
                            <#if origin_finally_question??>
                            ,{
                                "match": {
                                    "metricName": {
                                        "query": "${origin_finally_question}",
                                        "boost": 7,
                                        "analyzer": "ngram_analyzer"
                                    }
                                }
                            }
                            </#if>
                            <#if simplified_metric_standard_name??>
                            ,{
                                "match": {
                                    "metricName": {
                                        "query": "${simplified_metric_standard_name}",
                                        "boost": 10,
                                        "analyzer": "whitespace"
                                    }
                                }
                            }
                            </#if>
                            <#if traditional_metric_standard_name??>
                            ,{
                                "match": {
                                    "metricName": {
                                        "query": "${traditional_metric_standard_name}",
                                        "boost": 10,
                                        "analyzer": "whitespace"
                                    }
                                }
                            }
                            </#if>
                            <#if orginal_question??>
                            {
                                "match": {
                                    "metricName": {
                                        "query": "${orginal_question}",
                                        "boost": 7,
                                        "analyzer": "ngram_analyzer"
                                    }
                                }
                            }
                            </#if>
                        ]}},

                        </#if>
                        {
                            "exists": {
                                "field": "metricId"
                            }
                        }
                    ]
                }
            }
        }
    },
    "size": 1000
}