{
    "query": {
        "bool": {
            "filter": {
                "bool":{
                    "must":[
                        <#if applicationCode??>
                        {
                            "term": {
                                "applicationCode.keyword": "${applicationCode}"
                            }
                        },
                        </#if>
                        <#if applicationCodes??>
                        {
                            "terms": {
                                "applicationCode.keyword": [<#list applicationCodes as item>"${item}"<#sep>, </#list>]
                            }
                        },
                        </#if>
                        <#if version??>
                        {
                            "term": {
                                "version.keyword": "${version}"
                            }
                        },
                        </#if>
                        {
                            "exists": {
                                "field": "datasourceId"
                            }
                        }
                    ]
                }
            },
            "must": {
                "function_score": {
                    "boost": "1",
                    "query": {
                        "dis_max": {
                            "queries": [
                                <#if simplified_target_standard_name??>
                                {
                                    "match": {
                                        "datasourceName": {
                                            "query": "${simplified_target_standard_name}",
                                            "boost": 10,
                                            "analyzer": "whitespace"
                                        }
                                    }
                                },
                                </#if>
                                <#if traditional_target_standard_name??>
                                {
                                    "match": {
                                        "datasourceName": {
                                            "query": "${traditional_target_standard_name}",
                                            "boost": 10,
                                            "analyzer": "whitespace"
                                        }
                                    }
                                }
                                </#if>
                            ],
                            "tie_breaker": 0.1
                        }
                    }
                }
            }
        }
    },
    "size": 100
}