### API定义 start ###

- step
  - array [object]
  - 解析步骤
    - as
      - string
      - 为该查询生成"英文别名"，该别名仅能被其他step引用


    - F
      - SQL中的from子句，来源的表，以下metric、table、subQ , step 选一个
        - metric
          - string
          - 表id(metricId字段)
        - subQ
          - object
          - 子查询
            - as
              - string
              - 为该子查询生成英文别名
            - F
              - ...
            - S
              - ...
            - J
              - ...
            - W
              - ...
            - G
              - ...
            - H
              - ...
            - O
              - ...
            - L
              - ...
            - C
              - ...
        - step
          - string
          - 引用其他step的别名

    - C
      - object
      - 计算函数的列表
        - <as>|<businessType> 动态key，取最后一步的别名|业务类型，业务类型枚举值|说明：amount|金额，Quantity|数量，Rate|比率, date|日期, string|字符串
          - array [string]
            - <函数名称>(<字段名/字段英文别名>)#<英文别名>#<中文别名>
            - 以下函数只需要传入一个变量，函数名称枚举值：Abs,Minus,Sum,Average,Count,Max,Min,Stddev
        - <as>|<businessType> 动态key，取最后一步的别名|业务类型，业务类型枚举值|说明：amount|金额，Quantity|数量，Rate|比率, date|日期, string|字符串
          - array [string]
            - <函数名称>(<字段名/字段英文别名>,变量2)#<英文别名>#<中文别名>
            - 以下函数需要传入两个变量，函数名称枚举值：Add,Multiply,Divide,DateFormat,GrowthRate
            - 变量1的格式：<字段名/字段英文别名>
            - 变量2的格式：GrowthRate,Add,Multiply,Divide的变量2的格式：<字段名/字段英文别名>；DateFormat的变量2的格式：枚举值：y,Q,M,W,d,H,y_Q,y_M,y_W,y_M_d,H_m_s,y_M_d_H_m,y_M_d_H_m_s
              - 枚举值|枚举值解释：y|年,Q|季度,M|月,W|周,d|天,H|小时,y_Q|年-季度,y_M|年-月,y_W|年-周,y_M_d|年-月-日,H_m_s|时-分-秒,y_M_d_H_m|年-月-日-时-分,y_M_d_H_m_s|年-月-日-时-分-秒
              - 函数计算公式：GrowthRate = (期末值-期初值)/期初值;计算成长率优先使用GrowthRate函数，计算“差异比”也优先使用GrowthRate函数
        - <as>|<businessType> 动态key，取最后一步的别名|业务类型，业务类型枚举值|说明：amount|金额，Quantity|数量，Rate|比率, date|日期, string|字符串, ROW_NUMBER|排名序号
          - array [string]
            - <函数名称>() OVER (PARTITION BY <分组字段名1/分组字段英文别名1>, <分组字段名2/分组字段英文别名2>,... ORDER BY <排序字段/排序字段英文别名> <ASC/DESC>)#<英文别名>#<中文别名>
            - 以下函数需要传入两个变量，函数名称枚举值：
              - ROW_NUMBER 是 SQL 中的一个窗口函数，用于为查询结果集中的每一行分配一个唯一的行号。用于解决多个维度下的分组排名问题，可进行正序排名和倒序排名；例如询问：“今年各个部门中的产品的订单数量最垫底的”、“近三年每年订单数量排名最好的产品分别是多少”，均需要使用ROW_NUMBER进行分组排名 **注意，ROW_NUMBER函数需要单独的Step**


    - J
      - array [object]
      - join子句

        - joinType
          - string
          - 枚举值:"inner","left","right","full","cross"

        - F
          - object
          - 用于join的子查询或表

        - on
          - array [string]
            - 若用户未明确用于join的维度，优先使用时间信息进行join
            - [<左值数据1> eq <右值数据1>, <左值数据2> eq <右值数据2>]

    - G
      - array [string]
        - 字段英文名或别名英文

    - W
      - object
      - where子句
        - 逻辑符号|枚举值:"and","or"
          - object
          - .......嵌套结构
            - 逻辑符号|枚举值:"and","or"
              - object
              - array [string]最内层，若单层则直接进入最内层结构
                - 字段name 运算符 字段取值 取值类型
                - **字段取值一律避免使用SQL，需要拆分为Step**
                - 运算符枚举值：">","<","=","!=","btw",">=","<=","like","in","not_in"
                - 取值类型枚举值|枚举值解释，
                  - i|字段field
                  - c|常量constant
                - 注意字段name一律为英文+阿拉伯数字，避免中文
                - **注意仅能从用户输入中解析对应的条件**

    - H
      - object
      - having子句
        - 逻辑符号|枚举值:"and","or"
        - object
          - .......嵌套结构
            - 逻辑符号|枚举值:"and","or"
            - object
              - array [string] 最内层，若单层则直接进入最内层结构
                - 数据源别名.字段name 逻辑运算符 字段取值
                - 逻辑运算符枚举值：">","<","=","!=","btw",">=","<=","like","in","not_in"
                - 注意字段name一律为英文+阿拉伯数字，避免中文

    - O
      - array [string]
      - order by子句
      - 数据源别名.字段name#排序方式
      - 排序方式枚举值："asc","desc"
      - 注意字段name一律为英文+阿拉伯数字，避免中文

    - L
      - array [int,int]
      - limit子句
      - 限制数据区间,固定包含start_pod,end_pod两个数字
      - start_pod 从0开始取值，如用户询问前五名，start_pod=0,end_pod=4
        - S
      - object
      - SQL中的select语句
        - field
          - array [string]
          - SQL中的select语句,SELECT中使用字段
          - 格式：[<字段名/字段英文别名/字段名#字段英文别名#字段中文名别名>]
        - dataset
          - array [object]
            - SELECT中使用数据集，以下metric、subQ , step 选一个
              - metric
                - string
                - 表名
              - subQ
                - object
                - 子查询
                  - as
                    - string
                    - 为该子查询生成英文别名
                  - F
                    - ...
                  - S
                    - ...
                  - J
                    - ...
                  - W
                    - ...
                  - G
                    - ...
                  - H
                    - ...
                  - O
                    - ...
                  - L
                    - ...
                  - C
                    - ...
              - step
                - string
                - 普通表名
              - as
                - string
              - 数据集别名

### API定义 end ###

### 示例 ###



样例1：
输入：
- 用户问句：今年的高三年級的語文平均分第一的學生比第二高了百分之多少

输出：
{
  "step": [
    {
      "as": "Step1",
      "F": {
        "metric": "chinese_record"
      },
      "C": {
        "CurrentYearFirstAverageChinese|Quantity": [
          "Average(chinese_score)#CurrentYearFirstAverageChinese#今年第一平均語文得分"
        ]
      },
      "W": {
        "and": [
          "test_date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c",
          "grade eq 高三 c"
        ]
      },
      "G": [
        "student_name"
      ],
      "O": [
        "CurrentYearFirstAverageChinese#desc"
      ],
      "L": [
        0,
        0
      ],
      "S": {
        "field": [
          "student_name#CurrentYearFirststudent_name#今年第一名學生姓名",
          "CurrentYearFirstAverageChinese"
        ]
      }
    },
    {
      "as": "Step2",
      "F": {
        "metric": "chinese_record"
      },
      "C": {
        "CurrentYearSecondAverageChinese|Quantity": [
          "Average(chinese_score)#CurrentYearSecondAverageChinese#今年第二平均語文得分"
        ]
      },
      "W": {
        "and": [
          "test_date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c",
          "grade eq 高三 c"
        ]
      },
      "G": [
        "student_name"
      ],
      "S": {
        "field": [
          "student_name#CurrentYearSecondstudent_name#今年第二名學生姓名",
          "CurrentYearSecondAverageChinese"
        ]
      },
      "O": [
        "CurrentYearSecondAverageChinese#desc"
      ],
      "L": [
        1,
        1
      ]
    },
    {
      "as": "Step3",
      "F": {
        "step": "Step1"
      },
      "J": [
        {
          "joinType": "cross",
          "F": {
            "step": "Step2"
          },
          "on": [
            "1 eq 1"
          ]
        }
      ],
      "C": {
        "PercentageDifference|Rate": [
          "Minus(FirstHighest.CurrentYearFirstAverageChinese, SecondHighest.CurrentYearSecondAverageChinese)#Difference#分数差",
          "Divide(Difference, SecondHighest.CurrentYearSecondAverageChinese)#PercentageDifference#百分比差异"
        ]
      },
      "S": {
        "field": [
          "Step1.CurrentYearFirststudent_name",
          "Step1.CurrentYearFirstAverageChinese",
          "Step2.CurrentYearSecondstudent_name",
          "Step2.CurrentYearSecondAverageChinese",
          "PercentageDifference"
        ]
      }
    }
  ]
}

样例2：
输入：
- 用户问句：今年的高三年级的语文平均分第一的学生的每月的数学平均成绩趋势如何
输出：
{
  "step": [
    {
      "as": "Step1",
      "F": {
        "metric": "chinese_record"
      },
      "C": {
        "CurrentYearFirstAverageChinese|Quantity": [
          "Average(chinese_score)#CurrentYearFirstAverageChinese#今年第一平均语文得分"
        ]
      },
      "W": {
        "and": [
          "test_date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c",
          "grade eq 高三 c"
        ]
      },
      "G": [
        "student_name"
      ],
      "O": [
        "CurrentYearFirstAverageChinese#desc"
      ],
      "L": [
        0,
        0
      ],
      "S": {
        "field": [
          "student_name#CurrentYearFirstStudentName#今年第一学生姓名",
          "CurrentYearFirstAverageChinese"
        ]
      }
    },
    {
      "as": "Step2",
      "F": {
        "metric": "math_record"
      },
      "C": {
        "MonthlyMathAverage|Quantity": [
          "Average(math_score)#MonthlyMathAverage#每月数学平均成绩"
        ]
      },
      "W": {
        "and": [
          "test_date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c",
          "grade eq 高三 c"
        ]
      },
      "G": [
        "student_name",
        "DateFormat(test_date,M)#Month#月份"
      ],
      "S": {
        "field": [
          "student_name",
          "Month",
          "MonthlyMathAverage"
        ]
      }
    },
    {
      "as": "Step3",
      "F": {
        "step": "Step1"
      },
      "J": [
        {
          "joinType": "left",
          "F": {
            "step": "Step2"
          },
          "on": [
            "Step1.CurrentYearFirstStudentName eq Step2.student_name"
          ]
        }
      ],
      "S": {
        "field": [
          "Step1.CurrentYearFirstStudentName",
          "Step2.Month",
          "Step2.MonthlyMathAverage"
        ]
      }
    }
  ]
}


样例3：
输入：
-用户问句：今年每月的高三年級的語文和數學平均分用趨勢圖展示
输出：
{
  "step": [
    {
      "as": "Step1",
      "F": {
        "metric": "chinese_record"
      },
      "C": {
        "CurrentYearAverageChinese|Quantity": [
          "Average(chinese_score)#CurrentYearAverageChinese#今年各月平均語文得分"
        ],
        "CurrentYear_M_test_date|date": [
          "DateFormat(test_date,M)#CurrentYear_M_test_date#考試月份"
        ]
      },
      "W": {
        "and": [
            "test_date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c",
            "grade eq 高三 c"
        ]
      },
      "G": [
        "CurrentYear_M_test_date"
      ],
      "O": [
        "CurrentYear_M_test_date#asc"
      ],
      "S": {
        "field": ["CurrentYear_M_test_date", "CurrentYearAverageChinese"]
      }
    },
    {
      "as": "Step2",
      "F": {
        "metric": "math_record"
      },
      "C": {
        "CurrentYearAverageMath|Quantity": [
          "Average(math_score)#CurrentYearAverageMath#今年各月平均數學得分"
        ],
        "CurrentYear_M_test_date|date": [
          "DateFormat(test_date,M)#CurrentYear_M_test_date#考試月份"
        ]
      },
      "W": {
        "and": [
            "test_date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c",
            "grade eq 高三 c"
        ]
      },
      "G": [
        "CurrentYear_M_test_date"
      ],
      "O": [
        "CurrentYear_M_test_date#asc"
      ],
      "S": {
        "field": ["CurrentYear_M_test_date", "CurrentYearAverageMath"]
      }
    },
    {
      "as": "Step3",
      "F": {
        "step": "Step2"
      },
      "J": [
        {
          "joinType": "left",
          "F": {
            "step": "Step1"
          },
          "on": ["CurrentYear_M_test_date eq CurrentYear_M_test_date"]
        },
      "S": {
        "field": ["Step1.CurrentYear_M_test_date","Step1.CurrentYearAverageChinese","Step2.CurrentYearAverageMath"]
      }
      ]
    }
  ]
}

样例4：
输入：
- 用户问句：今年和2023年零花錢的總額對比
输出：
{
  "step": [
    {
      "as": "Step1",
      "F": {
        "metric": "student_money"
      },
      "C": {
        "CurrentYearTotalAllowance|amount": [
          "Sum(ALLOWANCE_AMOUNT)#CurrentYearTotalAllowance#今年零花錢總額"
        ],
        "CurrentYear_y_Date|date": [
          "DateFormat(Date,y)#CurrentYear_y_Date#今年年份"
        ]
      },
      "W": {
        "and": [
            "Date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c"
        ]
      },
      "G": [
        "CurrentYear_y_Date"
      ],
      "S": {
        "field": ["CurrentYearTotalAllowance"]
      }
    },
    {
      "as": "Step2",
      "F": {
        "metric": "student_money"
      },
      "C": {
        "LastYearTotalAllowance|amount": [
          "Sum(ALLOWANCE_AMOUNT)#LastYearTotalAllowance#2023年零花錢總額"
        ],
        "2023_y_Date|date": [
          "DateFormat(Date,y)#2023_y_Date#2023年"
        ]
      },
      "W": {
        "and": [
            "Date btw '2023-01-01'#'2023-12-31' c"
        ]
      },
      "G": [
        "2023_y_Date"
      ],
      "S": {
        "field": ["LastYearTotalAllowance"]
      }
    },
    {
      "as": "Step3",
      "F": {
        "step": "Step1"
      },
      "J": [
        {
          "joinType": "cross",
          "F": {
            "step": "Step2"
          },
          "on": ["1 eq 1"]
        }
      ],
      "C": {
        "GrowthRate|Rate": [
          "GrowthRate(CurrentYearTotalAllowance, LastYearTotalAllowance)#GrowthRate#零花錢增長率"
        ]
      }
      "S": {
        "field": ["Step1.CurrentYearTotalAllowance", "Step2.LastYearTotalAllowance", "GrowthRate"]
      }
    }
  ]
}


样例5：
输入：
- 用户问句：今年小明的語文平均分和零花錢總額
输出：
{
  "step": [
    {
      "as": "Step1",
      "F": {
        "metric": "chinese_record"
      },
      "C": {
        "CurrentYearAverageChinese|Quantity": [
          "Average(chinese_score)#CurrentYearAverageChinese#今年平均語文得分"
        ]
      },
      "W": {
        "and": [
            "student_name eq 小明 c",
            "test_date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c"
        ]
      },
      "G": [
        "student_name"
      ],
      "S": {
        "field": ["student_name", "CurrentYearAverageChinese"]
      }
    },
    {
      "as": "Step2",
      "F": {
        "metric": "student_money"
      },
      "C": {
        "CurrentYearTotalAllowance|amount": [
          "Sum(ALLOWANCE_AMOUNT)#CurrentYearTotalAllowance#今年零花錢總額"
        ],
        "CurrentYear_y_Date|date": [
          "DateFormat(Date,y)#CurrentYear_y_Date#年份"
        ]
      },
      "W": {
        "and": [
            "student_name eq 小明 c",
            "Date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c"
        ]
      },
      "G": [
        "student_name",
        "CurrentYear_y_Date"
      ],
      "S": {
        "field": ["student_name", "CurrentYearTotalAllowance"]
      }
    },
    {
      "as": "Step3",
      "F": {
        "step": "Step1"
      },
      "J": [
        {
          "joinType": "left",
          "F": {
            "step": "Step2"
          },
          "on": ["Step1.student_name eq Step2.student_name"]
        }
      ],
      "S": {
        "field": ["Step1.CurrentYearAverageChinese", "Step2.CurrentYearTotalAllowance"]
      }
    }
  ]
}


样例6：
输入：
- 用户问句：今年小明的语文平均成绩比数学平均成绩高的月份
输出：
{
    "step": [
        {
            "as": "Step1",
            "F": {
                "metric": "chinese_record"
            },
            "C": {
                "CurrentYearAverageChinese|Quantity": [
                    "Average(chinese_score)#CurrentYearAverageChinese#今年平均语文得分"
                ],
                "CurrentYear_M_test_date|date": [
                    "DateFormat(test_date,M)#CurrentYear_M_test_date#考试月份"
                ]
            },
            "W": {
                "and": [
                    "student_name eq 小明 c",
                    "test_date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c"
                ]
            },
            "G": [
                "CurrentYear_M_test_date"
            ],
            "S": {
                "field": [
                    "CurrentYear_M_test_date",
                    "CurrentYearAverageChinese"
                ]
            },
            "O": [
                "CurrentYear_M_test_date#asc"
            ]
        },
        {
            "as": "Step2",
            "F": {
                "metric": "math_record"
            },
            "C": {
                "CurrentYearAverageMath|Quantity": [
                    "Average(math_score)#CurrentYearAverageMath#今年平均数学得分"
                ],
                "CurrentYear_M_test_date|date": [
                    "DateFormat(test_date,M)#CurrentYear_M_test_date#考试月份"
                ]
            },
            "W": {
                "and": [
                    "student_name eq 小明 c",
                    "test_date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c"
                ]
            },
            "G": [
                "CurrentYear_M_test_date"
            ],
            "S": {
                "field": [
                    "CurrentYear_M_test_date",
                    "CurrentYearAverageMath"
                ]
            },
            "O": [
                "CurrentYear_M_test_date#asc"
            ]
        },
        {
            "as": "Step3",
            "F": {
                "step": "Step1"
            },
            "J": [
                {
                    "joinType": "left",
                    "F": {
                        "step": "Step2"
                    },
                    "on": [
                        "Step1.CurrentYear_M_test_date eq Step2.CurrentYear_M_test_date"
                    ]
                }
            ],
            "W": {
                "and": [
                  "Step1.CurrentYearAverageChinese > Step2.CurrentYearAverageMath i"
                ]
            },
            "O": [
                "Step1.CurrentYear_M_test_date#asc"
            ],
            "S": {
                "field": [
                    "Step1.CurrentYear_M_test_date",
                    "Step1.CurrentYearAverageChinese",
                    "Step2.CurrentYearAverageMath"
                ]
            }
        }
    ]
}


样例7：
输入：
- 用户问句：今年語文平均成績最高的學生的零花錢總額
输出：
{
  "step": [
    {
      "as": "Step1",
      "F": {
        "metric": "chinese_record"
      },
      "C": {
        "CurrentYearHighestAverageChinese|Quantity": [
          "Average(chinese_score)#CurrentYearHighestAverageChinese#今年最高平均語文得分"
        ]
      },
      "W": {
        "and": [
          "test_date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c"
        ]
      },
      "G": [
        "student_name"
      ],
      "S": {
        "field": ["student_name#HighestChineseStudentName#最高分學生姓名", "CurrentYearHighestAverageChinese"]
      },
      "O": [
        "CurrentYearHighestAverageChinese#desc"
      ],
      "L": [
        0,
        0
      ]
    },
    {
      "as": "Step2",
      "F": {
        "metric": "student_money"
      },
      "C": {
        "CurrentYearTotalAllowance|amount": [
          "Sum(ALLOWANCE_AMOUNT)#CurrentYearTotalAllowance#零花錢總額"
        ]
      },
      "W": {
        "and": [
          "Date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c"
        ]
      },
      "G": [
        "student_name"
      ],
      "S": {
        "field": ["student_name", "CurrentYearTotalAllowance"]
      }
    },
    {
      "as": "Step3",
      "F": {
        "step": "Step1"
      },
      "J": [
        {
          "joinType": "left",
          "F": {
            "step": "Step2"
          },
          "on": [
            "Step1.HighestChineseStudentName eq Step2.student_name"
          ]
        }
      ],
      "S": {
        "field": [
          "Step1.HighestChineseStudentName",
          "Step1.CurrentYearHighestAverageChinese",
          "Step2.CurrentYearTotalAllowance"
        ]
      }
    }
  ]
}


样例8：
输入：- 用户问句：今年零花錢總額第一和第二的學生
输出：
{
  "step": [
    {
      "as": "Step1",
      "F": {
        "metric": "student_money"
      },
      "C": {
        "CurrentYearTotalAllowance|amount": [
          "Sum(ALLOWANCE_AMOUNT)#CurrentYearTotalAllowance#今年零花钱总额"
        ]
      },
      "W": {
        "and": [
          "Date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c"
        ]
      },
      "G": [
        "student_name"
      ],
      "O": [
        "CurrentYearTotalAllowance#desc"
      ],
      "L": [
        0,
        1
      ],
      "S": {
        "field": [
          "student_name",
          "CurrentYearTotalAllowance"
        ]
      }
    }
  ]
}


样例9：
输入：
- 用户问句：文具數量占比最高的類型
输出：
{
  "step": [
    {
      "as": "Step1",
      "F": {
        "metric": "stationery_quantity"
      },
      "C": {
        "TotalStationeryByType|Quantity": [
          "Sum(STATIONERY_QUANTITY)#TotalStationeryByType#各類文具數量"
        ]
      },
      "G": [
        "stationery_type"
      ],
      "S": {
        "field": [
          "stationery_type",
          "TotalStationeryByType"
        ]
      }
    },
    {
      "as": "Step2",
      "F": {
        "metric": "stationery_quantity"
      },
      "C": {
        "TotalStationery|Quantity": [
          "Sum(STATIONERY_QUANTITY)#TotalStationery#總數量"
        ]
      },
      "S": {
        "field": [
          "TotalStationery"
        ]
      }
    },
    {
      "as": "Step3",
      "F": {
        "step": "Step1"
      },
      "J": [
        {
          "joinType": "left",
          "F": {
            "step": "Step2"
          },
          "on": [
            "1 eq 1"
          ]
        }
      ],
      "C": {
        "Proportion|Rate": [
          "Divide(TotalStationeryByType, TotalStationery)#Proportion#占比"
        ]
      },
      "O": [
        "Proportion#desc"
      ],
      "L": [
        0,
        0
      ],
      "S": {
        "field": [
          "stationery_type",
          "TotalStationeryByType#FirstStationery#占比最高的數量",
          "TotalStationery",
          "Proportion"
        ]
      }
    }
  ]
}


样例10：
输入：
- 用户问句：今年小明的零花钱除以文具数量
输出：
{
  "step": [
    {
      "as": "Step1",
      "F": {
        "metric": "student_money"
      },
      "C": {
        "CurrentYearTotalAllowance|amount": [
          "Sum(ALLOWANCE_AMOUNT)#CurrentYearTotalAllowance#今年零花钱总额"
        ]
      },
      "W": {
        "and": [
          "student_name eq 小明 c",
          "Date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c"
        ]
      },
      "G": [
        "student_name"
      ],
      "S": {
        "field": ["student_name", "CurrentYearTotalAllowance"]
      }
    },
    {
      "as": "Step2",
      "F": {
        "metric": "stationery_quantity"
      },
      "C": {
        "CurrentYearTotalStationery|Quantity": [
          "Sum(STATIONERY_QUANTITY)#CurrentYearTotalStationery#今年文具数量总和"
        ]
      },
      "W": {
        "and": [
          "student_name eq 小明 c",
          "Date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c"
        ]
      },
      "G": [
        "student_name"
      ],
      "S": {
        "field": ["student_name", "CurrentYearTotalStationery"]
      }
    },
    {
      "as": "Step3",
      "F": {
        "step": "Step1"
      },
      "J": [
        {
          "joinType": "left",
          "F": {
            "step": "Step2"
          },
          "on": [
            "Step1.student_name eq Step2.student_name"
          ]
        }
      ],
      "C": {
        "AllowancePerStationery|amount": [
          "Divide(XiaomingAllowanceTotal.CurrentYearTotalAllowance, XiaomingStationeryTotal.CurrentYearTotalStationery)#AllowancePerStationery#零花钱除以文具数量"
        ]
      },
      "S": {
        "field": [
          "Step1.CurrentYearTotalAllowance",
          "Step2.CurrentYearTotalStationery",
          "AllowancePerStationery"
        ]
      }
    }
  ]
}


样例11：
输入：
- 用户问句：今年学生姓名是张三的零花钱总额
输出：
{
  "step": [
    {
      "as": "Step1",
      "F": {
        "metric": "student_money"
      },
      "C": {
        "CurrentYearTotalAllowance|amount": [
          "Sum(ALLOWANCE_AMOUNT)#CurrentYearTotalAllowance#今年零花钱总额"
        ]
      },
      "W": {
        "and": [
          "student_name eq 张三 c",
          "Date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c"
        ]
      },
      "G": [
        "student_name"
      ],
      "S": {
        "field": ["student_name", "CurrentYearTotalAllowance"]
      }
    }
  ]
}


样例12：
输入：
- 用户问句：7月文具類型是數學的數量
输出：
{
  "step": [
    {
      "as": "Step1",
      "F": {
        "metric": "stationery_count"
      },
      "C": {
        "JulyTotalMathStationery|amount": [
          "Sum(STATIONERY_AMOUNT)#JulyTotalMathStationery# 7月數學文具數量"
        ]
      },
      "W": {
        "and": [
          "stationery_type eq 數學 c",
          "Date btw DATE_FORMAT(CURDATE(), '%Y-07-01')#DATE_FORMAT(CURDATE(), '%Y-07-31') c"
        ]
      },
      "G": [
        "stationery_type"
      ],
      "S": {
        "field": ["stationery_type", "JulyTotalMathStationery"]
      }
    }
  ]
}

样例13：
输入：
- 用户问句：今年每個月零花錢總額排名前三的學生
输出：
{
  "step": [
    {
      "as": "Step1",
      "F": {
        "metric": "student_money"
      },
      "C": {
        "MonthlyTotalAllowance|amount": [
          "Sum(ALLOWANCE_AMOUNT)#MonthlyTotalAllowance#每月零花錢總額"
        ],
        "Month|date": [
          "DateFormat(Date,M)#Month#月份"
        ]
      },
      "W": {
        "and": [
          "Date btw DATE_FORMAT(CURDATE(), '%Y-01-01')#DATE_FORMAT(CURDATE(), '%Y-12-31') c"
        ]
      },
      "G": [
        "student_name",
        "Month"
      ],
      "S": {
        "field": [
          "student_name",
          "Month",
          "MonthlyTotalAllowance"
        ]
      }
    },
    {
      "as": "Step2",
      "F": {
        "step": "Step1"
      },
      "C": {
        "Rank|ROW_NUMBER": [
          "ROW_NUMBER() OVER (PARTITION BY Month ORDER BY MonthlyTotalAllowance DESC)#Rank#排名"
        ]
      },
      "S": {
        "field": [
          "student_name",
          "Month",
          "MonthlyTotalAllowance",
          "Rank"
        ]
      }
    },
    {
      "as": "Step3",
      "F": {
        "step": "Step2"
      },
      "W": {
        "and": [
          "Rank <= 3 c"
        ]
      },
      "S": {
        "field": [
          "student_name",
          "Month",
          "MonthlyTotalAllowance"
        ]
      }
    }
  ]
}