/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.search.config.AppTokenConfig;
import com.digiwin.chatbi.reasoning.search.config.EocConfig;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class EocServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(EocServiceInvoker.class);
    @Autowired
    private AppTokenConfig appTokenConfig;
    @Autowired
    private EocConfig eocConfig;
    @Autowired
    private RestTemplate restTemplate;
    private static final String CORP_COMPANY_URL = "/api/eoc/v2/corp/company";
    private String ERR_MESSAGE = "\u67e5\u8be2eoc\u7cfb\u7edf\u5f02\u5e38";

    public JSONArray corpCompany(String token) {
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isEmpty((CharSequence)token)) {
            log.error("\u67e5\u8be2\u516c\u53f8token\u4e0d\u80fd\u4e3a\u7a7a");
            return new JSONArray();
        }
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.appTokenConfig.getAthena());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        log.info("corpCompany entity\uff1a{}", (Object)entity);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.eocConfig.getUrl().concat(CORP_COMPANY_URL).concat("?pageNum=1&pageSize=1000"), HttpMethod.GET, entity, String.class, new Object[0]);
            log.info("corpCompany responseEntity\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONObject("data").getJSONArray("list");
            }
            log.info("\u67e5\u8be2\u516c\u53f8\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u516c\u53f8\u5f02\u5e38\uff1a{} ", (Throwable)e2);
        }
        return new JSONArray();
    }
}

