/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
public class MySqlDataSourceConfig {
    @Value(value="${spring.datasource.primary.max-retries}")
    private int primaryMaxRetries;
    @Value(value="${spring.datasource.secondary.max-retries}")
    private int secondaryMaxRetries;

    @Primary
    @Bean(name={"primaryDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.primary")
    public DataSource primaryDataSource() {
        DruidDataSource dataSource = DruidDataSourceBuilder.create().build();
        this.setMaxRetries(dataSource, this.primaryMaxRetries);
        return dataSource;
    }

    @Bean(name={"secondaryDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.secondary")
    public DataSource secondaryDataSource() {
        DruidDataSource dataSource = DruidDataSourceBuilder.create().build();
        this.setMaxRetries(dataSource, this.secondaryMaxRetries);
        return dataSource;
    }

    private void setMaxRetries(DruidDataSource dataSource, int maxRetries) {
        dataSource.setConnectionErrorRetryAttempts(maxRetries);
        dataSource.setMaxWait(5000L);
        dataSource.setBreakAfterAcquireFailure(true);
    }

    @Primary
    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactory(@Qualifier(value="primaryDataSource") DataSource primaryDataSource) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactory = new MybatisSqlSessionFactoryBean();
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:/mapper/mysql/*Mapper.xml"));
        sessionFactory.setDataSource(primaryDataSource);
        return sessionFactory.getObject();
    }

    @Bean(name={"secondarySqlSessionFactory"})
    public SqlSessionFactory secondarySqlSessionFactory(@Qualifier(value="secondaryDataSource") DataSource secondaryDataSource) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactory = new MybatisSqlSessionFactoryBean();
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:/mapper/mysql/*Mapper.xml"));
        sessionFactory.setDataSource(secondaryDataSource);
        return sessionFactory.getObject();
    }

    @Primary
    @Bean(name={"transactionManager"})
    public DataSourceTransactionManager transactionManager(@Qualifier(value="primaryDataSource") DataSource primaryDataSource) {
        return new DataSourceTransactionManager(primaryDataSource);
    }

    @Bean(name={"secondaryTransactionManager"})
    public DataSourceTransactionManager secondaryTransactionManager(@Qualifier(value="secondaryDataSource") DataSource secondaryDataSource) {
        return new DataSourceTransactionManager(secondaryDataSource);
    }
}

