/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.parse;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.parse.Parser;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.rule.RangeRule;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.rule.RuleType;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;

/*
 * Exception performing whole class analysis ignored.
 */
public enum RangeParser implements Parser<RangeRule>
{
    \u4e0e\u533a\u95f4("and_range", (matcher, rule) -> RangeParser.parseAndRange((Matcher)matcher, (List)rule.getOrder())),
    \u6216\u533a\u95f4("or_range", (matcher, rule) -> RangeParser.parseOrRange((Matcher)matcher, (List)rule.getOrder())),
    \u5355\u533a\u95f4("single_range", (matcher, rule) -> RangeParser.parseSingleRange((Matcher)matcher, (String)((String)rule.getOrder().get(0))));

    String parserType;
    BiFunction<Matcher, RangeRule, JSON> function;
    private final RuleType ruleType = RuleType.RANGE;
    private static final Map<String, Long> unitMap;

    private static long convertCnNumToInt(String cnNumStr) {
        long num = 0L;
        long tmpNum = 0L;
        for (char c : cnNumStr.toCharArray()) {
            Long digit = (Long)unitMap.get(String.valueOf(c));
            if (digit == null) continue;
            if (digit >= 10L) {
                tmpNum = tmpNum == 0L ? digit : tmpNum * digit;
                continue;
            }
            tmpNum += digit.longValue();
        }
        return tmpNum > 0L ? num + tmpNum : num;
    }

    private static long unitToMultiplier(String unit) {
        return unitMap.getOrDefault(unit, 1L);
    }

    private static JSONObject parseAndRange(Matcher matcher, List<String> orders) {
        String gte = matcher.group(1);
        String gteUnit = matcher.group(2);
        String lte = matcher.group(3);
        String lteUnit = matcher.group(4);
        long gteValue = (gte.matches("\\d+") ? Long.parseLong(gte) : RangeParser.convertCnNumToInt((String)gte)) * RangeParser.unitToMultiplier((String)gteUnit);
        long lteValue = (lte.matches("\\d+") ? Long.parseLong(lte) : RangeParser.convertCnNumToInt((String)lte)) * RangeParser.unitToMultiplier((String)lteUnit);
        if (orders.size() == 1) {
            long[] between = RangeParser.compareAndSort((long)gteValue, (long)lteValue);
            JSONObject compareObject = new JSONObject();
            compareObject.put("gte", (Object)between[0]);
            compareObject.put("lte", (Object)between[1]);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("and", (Object)compareObject);
            return jsonObject;
        }
        JSONObject compareObject = new JSONObject();
        compareObject.put(orders.get(0), (Object)gteValue);
        compareObject.put(orders.get(1), (Object)lteValue);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("and", (Object)compareObject);
        return jsonObject;
    }

    private static JSONObject parseOrRange(Matcher matcher, List<String> orders) {
        String val1 = matcher.group(1);
        String unit1 = matcher.group(2);
        String val2 = matcher.group(3);
        String unit2 = matcher.group(4);
        long val1Value = (val1.matches("\\d+") ? Long.parseLong(val1) : RangeParser.convertCnNumToInt((String)val1)) * RangeParser.unitToMultiplier((String)unit1);
        long val2Value = (val2.matches("\\d+") ? Long.parseLong(val2) : RangeParser.convertCnNumToInt((String)val2)) * RangeParser.unitToMultiplier((String)unit2);
        JSONObject compareObject = new JSONObject();
        compareObject.put(orders.get(0), (Object)val1Value);
        compareObject.put(orders.get(1), (Object)val2Value);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("or", (Object)compareObject);
        return jsonObject;
    }

    private static JSONObject parseSingleRange(Matcher matcher, String order) {
        String val = matcher.group(1);
        String unit = matcher.group(2);
        long valValue = (val.matches("\\d+") ? Long.parseLong(val) : RangeParser.convertCnNumToInt((String)val)) * RangeParser.unitToMultiplier((String)unit);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(order, (Object)valValue);
        return jsonObject;
    }

    public static long[] compareAndSort(long num1, long num2) {
        if (num1 > num2) {
            num1 ^= num2;
            num2 = num1 ^ num2;
            num1 ^= num2;
        }
        return new long[]{num1, num2};
    }

    public static String[] compareAndSort(String num1, String num2) {
        BigDecimal bd1 = new BigDecimal(num1);
        BigDecimal bd2 = new BigDecimal(num2);
        if (bd1.compareTo(bd2) <= 0) {
            return new String[]{num1, num2};
        }
        return new String[]{num2, num1};
    }

    public String getParserType() {
        return this.parserType;
    }

    public BiFunction<Matcher, RangeRule, JSON> getFunction() {
        return this.function;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    private RangeParser(String parserType, BiFunction<Matcher, RangeRule, JSON> function) {
        this.parserType = parserType;
        this.function = function;
    }

    static {
        unitMap = new HashMap();
        unitMap.put("", 1L);
        unitMap.put("\u5341", 10L);
        unitMap.put("\u767e", 100L);
        unitMap.put("\u5343", 1000L);
        unitMap.put("\u4e07", 10000L);
        unitMap.put("\u4ebf", 100000000L);
        unitMap.put("\u5146", 1000000000000L);
    }
}

