/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.datasource;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.beans.pojos.vector.SearchDocsQo;
import com.digiwin.chatbi.beans.pojos.vector.SearchDocsResult;
import com.digiwin.chatbi.common.enums.KnowledgeDatabase;
import com.digiwin.chatbi.common.exception.KnowledgeBaseOperationAssert;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.PipelineFactory;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.KnowledgeBaseService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeDatasourceMatchExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeDatasourceMatchExecutor.class);
    public static final Map<String, JSONObject> knowledgeBaseNameMap = new ConcurrentHashMap();
    private final Double scoreThreshold = 1.0;

    public static JSONObject getKnowledgeBaseNameMap(String knowledgeBaseName) {
        return (JSONObject)knowledgeBaseNameMap.get(knowledgeBaseName);
    }

    public static boolean inKnowledgeBaseNameMap(String knowledgeBaseName) {
        return knowledgeBaseNameMap.containsKey(knowledgeBaseName);
    }

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)PipelineFactory.PipelineKey.KNOWLEDGE_DATASOURCE.getKey()) && Objects.nonNull(context.get((Object)PipelineFactory.PipelineKey.KNOWLEDGE_DATASOURCE.getKey()));
    }

    public Output doProcess(JSONObject context) {
        Output output = Output.through();
        context.getJSONArray(PipelineFactory.PipelineKey.KNOWLEDGE_DATASOURCE.getKey()).parallelStream().forEach(knowledgeBaseName -> output.keep(this.getModelDataSource((KnowledgeDatabase)knowledgeBaseName, (Question)context.getObject(PipelineFactory.PipelineKey.QUESTION.getKey(), Question.class))));
        return output;
    }

    private SearchDocsQo getSearchDocsQo(String knowledgeBaseName, Question question) {
        SearchDocsQo searchDocsQo = new SearchDocsQo();
        searchDocsQo.setQuery(question.getMessage().replace("explain:", ""));
        searchDocsQo.setKnowledge_base_name(knowledgeBaseName);
        searchDocsQo.setTop_k(question.getSceneTopK());
        searchDocsQo.setScore_threshold(this.scoreThreshold);
        return searchDocsQo;
    }

    private JSONObject getModelDataSource(KnowledgeDatabase knowledgeBase, Question question) {
        SearchDocsQo searchDocsQo = this.getSearchDocsQo(knowledgeBase.getDatabaseName(), question);
        StopWatch stopWatch = StopWatch.createStarted();
        List searchDocsResults = (List)KnowledgeBaseOperationAssert.DATA_SOURCE_QUERY_RESPONSE_REQUEST_FAILED_ASSERT.tryCatch(() -> ((KnowledgeBaseService)SpringContextUtil.getBean(KnowledgeBaseService.class)).searchDocs(searchDocsQo), new Object[0]);
        stopWatch.stop();
        log.info("\u5411\u91cf\u5e93" + knowledgeBase.getDatabaseName() + "\u67e5\u8be2\u8017\u65f6:" + stopWatch.getTime() + "ms");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(knowledgeBase + "_datasource", searchDocsResults.stream().map(SearchDocsResult::getPage_content).peek(pageContent -> {
            try {
                JSONObject content = JSONObject.parseObject((String)pageContent);
                if (pageContent.contains(PipelineFactory.PipelineKey.DATASOURCE_ID.getKey())) {
                    knowledgeBaseNameMap.put(content.getString(PipelineFactory.PipelineKey.DATASOURCE_ID.getKey()), content);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).collect(Collectors.toList()));
        return jsonObject;
    }
}

