/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.MetricSearchResultEnum;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.reasoning.sse.SseSendService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildMetricDataSourceExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(BuildMetricDataSourceExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_metric");
    }

    public Output doProcess(JSONObject context) {
        if (MetricSearchResultEnum.NO_METRIC.getValue().equals(context.getString(MetricSearchResultEnum.NO_METRIC.getKey()))) {
            return Output.through();
        }
        CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
        Output output = Output.through();
        Question question = (Question)context.getObject("question", Question.class);
        String questionMsg = question.getMessage().replace("explain:", "");
        JSONObject input = new JSONObject();
        input.put("applicationCodes", Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class));
        input.put("version", (Object)context.getString("version"));
        input.put("question", (Object)questionMsg);
        List metrics = (List)context.getOrDefault((Object)"mixModeMetrics", new ArrayList());
        if (CollectionUtils.isEmpty((Collection)metrics)) {
            LogCheckDto logCheckDto = new LogCheckDto();
            logCheckDto.buildParams("BuildMetricDataSourceExecutor", "U.SCRUMBI.901.0110", input.toJSONString(), "\u7528\u6237\u5df2\u8ba2\u8d2d\u5e94\u7528\u4e0b\u65e0\u4efb\u4f55\u6307\u6807\uff0c\u53ef\u80fd\u662f\u79df\u6237\u3010" + context.getString("tenantId") + "\u3011" + "\u548c\u5e94\u7528\u7248\u672c\u4e0d\u76f8\u540c\u6216\u672a\u914d\u7f6e\u5e94\u7528\u6743\u9650", "1.\u786e\u8ba4\u7528\u6237\u6743\u9650\u5728\u6743\u9650\u7ba1\u7406\u754c\u9762\u662f\u5426\u6b63\u786e\u3002\n2.\u95ee\u9898\u662f\u5728\u6d4b\u8bd5\u533a\uff0c\u79df\u6237\u7248\u672c1.0\u9700\u53d1\u7248\u6307\u6807\u6240\u5728\u7684\u5e94\u7528\uff0c2.0\u9700\u5207\u7248\u6307\u6807\u6240\u5728\u7684\u5e94\u7528\u3002\n3.\u8fdb\u5165\u7cfb\u7edf\u7684\u53d1\u7248\u6216\u5207\u7248\u64cd\u4f5c\u754c\u9762\uff0c\u6267\u884c\u64cd\u4f5c\u3002\n4.\u5907\u4efd\u6570\u636e\u540e\u53d1\u7248\u6216\u5207\u7248\uff0c\u5b8c\u6210\u540e\u68c0\u67e5\u7cfb\u7edf\u662f\u5426\u6b63\u5e38\uff0c\u5426\u5219\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            logCheckDtos.add(logCheckDto);
            return Output.finish((String)"success", (Object)false).keep("mix_standard_synonyms_before_filter", context.getOrDefault((Object)"mix_standard_synonyms_before_filter", new ArrayList())).keep("mix_standard_synonyms_after_filter", context.getOrDefault((Object)"mix_standard_synonyms_after_filter", new ArrayList())).keep("reply", (Object)"message.scrumbi.no.metric.error").keep("logCheckDtos", logCheckDtos);
        }
        SseSendService sseSendService = (SseSendService)SpringContextUtil.getBean(SseSendService.class);
        String names = metrics.stream().map(metric -> metric.getString("metricName")).collect(Collectors.toList()).toString();
        metrics.stream().map(metric -> metric.getString("metricName")).collect(Collectors.toList()).toString();
        sseSendService.asyncSendAQDetailAndSCTitle(question, names, question.isIfStream(), context);
        List standardWords = (List)context.getOrDefault((Object)"mix_standard_synonyms_after_filter", new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)standardWords)) {
            context.put("metric_standard_synonyms_after_filter", (Object)standardWords);
            HashSet seen = new HashSet();
            List distinctMetricStandardWords = standardWords.stream().filter(json -> {
                String standardName = json.getString("standard_name");
                String compareField = json.getString("compare_field");
                return seen.add(standardName + compareField);
            }).collect(Collectors.toList());
            context.put("distinctMetricStandardWords", distinctMetricStandardWords);
            metrics = Optional.ofNullable(Retrieve.METRIC_V2.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
            ArrayList<JSONObject> distinctMetricStandardWords4Gpt = new ArrayList<JSONObject>();
            if (CollectionUtils.isNotEmpty((Collection)metrics) && CollectionUtils.isNotEmpty(distinctMetricStandardWords)) {
                for (JSONObject metric2 : metrics) {
                    for (JSONObject distinctMetricStandardWord : distinctMetricStandardWords) {
                        if (!metric2.getString("metricName").equals(distinctMetricStandardWord.getString("standard_name")) || !((List)distinctMetricStandardWord.get((Object)"applicationCodes")).contains(metric2.getString("applicationCode"))) continue;
                        distinctMetricStandardWords4Gpt.add(distinctMetricStandardWord);
                    }
                }
            }
            context.put("distinctMetricStandardWords4Gpt", distinctMetricStandardWords4Gpt.stream().distinct().collect(Collectors.toList()));
        }
        return output.keep("final_metric", (Object)metrics).keep(MetricSearchResultEnum.ONE_METRIC.getKey(), (Object)MetricSearchResultEnum.ONE_METRIC.getValue()).keep("metric_size", (Object)(Objects.nonNull(metrics) ? metrics.size() : 0)).keep("billingGoodsId", (Object)(Objects.nonNull(metrics) ? ((JSONObject)metrics.get(0)).getString("billingGoodsId") : "")).keep("sentences_param_4_schemas_check", (Object)StringUtil.buildSentencesParam4Metric((List)metrics, (String)((Question)context.getObject("question", Question.class)).getLocale()));
    }
}

