/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildSentencesExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(BuildSentencesExecutor.class);

    public Output doProcess(JSONObject context) {
        Map map = (Map)context.getObject("need_sentences_param_4_mix", HashMap.class);
        if (Objects.isNull(map)) {
            log.info("\u731c\u4f60\u60f3\u95ee\u53c2\u6570\u4e3a\u7a7a");
            return Output.finish();
        }
        List targets = (List)map.get("target");
        List metrics = (List)map.get("metric");
        List metricNames = metrics.stream().map(t -> t.getString("metricName")).distinct().collect(Collectors.toList());
        ArrayList sentences = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)targets)) {
            targets = targets.stream().collect(Collectors.collectingAndThen(Collectors.toMap(jsonObject -> jsonObject.getString("datasourceName"), jsonObject -> jsonObject, (existing, replacement) -> existing), targetMap -> targetMap.values().stream().collect(Collectors.toList())));
            for (JSONObject target : targets) {
                List targetSentences;
                if (CollectionUtils.isEmpty(metricNames)) {
                    targetSentences = (List)((Map)context.getOrDefault((Object)"locale_sentences", new HashMap())).get(target.getString("datasourceId"));
                    sentences.add(targetSentences.get(0));
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(metricNames) || metricNames.contains(target.getString("datasourceName")) || CollectionUtils.isEmpty((Collection)(targetSentences = (List)((Map)context.getOrDefault((Object)"locale_sentences", new HashMap())).get(target.getString("datasourceId"))))) continue;
                sentences.add(targetSentences.get(0));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)metrics)) {
            try {
                if (!Objects.isNull(context.getJSONObject("uncertain_metric_suggested_queries"))) {
                    JSONArray questions = context.getJSONObject("uncertain_metric_suggested_queries").getJSONArray("questions");
                    for (Object o : questions) {
                        String question = ((JSONObject)o).getString("question");
                        if (!StringUtils.isNotEmpty((CharSequence)question)) continue;
                        sentences.add(question);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u6307\u6807\u573a\u666f\u6df7\u5408\u83b7\u53d6\u731c\u4f60\u60f3\u95ee\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return Output.finish((String)"sentences", sentences).keep("success", (Object)false);
    }
}

