/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.constant.Constants;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFicationCheckExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(ClassFicationCheckExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_metric");
    }

    public Output doProcess(JSONObject context) {
        CopyOnWriteArrayList<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList<LogCheckDto>() : (List)context.get((Object)"logCheckDtos");
        LogCheckDto logCheckDto = new LogCheckDto();
        String name = "Query_Classification";
        String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
        Map intent_map = Constants.intent_map;
        if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
            name = name + "_V1";
            intent_map = Constants.intent_map_4_dataset_V1;
        } else if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion)) {
            name = name + "_V2";
            intent_map = Constants.intent_map_4_dataset_V2;
        }
        JSONObject jsonObject = context.getJSONObject(name);
        Integer no_metric_use_gpt_flag = context.getInteger("no_metric_use_gpt_flag");
        String result = "LLM\u5224\u65ad\u8be5\u95ee\u53e5\u53ef\u80fd\u5c5e\u4e8e\u6682\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u6216\u5206\u6790\u7c7b\u578b\uff0c\u53ef\u80fd\u662f\u63d0\u95ee\u65b9\u5f0f\u4e0d\u592a\u7406\u89e3\uff0c\u6216\u8005\u6570\u636e\u6d41\u6ca1\u6709\u6240\u9700\u7684\u67e5\u8be2\u5b57\u6bb5";
        String suggestion = "1.\u5206\u6790\u95ee\u53e5\u662f\u5426\u4e3a\u4e0d\u652f\u6301\u7684\u63d0\u95ee\u65b9\u5f0f\uff0c\u5982\u679c\u662f\u53ef\u4ee5\u5f15\u5bfc\u5ba2\u6237\u6362\u4e00\u79cd\u8868\u8fbe\u65b9\u5f0f\u6216\u95ee\u6cd5\u3002\n2.\u5982\u679c\u95ee\u53e5\u4e3a\u5e94\u8be5\u652f\u6301\u7684\u6307\u6807\u95ee\u6570\uff0c\u53ef\u4ee5\u5c1d\u8bd5\u8c03\u6574\u6307\u6807\u7684\u8bbe\u7f6e\uff0c\u5982\u67e5\u8be2\u65b9\u6848\u548c\u5173\u8054\u5b57\u6bb5\u7b49\u6ee1\u8db3\u7528\u6237\u63d0\u95ee\u3002\n3.\u5982\u95ee\u53e5\u4ecd\u672a\u89e3\u51b3\uff0c\u53ef\u4ee5\u5c06\u4fe1\u606f\u53cd\u9988\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002";
        String errorCode = "U.SCRUMBI.901.0118";
        if (Objects.nonNull(no_metric_use_gpt_flag)) {
            result = "\u4ece\u95ee\u53e5\u4e2d\u672a\u5339\u914d\u5230\u4efb\u4f55\u6307\u6807\u3001\u573a\u666f\u6216\u540c\u4e49\u8bcd\uff0c\u53ef\u80fd\u662f\u7528\u6237\u95ee\u5230\u5df2\u5b9a\u4e49\u6307\u6807\u53ca\u573a\u666f\u8303\u56f4\u4e4b\u5916\u7684\u95ee\u9898\uff0c\u6216\u6ca1\u6709\u5b9a\u4e49\u540c\u4e49\u8bcd\u5bfc\u81f4\u95ee\u9898\u4e0d\u80fd\u88ab\u8bc6\u522b";
            suggestion = "1.\u68c0\u67e5\u6307\u6807\u3001\u573a\u666f\u76ee\u6807\u548c\u540c\u4e49\u8bcd\u7684\u914d\u7f6e\u9875\u9762\uff0c\u786e\u8ba4\u914d\u7f6e\u662f\u5426\u5b8c\u6574\u3002\n2.\u786e\u4fdd\u6307\u6807\u548c\u573a\u666f\u7684\u5b9a\u4e49\u53ca\u540c\u4e49\u8bcd\u8bbe\u7f6e\u6b63\u786e\u3002\n3.\u82e5\u6307\u6807\u6b63\u786e\uff0c\u68c0\u67e5\u95ee\u53e5\u662f\u5426\u590d\u6742\u6216\u8d85\u51fa\u7cfb\u7edf\u5904\u7406\u8303\u56f4\u3002\n4.\u82e5\u95ee\u9898\u672a\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\uff0c\u63d0\u4f9b\u8be6\u7ec6\u4fe1\u606f\u3002";
            errorCode = "U.SCRUMBI.901.0126";
        }
        if (Objects.isNull(jsonObject) || StringUtils.isEmpty((CharSequence)jsonObject.getString("code"))) {
            logCheckDto.buildParams("ClassFicationCheckExecutor", errorCode, "", result, suggestion);
            logCheckDtos.add(logCheckDto);
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.gpt.analysis.intent.out.range").keep("logCheckDtos", logCheckDtos);
        }
        if (Objects.isNull(intent_map.get(jsonObject.getString("code")))) {
            log.error("intentType out of ability,{}", (Object)jsonObject);
            logCheckDto.buildParams("ClassFicationCheckExecutor", errorCode, jsonObject.toJSONString(), result, suggestion);
            logCheckDtos.add(logCheckDto);
            return Output.finish((String)"success", (Object)false).keep("reply", (Object)"message.scrumbi.gpt.analysis.intent.out.range").keep("logCheckDtos", logCheckDtos);
        }
        return Output.through();
    }
}

