/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.autoData;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.autoData.ReportCreateReq;
import com.digiwin.chatbi.client.GPT_CLIENT;
import com.digiwin.chatbi.common.exception.PromptAssert;
import com.digiwin.chatbi.reasoning.executor.prompt.PromptExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBQuestionGeneratorPromptExecutor
extends PromptExecutor {
    private static final Logger log = LoggerFactory.getLogger(DBQuestionGeneratorPromptExecutor.class);

    public static DBQuestionGeneratorPromptExecutor OfExecutor(String type, String name, GPT_CLIENT gpt_client) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Output doProcess(JSONObject context) {
        ReportCreateReq req = (ReportCreateReq)context.getObject("reportCreateReq", ReportCreateReq.class);
        context.put("locale_zh", (Object)("zh_TW".equalsIgnoreCase(req.getLocale()) ? "\u7e41\u4f53\u4e2d\u6587" : "\u7b80\u4f53\u4e2d\u6587"));
        List query_database_sections = (List)context.get((Object)"query_database_sections");
        if (CollectionUtils.isEmpty((Collection)query_database_sections)) {
            log.info("\u6570\u636e\u5e93\u4efb\u52a1\u89c4\u5212\u4e3a\u7a7a");
            return Output.through();
        }
        query_database_sections.forEach(q -> {
            q.remove((Object)"query_database");
            q.remove((Object)"query_internet");
        });
        JSONObject userJson = new JSONObject();
        userJson.put("blueprint_sections", (Object)query_database_sections);
        ArrayList relate_metrics = query_database_sections.stream().flatMap(section -> section.getJSONArray("relate_metrics").stream()).distinct().collect(ArrayList::new, List::add, List::addAll);
        context.put("appCodesCondition", Arrays.asList(req.getAppCode()));
        context.put("version", context.get((Object)"version"));
        context.put("metrics", (Object)relate_metrics);
        List dataSets = Optional.ofNullable(Retrieve.DATASET_V2.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)dataSets)) {
            log.warn("\u672a\u627e\u5230\u6570\u636e\u96c6");
            return Output.through();
        }
        List database_schema = dataSets.stream().map(dataSet -> {
            String datasetName = dataSet.getString("datasetName");
            List columns = dataSet.getJSONArray("fieldSchema").stream().map(JSONObject.class::cast).map(field -> field.getString("title")).collect(Collectors.toList());
            JSONArray metrics = dataSet.getJSONArray("metrics");
            JSONObject res = new JSONObject();
            JSONObject dataset = new JSONObject();
            dataset.put("columns", columns);
            dataset.put("metrics", (Object)metrics);
            res.put(datasetName, (Object)dataset);
            return res;
        }).collect(Collectors.toList());
        userJson.put("database_schema", database_schema);
        String gptResult = (String)PromptAssert.PROMPT_CALL_FAIL_ASSERT.tryCatch(() -> super.callGpt(super.systemMessage(context), JSONObject.toJSONString((Object)userJson), null, Integer.valueOf(4096), context.getString("temperature"), req.getToken()), e -> "error:" + e.getMessage());
        return this.setContext(gptResult, context).keep("final_dataSet", (Object)dataSets);
    }

    public boolean onCondition(JSONObject context) {
        return true;
    }
}

