/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.convoBoard;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.convoBoard.ChartPlanReq;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.sse.SseSendService4ConvoBoard;
import com.digiwin.chatbi.service.MessageUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindDatasetByMetric4ConvoBoardExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(FindDatasetByMetric4ConvoBoardExecutor.class);

    public Output doProcess(JSONObject context) {
        Map metricAndDataSetIdsMap = (Map)context.get((Object)"metricAndDataSetIdsMap");
        List dataSets = (List)context.get((Object)"final_dataSet");
        SseSendService4ConvoBoard bean = (SseSendService4ConvoBoard)SpringContextUtil.getBean(SseSendService4ConvoBoard.class);
        MessageUtils messageUtils = (MessageUtils)SpringContextUtil.getBean(MessageUtils.class);
        ChartPlanReq req = (ChartPlanReq)context.getObject("chartPlanReq", ChartPlanReq.class);
        JSONObject intent_analyze = context.getJSONObject("intent_analyze");
        try {
            JSONArray metrics = intent_analyze.getJSONArray("analysis_metrics");
            List dataSetIds = metrics.stream().flatMap(metric -> {
                List ids = (List)metricAndDataSetIdsMap.get(metric);
                return ids != null ? ids.stream() : Stream.empty();
            }).distinct().collect(Collectors.toList());
            dataSets = dataSets.stream().filter(dataSet -> dataSetIds.contains(dataSet.getString("datasetId"))).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.warn("\u67e5\u627e\u6570\u636e\u96c6\u5f02\u5e38{}", (Throwable)e);
            bean.asyncSendIntentionAnalysic(req.getId(), "### **\u610f\u56fe\u89e3\u8bfb\u5206\u6790**\n" + messageUtils.getMessage("message.scrumbi.no.metric.error"), req.getLocale(), req.isIfStream(), context, Boolean.valueOf(false));
            return Output.finish((String)"success", (Object)true);
        }
        if (CollectionUtils.isEmpty(dataSets) && 2 != intent_analyze.getIntValue("intent_code")) {
            bean.asyncSendIntentionAnalysic(req.getId(), "### **\u610f\u56fe\u89e3\u8bfb\u5206\u6790**\n" + messageUtils.getMessage("message.scrumbi.no.metric.error"), req.getLocale(), req.isIfStream(), context, Boolean.valueOf(false));
            return Output.finish((String)"success", (Object)true);
        }
        bean.asyncSendIntentionAnalysic(req.getId(), context.getJSONObject("intent_analyze").getString("query_understanding") + "\n", req.getLocale(), req.isIfStream(), context, Boolean.valueOf(true));
        return Output.through((String)"final_dataSet", dataSets);
    }
}

