/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.util.MatchFinder;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.service.StandardWordsService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchKnowledgeExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchKnowledgeExecutor.class);

    public Output doProcess(JSONObject context) {
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        List habitualknowledges = new ArrayList();
        try {
            habitualknowledges = Optional.ofNullable(Retrieve.HABITUALKNOWLEDGE.retrieve(context)).filter(list -> !list.isEmpty()).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
        }
        catch (Exception e) {
            log.error("\u68c0\u7d22\u4e60\u60ef\u77e5\u8bc6\u5f02\u5e38");
        }
        JSONObject nounknowledgesMatchWResult = null;
        try {
            ForkJoinPool pool = new ForkJoinPool(2);
            Future nounknowledgesTask = pool.submit(() -> Arrays.asList(Retrieve.NOUNKNOWLEDGE, Retrieve.NOUNKNOWLEDGE_FOR_LONG).parallelStream().map(retrieve -> retrieve.retrieveQuestion(question, context)).reduce((resp1, resp) -> StandardWordsService.mergeJsonObjects((JSONObject)resp1, (JSONObject)resp)).get());
            nounknowledgesMatchWResult = (JSONObject)((ForkJoinTask)nounknowledgesTask).join();
            pool.shutdown();
        }
        catch (Exception e) {
            log.error("\u68c0\u7d22\u884c\u4e1a\u77e5\u8bc6\u5f02\u5e38");
        }
        ArrayList<JSONObject> nounknowledges = new ArrayList<JSONObject>();
        if (Objects.nonNull(nounknowledgesMatchWResult) && !Objects.isNull(nounknowledgesMatchWResult.getJSONObject("hits")) && CollectionUtils.isNotEmpty((Collection)nounknowledgesMatchWResult.getJSONObject("hits").getJSONArray("hits"))) {
            JSONArray hits = nounknowledgesMatchWResult.getJSONObject("hits").getJSONArray("hits");
            for (Object hitObj : hits) {
                JSONObject source = ((JSONObject)hitObj).getJSONObject("_source");
                JSONObject res = new JSONObject();
                res.put("entity_type", (Object)"knowledge");
                res.put("assistant_id", source.get((Object)"applicationCode"));
                res.put("applicationCodes", Arrays.asList(source.getString("assistant_id")));
                res.put("version", source.get((Object)"version"));
                res.put("synonyms", source.get((Object)"synonyms"));
                res.put("standard_name", source.get((Object)"businessDefine"));
                List[] matchesWithOverlap = MatchFinder.findMatchesWithOverlap((String)question, (String)source.getString("businessDefine"), (List)((List)source.getOrDefault((Object)"synonyms", new ArrayList())));
                res.put("match_words", (Object)matchesWithOverlap[0]);
                res.put("highlight_words", (Object)matchesWithOverlap[1]);
                res.put("effectiveScope", source.get((Object)"effectiveScope"));
                res.put("datasetIds", source.get((Object)"datasetIds"));
                res.put("explanation", source.get((Object)"explanation"));
                nounknowledges.add(res);
            }
        }
        return Output.through((String)"allHabitualknowledges", habitualknowledges).keep("allNounknowledges", nounknowledges);
    }
}

