/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract.dataSet;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.executor.extract.dataSet.SupplementDataSetsByGptFindedFieldsExecutor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupplementDataSetsByGptFindedFieldsExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SupplementDataSetsByGptFindedFieldsExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_dataSet");
    }

    public Output doProcess(JSONObject context) {
        HashMap mayBeSupplementedMap = (HashMap)context.getOrDefault((Object)"mayBeSupplementedMap", new HashMap());
        JSONObject tableFilter = context.getJSONObject("TableFilter");
        JSONArray selected_tables = tableFilter.getJSONArray("selected_tables");
        JSONArray selected_fields = tableFilter.getJSONArray("selected_fields");
        List datasetIdsSelectedByGpt = selected_tables.stream().filter(id -> Objects.nonNull(id)).map(id -> (String)id).collect(Collectors.toList());
        List dataSets_with_permission = (List)context.getOrDefault((Object)"dataSets_with_permission", new ArrayList());
        List dataSetsSelectedByGpt = dataSets_with_permission.stream().filter(dataSet -> datasetIdsSelectedByGpt.contains(dataSet.getString("datasetId"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataSetsSelectedByGpt)) {
            log.info("gpt\u9009\u62e9\u7684\u6570\u636e\u96c6\u4e3a\u7a7a\u6216\u6ca1\u6709\u6743\u9650");
            return Output.through((String)"matched_table_ids_es", new ArrayList());
        }
        if (MapUtils.isEmpty((Map)mayBeSupplementedMap) || CollectionUtils.isEmpty((Collection)selected_fields)) {
            log.info("\u5b57\u6bb5\u548c\u5173\u7cfb\u6620\u5c04\u4e3a\u7a7a\u6216gpt\u9009\u62e9\u7684\u5b57\u6bb5\u4e3a\u7a7a");
            return Output.through((String)"matched_table_ids_es", datasetIdsSelectedByGpt);
        }
        List selectedFieldsAfterFilter = this.filterHallucinationOrDuplicateSelectFields((Map)mayBeSupplementedMap, selected_fields, datasetIdsSelectedByGpt);
        if (CollectionUtils.isEmpty((Collection)selectedFieldsAfterFilter)) {
            log.info("gpt\u9009\u62e9\u7684\u5b57\u6bb5\u4e3a\u5e7b\u89c9\u5b57\u6bb5\u6216\u91cd\u590d\u5b57\u6bb5:{}", (Object)selected_fields);
            return Output.through((String)"matched_table_ids_es", datasetIdsSelectedByGpt);
        }
        Map<String, Set> mayBeSupplementedMap4Score = mayBeSupplementedMap.entrySet().stream().filter(entry -> selectedFieldsAfterFilter.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List dataSetsAfterSupplementation = this.supplementDataSets(context, mayBeSupplementedMap4Score, datasetIdsSelectedByGpt, dataSetsSelectedByGpt);
        return Output.through((String)"matched_table_ids_es", dataSetsAfterSupplementation.stream().map(dataset -> dataset.getString("datasetId")).distinct().collect(Collectors.toList()));
    }

    private List<String> filterHallucinationOrDuplicateSelectFields(Map<String, Set<JSONObject>> mayBeSupplementedMap, JSONArray selected_fields, List<String> dataSetsSelectedByGpt) {
        return selected_fields.stream().filter(field -> {
            if (CollectionUtils.isEmpty((Collection)((Collection)mayBeSupplementedMap.get(field)))) {
                return false;
            }
            List dataSetIds = ((Set)mayBeSupplementedMap.get(field)).stream().map(dataset -> dataset.getString("datasetId")).collect(Collectors.toList());
            dataSetIds.retainAll(dataSetsSelectedByGpt);
            return dataSetIds.size() <= 0;
        }).map(field -> field.toString()).collect(Collectors.toList());
    }

    private List<JSONObject> supplementDataSets(JSONObject context, Map<String, Set<JSONObject>> mayBeSupplementedMap, List<String> datasetIdsByGpt, List<JSONObject> dataSetsSelectedByGpt) {
        ArrayList<JSONObject> dataSetsAfterSupplementation = new ArrayList<JSONObject>();
        List mayBeSupplementedDataSetIds = mayBeSupplementedMap.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(value -> value.getString("datasetId")).collect(Collectors.toList()).stream()).collect(Collectors.toList());
        dataSetsAfterSupplementation.addAll(dataSetsSelectedByGpt);
        for (Map.Entry<String, Set<JSONObject>> entry2 : mayBeSupplementedMap.entrySet()) {
            if (entry2.getValue().size() == 1) {
                dataSetsAfterSupplementation.addAll((Collection<JSONObject>)entry2.getValue());
                continue;
            }
            dataSetsAfterSupplementation.add(this.getMaxScoreDataSet(dataSetsSelectedByGpt, entry2.getValue(), context, mayBeSupplementedDataSetIds, datasetIdsByGpt));
        }
        return dataSetsAfterSupplementation;
    }

    private JSONObject getMaxScoreDataSet(List<JSONObject> dataSetsSelectedByGpt, Set<JSONObject> targetDataSets, JSONObject context, List<String> mayBeSupplementedDataSetIds, List<String> datasetIdsByGpt) {
        List straightRelationships = this.getStraightRelationships(context, datasetIdsByGpt, mayBeSupplementedDataSetIds);
        ArrayList<TableScore> results = new ArrayList<TableScore>();
        for (JSONObject targetDataSet : targetDataSets) {
            int totalScore = 0;
            for (JSONObject sourceDataSet : dataSetsSelectedByGpt) {
                int commonFieldCount = this.countCommonFields(targetDataSet, sourceDataSet);
                int relationFieldCount = this.countRelationFields(straightRelationships, targetDataSet.getString("datasetId"), sourceDataSet.getString("datasetId"));
                int moduleMatchCount = this.countCommonModules(targetDataSet, sourceDataSet);
                int systemMatchCount = this.countCommonSubsystems(targetDataSet, sourceDataSet);
                int sa = 0;
                if (commonFieldCount > 0 || relationFieldCount > 0) {
                    sa = commonFieldCount + relationFieldCount * 50 + 1000;
                }
                int sb = moduleMatchCount * 2;
                int sc = systemMatchCount;
                int scoreAB = sa + sb + sc;
                totalScore += scoreAB;
            }
            results.add(new TableScore(this, targetDataSet, totalScore));
        }
        List sortedList = results.stream().sorted((t1, t2) -> Integer.compare(t2.getScore(), t1.getScore())).collect(Collectors.toList());
        return ((TableScore)sortedList.get(0)).getDataSet();
    }

    private List<JSONObject> getStraightRelationships(JSONObject context, List<String> sourceDataSetIds, List<String> targetDataSetIds) {
        ArrayList<String> allIds = new ArrayList<String>();
        allIds.addAll(sourceDataSetIds);
        allIds.addAll(targetDataSetIds);
        context.put("datasetIds", allIds);
        List straightRelationships = Optional.ofNullable(Retrieve.MATCH_STRAIGHT_TABLE_RELATIONSHIPS.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
        if (CollectionUtils.isEmpty((Collection)straightRelationships)) {
            return null;
        }
        return straightRelationships;
    }

    private int countCommonFields(JSONObject a, JSONObject b) {
        try {
            Set namesA = a.getJSONArray("fieldSchema").stream().map(JSONObject.class::cast).map(f -> f.getString("name")).collect(Collectors.toSet());
            Set namesB = b.getJSONArray("fieldSchema").stream().map(JSONObject.class::cast).map(f -> f.getString("name")).collect(Collectors.toSet());
            namesA.retainAll(namesB);
            return namesA.size();
        }
        catch (Exception e) {
            log.error("\u6c42\u5b57\u6bb5\u4ea4\u96c6\u5f02\u5e38:{}", (Throwable)e);
            return 0;
        }
    }

    private int countRelationFields(List<JSONObject> relsList, String idA, String idB) {
        try {
            if (CollectionUtils.isEmpty(relsList)) {
                return 0;
            }
            for (JSONObject rel : relsList) {
                if (!rel.getJSONArray("tables").contains((Object)idA) || !rel.getJSONArray("tables").contains((Object)idB)) continue;
                return rel.getJSONArray("on").size();
            }
            return 0;
        }
        catch (Exception e) {
            log.error("\u6c42\u5173\u7cfb\u5b57\u6bb5\u6570\u5f02\u5e38:{}", (Throwable)e);
            return 0;
        }
    }

    private int countCommonModules(JSONObject a, JSONObject b) {
        try {
            Set modulesA = a.getJSONArray("modules").stream().map(JSONObject.class::cast).map(m -> m.getString("name")).collect(Collectors.toSet());
            Set modulesB = b.getJSONArray("modules").stream().map(JSONObject.class::cast).map(m -> m.getString("name")).collect(Collectors.toSet());
            modulesA.retainAll(modulesB);
            return modulesA.size();
        }
        catch (Exception e) {
            log.error("\u6a21\u5757\u5339\u914d\u5f02\u5e38:{}", (Throwable)e);
            return 0;
        }
    }

    private int countCommonSubsystems(JSONObject a, JSONObject b) {
        try {
            Set subsA = a.getJSONArray("modules").stream().map(JSONObject.class::cast).flatMap(m -> m.getJSONArray("subsystems").stream().map(s -> s.toString()).collect(Collectors.toList()).stream()).collect(Collectors.toSet());
            Set subsB = b.getJSONArray("modules").stream().map(JSONObject.class::cast).flatMap(m -> m.getJSONArray("subsystems").stream().map(s -> s.toString()).collect(Collectors.toList()).stream()).collect(Collectors.toSet());
            subsA.retainAll(subsB);
            return subsA.size();
        }
        catch (Exception e) {
            log.error("\u5b50\u7cfb\u7edf\u5339\u914d\u5f02\u5e38:{}", (Throwable)e);
            return 0;
        }
    }
}

