/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.prompt;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.QuestionLite;
import com.digiwin.chatbi.client.GPT_CLIENT;
import com.digiwin.chatbi.common.enums.IntentType;
import com.digiwin.chatbi.common.exception.GptCallAssert;
import com.digiwin.chatbi.common.exception.PromptAssert;
import com.digiwin.chatbi.common.util.CommonUtil;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.PipelineFactory;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.prompt.TemplateLocalFileBroker;
import com.digiwin.chatbi.reasoning.search.config.RhEndpointConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class PromptLiteExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(PromptLiteExecutor.class);
    public static final String RESULT_NOT_JSON = "NOT_JSON_";
    private static final Map<String, GPT_CLIENT> GPT_CLIENT_MAP = new HashMap();
    private static final List<String> needAppendQList = Arrays.asList("Filter", "AnalysisPlanning", "Dimension");
    private static final String DEFAULT_GPT_CLIENT = "RH_HK_GPT4";
    private GPT_CLIENT gptClient = (GPT_CLIENT)GPT_CLIENT_MAP.getOrDefault("RH_HK_GPT4", GPT_CLIENT.RH.HK.GPT4);

    public abstract String getType();

    public abstract String getName();

    public abstract GPT_CLIENT getGptClient();

    protected String getPromptName() {
        return this.getType() + this.getName();
    }

    public static PromptLiteExecutor OfExecutor(String type, String name, GPT_CLIENT gpt_client) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static PromptLiteExecutor OfConditionExecutor(String type, String name, GPT_CLIENT gpt_client) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private String systemMessage(JSONObject context) {
        return ((TemplateLocalFileBroker)SpringContextUtil.getBean(TemplateLocalFileBroker.class)).get(this.getType(), this.getName()).getContent((Map)context);
    }

    public String callGpt(String systemMessage, String userMessage, String appendQuest, Integer maxToken, String temperature, String token) {
        StopWatch stopWatch = StopWatch.createStarted();
        RhEndpointConfig rhEndpointConfig = (RhEndpointConfig)SpringContextUtil.getBean(RhEndpointConfig.class);
        String result = this.getGptClient().call(systemMessage, Objects.isNull(appendQuest) ? userMessage : userMessage.concat(appendQuest), rhEndpointConfig.getHkEndpoint(), maxToken, temperature, token, null, null, Boolean.valueOf(false), (chunk, context) -> {}, null);
        stopWatch.stop();
        log.info("GPT calling time: {}ms, prompt: {}", (Object)stopWatch.getTime(), (Object)this.getPromptName());
        String data = (String)GptCallAssert.JSON_PARSE_FAIL_ASSERT.tryCatch(() -> {
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("code")) && "0".equals(jsonObject.getString("code"))) {
                return CommonUtil.extractDataBetweenBraces((String)jsonObject.getString("data"));
            }
            return null;
        }, new Object[0]);
        return StringUtils.isNotBlank((CharSequence)data) ? data : result;
    }

    protected Output setContext(String gptResult, JSONObject context) {
        return (Output)GptCallAssert.JSON_PARSE_FAIL_ASSERT.tryCatch(() -> {
            if (StringUtils.isEmpty((CharSequence)gptResult)) {
                context.put("RHErrorLog", (Object)(this.getName() + "RH\u89e3\u6790\u7ed3\u679c\u4e3a\u7a7a"));
            } else if (gptResult.startsWith("error:gpt\u8c03\u7528\u5931\u8d25")) {
                context.put("RHErrorLog", (Object)(this.getName() + "RH\u5f02\u5e38\u6216\u8d85\u65f6"));
            }
            JSONObject jsonObject = JSONObject.parseObject((String)gptResult);
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("intent_code")) && !"1".equals(jsonObject.getString("intent_code"))) {
                String reply = jsonObject.getString("reply");
                return Output.through((String)this.getName(), (Object)jsonObject).keep("success", (Object)false).keep("reply", (Object)(StringUtils.isEmpty((CharSequence)reply) ? "message.scrumbi.query.mode.error" : reply));
            }
            return Output.through((String)this.getName(), (Object)jsonObject).keep("success", (Object)true);
        }, e -> {
            log.error("gpt\u6267\u884c\u5f02\u5e38\uff1a{}", (Throwable)e);
            if (gptResult.startsWith("error:")) {
                return Output.finish((String)PipelineFactory.PipelineKey.INTENT_CODE.getKey(), (Object)IntentType.ERROR.getCode()).keep("error", (Object)e.getMessage()).keep("success", (Object)false).keep("reply", (Object)"message.scrumbi.query.mode.error");
            }
            Output keep = Output.through((String)(RESULT_NOT_JSON + this.getPromptName()), (Object)gptResult).keep("reply", (Object)"message.scrumbi.query.mode.error");
            return keep;
        });
    }

    public Output doProcess(JSONObject context) {
        QuestionLite question = (QuestionLite)context.getObject("question", QuestionLite.class);
        String questionMsg = null;
        if ("Multi_dialogue_and_select".equals(this.getName())) {
            questionMsg = context.getString("multi_question");
        }
        String finalQuestionMsg = questionMsg;
        String gptResult = (String)PromptAssert.PROMPT_CALL_FAIL_ASSERT.tryCatch(() -> this.callGpt(this.systemMessage(context), StringUtils.isNotBlank((CharSequence)finalQuestionMsg) ? finalQuestionMsg : question.getMessage(), null, Integer.valueOf(4096), context.getString("temperature"), question.getToken()), e -> "error:" + e.getMessage());
        return this.setContext(gptResult, context);
    }

    public String pipelineName() {
        return this.getPromptName();
    }

    static {
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.RH.HK.values()) {
            GPT_CLIENT_MAP.put("RH_HK_" + hK, hK);
            GPT_CLIENT_MAP.put("RH_" + hK, hK);
        }
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.STANDARD_OPENAI.AZURE.values()) {
            GPT_CLIENT_MAP.put("AZURE_" + hK.getModel().toString(), hK);
        }
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.STANDARD_OPENAI.AI_PROXY.values()) {
            GPT_CLIENT_MAP.put("AI_PROXY_" + hK.toString(), hK);
        }
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.STANDARD_OPENAI.AI_PROXY_VIP.values()) {
            GPT_CLIENT_MAP.put("AI_PROXY_VIP_" + hK.toString(), hK);
        }
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.RH.PASS.values()) {
            GPT_CLIENT_MAP.put("RH_" + hK, hK);
        }
    }
}

