/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.prompt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromptOutPutFilterExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(PromptOutPutFilterExecutor.class);
    String OUTPUT_KEY = "Filter";

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_scene") || context.containsKey((Object)"scelect_scene_metric_mix");
    }

    public Output doProcess(JSONObject context) {
        JSONObject jsonObject;
        JSONObject promptsFilter = context.getJSONObject(this.OUTPUT_KEY);
        if (!Objects.isNull(promptsFilter) && !Objects.isNull(jsonObject = this.buildNewFilter(promptsFilter))) {
            promptsFilter.put("condition", (Object)jsonObject);
        }
        return Output.through((String)this.OUTPUT_KEY, (Object)promptsFilter);
    }

    private JSONObject buildNewFilter(JSONObject context) {
        log.info("PromptOutPutFilterExecutor analysis result {}", (Object)context);
        if (context.containsKey((Object)"f")) {
            JSONObject condition = new JSONObject();
            JSONObject filter = context.getJSONObject("f");
            if (filter.containsKey((Object)"lo")) {
                condition.put("logitype", filter.get((Object)"lo"));
            }
            JSONArray chdArray = filter.getJSONArray("chd");
            JSONArray items = new JSONArray();
            if (CollectionUtils.isNotEmpty((Collection)chdArray)) {
                chdArray.forEach(item -> {
                    JSONArray coArr;
                    JSONObject temp = (JSONObject)item;
                    if (temp.containsKey((Object)"co") && CollectionUtils.isNotEmpty((Collection)(coArr = temp.getJSONArray("co")))) {
                        String operator = coArr.getString(1);
                        String leftValueType = coArr.getString(3);
                        String left = coArr.getString(0);
                        if ("btw".equals(operator)) {
                            JSONObject lteDate = new JSONObject();
                            lteDate.put("op", (Object)"lte");
                            lteDate.put("left", (Object)left);
                            lteDate.put("left_date_format", (Object)"yyyy-MM-dd");
                            lteDate.put("right_value_type", (Object)leftValueType);
                            lteDate.put("type", (Object)"constant");
                            lteDate.put("logitype", (Object)"single");
                            lteDate.put("right_date_format", (Object)"yyyy-MM-dd");
                            lteDate.put("left_value_type", (Object)leftValueType);
                            JSONObject gteDate = new JSONObject();
                            gteDate.put("op", (Object)"gte");
                            gteDate.put("left", (Object)left);
                            gteDate.put("left_date_format", (Object)"yyyy-MM-dd");
                            gteDate.put("right_value_type", (Object)leftValueType);
                            gteDate.put("type", (Object)"constant");
                            gteDate.put("logitype", (Object)"single");
                            gteDate.put("right_date_format", (Object)"yyyy-MM-dd");
                            gteDate.put("left_value_type", (Object)leftValueType);
                            if (StringUtils.isNotBlank((CharSequence)coArr.getString(2))) {
                                String[] dateArr = coArr.getString(2).split("#");
                                lteDate.put("right", (Object)dateArr[1]);
                                gteDate.put("right", (Object)dateArr[0]);
                            }
                            items.add((Object)gteDate);
                            items.add((Object)lteDate);
                        } else {
                            JSONObject eqObject = new JSONObject();
                            eqObject.put("op", (Object)operator);
                            eqObject.put("left", (Object)left);
                            eqObject.put("right_value_type", (Object)leftValueType);
                            eqObject.put("right", (Object)coArr.getString(2));
                            eqObject.put("type", (Object)"constant");
                            eqObject.put("logitype", (Object)"single");
                            eqObject.put("left_value_type", (Object)leftValueType);
                            items.add((Object)eqObject);
                        }
                    }
                });
                condition.put("items", (Object)items);
            }
            return condition;
        }
        return null;
    }
}

