/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.search;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.common.exception.ChatBiException;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.search.dto.RequestDto;
import com.digiwin.chatbi.reasoning.search.facade.EsQueryFacade;
import com.digiwin.chatbi.reasoning.search.template.DslFormatEngine;
import com.digiwin.chatbi.service.ApolloService;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EsQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(EsQueryExecutor.class);
    @Resource
    private DslFormatEngine dslFormatEngine;
    @Resource
    private EsQueryFacade esQueryFacade;
    private static final String SPECIAL_CHARACTERS = "[\"\\\\]";

    public JSONObject queryById(String indexName, String id) {
        return this.performAction(arg_0 -> ((EsQueryFacade)this.esQueryFacade).queryById(arg_0), RequestDto.builder().indexName(indexName).id(id).build());
    }

    public JSONObject countByParam(String indexName, String dsl) {
        return this.performAction(arg_0 -> ((EsQueryFacade)this.esQueryFacade).countByParam(arg_0), RequestDto.builder().indexName(indexName).param(dsl).build());
    }

    public JSONObject queryByParam(String indexName, String dsl, String queryString) {
        return this.performAction(arg_0 -> ((EsQueryFacade)this.esQueryFacade).queryByParam(arg_0), RequestDto.builder().indexName(indexName).param(dsl).queryString(queryString).build());
    }

    public JSONObject queryByDslTemplate(String indexName, String templateCode, Map<String, Object> body) {
        return this.queryByDslTemplate(indexName, templateCode, body, null);
    }

    public String escapeQueryString(String query) {
        if (query == null) {
            return null;
        }
        return query.replaceAll(SPECIAL_CHARACTERS, "\\\\$0").replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t").replaceAll("\r", "\\\\r");
    }

    public JSONObject queryByDslTemplate(String indexName, String templateCode, Map<String, Object> body, String param) {
        ApolloService bean = (ApolloService)SpringContextUtil.getBean(ApolloService.class);
        String switchValue = bean.getQuestionQuotationMarksSwitch();
        log.info("switchValue is {}", (Object)switchValue);
        if ("1".equals(switchValue)) {
            HashMap<String, Object> newBody = new HashMap<String, Object>(body);
            if (!newBody.isEmpty()) {
                for (Map.Entry entry : newBody.entrySet()) {
                    Object value = entry.getValue();
                    if (!(value instanceof String) || "dimension_words".equals(entry.getKey())) continue;
                    String strValue = (String)value;
                    strValue = this.escapeQueryString(strValue);
                    entry.setValue(strValue);
                }
            }
            RequestDto request = RequestDto.builder().indexName(indexName).queryString(param).param(this.dslFormatEngine.transform2String(templateCode, newBody)).build();
            return this.performAction(arg_0 -> ((EsQueryFacade)this.esQueryFacade).queryByParam(arg_0), request);
        }
        RequestDto request = RequestDto.builder().indexName(indexName).queryString(param).param(this.dslFormatEngine.transform2String(templateCode, body)).build();
        return this.performAction(arg_0 -> ((EsQueryFacade)this.esQueryFacade).queryByParam(arg_0), request);
    }

    public JSONObject queryBySqlTemplate(String indexName, String templateCode, Map<String, Object> body) {
        return this.performAction(arg_0 -> ((EsQueryFacade)this.esQueryFacade).searchByParam(arg_0), RequestDto.builder().indexName(indexName).param(this.dslFormatEngine.transform2String(templateCode, body)).build());
    }

    private JSONObject performAction(Function<RequestDto, JSONObject> action, RequestDto param) {
        try {
            return action.apply(param);
        }
        catch (ChatBiException e) {
            log.error(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error(e.toString());
            throw e;
        }
    }
}

