/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.search.client;

import com.digiwin.chatbi.common.exception.SrhExceptionAssert;
import com.digiwin.chatbi.reasoning.search.client.EsClient;
import com.digiwin.chatbi.reasoning.search.config.EsHostConfig;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EsHttpClient
implements EsClient {
    private static final Logger log = LoggerFactory.getLogger(EsHttpClient.class);
    @Autowired
    private EsHostConfig esHostConfig;
    private final MediaType JSON_TYPE = MediaType.parse((String)"application/json");
    private final OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).retryOnConnectionFailure(true).connectTimeout(30L, TimeUnit.SECONDS).build();

    public String doGet(String url) {
        Request request = new Request.Builder().url(this.getServer() + url).get().build();
        return this.doRequest(request);
    }

    public String doDelete(String url) {
        Request request = new Request.Builder().url(this.getServer() + url).delete().build();
        return this.doRequest(request);
    }

    public String doPost(String url, String param) {
        Request request = new Request.Builder().url(this.getServer() + url).post(RequestBody.create((MediaType)this.JSON_TYPE, (String)param)).build();
        return this.doRequest(request);
    }

    public String doPut(String url, String param) {
        Request request = new Request.Builder().url(this.getServer() + url).put(RequestBody.create((MediaType)this.JSON_TYPE, (String)param)).build();
        return this.doRequest(request);
    }

    public String getServer() {
        return MessageFormat.format("{0}://{1}:{2}", this.esHostConfig.getEsScheme(), this.esHostConfig.getEsHost(), this.esHostConfig.getEsPort() + "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doRequest(Request request) {
        try (Response response = this.client.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
        catch (IOException e) {
            throw SrhExceptionAssert.ES_CONNECT_FALI.newException(new Object[]{e.getMessage()});
        }
    }
}

