/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.search.template;

import com.digiwin.chatbi.common.exception.PromptAssert;
import com.digiwin.chatbi.common.util.TemplateBroker;
import com.digiwin.chatbi.reasoning.prompt.Prompt;
import freemarker.cache.TemplateLoader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class DslTemplateLoader
implements TemplateLoader,
TemplateBroker {
    @PostConstruct
    public void loadPrompts() {
        Resource[] resources = (Resource[])PromptAssert.PROMPT_LOAD_FILE_FAILED_ASSERT.tryCatch(() -> new PathMatchingResourcePatternResolver().getResources("classpath:dsl/**/*.dsl"), new Object[0]);
        this.put(Arrays.stream(resources).map(resource -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                String[] split = resource.getURI().toString().replace("/", "&&").replace("\\", "&&").split("&&");
                String type = split[split.length - 2];
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                }
                Prompt prompt = Prompt.New((String)Objects.requireNonNull(resource.getFilename()).replace(".dsl", ""), (String)type, (String)content.toString());
                return prompt;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get file from resource: " + resource, e);
            }
        }).collect(Collectors.toList()));
    }

    public Object findTemplateSource(String templateName) throws IOException {
        int lastUnderscore = templateName.lastIndexOf(95);
        if (lastUnderscore != -1) {
            templateName = templateName.substring(0, lastUnderscore);
        }
        return this.get("dsl", templateName);
    }

    public long getLastModified(Object templateSource) {
        return 0L;
    }

    public Reader getReader(Object prompt, String encoding) throws IOException {
        InputStream inputStream = this.getInputStream((Prompt)prompt);
        return new InputStreamReader(inputStream, encoding);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }

    private InputStream getInputStream(Prompt prompt) {
        return new ByteArrayInputStream(prompt.getTemplate().getBytes());
    }
}

