/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.async.OperateESAsync;
import com.digiwin.chatbi.beans.dtos.chart.AiDataSetPushDto;
import com.digiwin.chatbi.beans.dtos.chart.Data;
import com.digiwin.chatbi.beans.dtos.chart.DataInfo;
import com.digiwin.chatbi.beans.dtos.chart.DataSetDto;
import com.digiwin.chatbi.beans.dtos.chart.DataSetPushDto;
import com.digiwin.chatbi.beans.dtos.chart.Dataset;
import com.digiwin.chatbi.beans.dtos.chart.DatasetLang;
import com.digiwin.chatbi.beans.dtos.chart.FieldSchema;
import com.digiwin.chatbi.beans.dtos.chart.FieldSchemaDto;
import com.digiwin.chatbi.beans.dtos.chart.FieldSchemaLang;
import com.digiwin.chatbi.beans.dtos.chart.HabitualKnowledgeDto;
import com.digiwin.chatbi.beans.dtos.chart.LangDto;
import com.digiwin.chatbi.beans.dtos.chart.NounKnowledgeDto;
import com.digiwin.chatbi.beans.pojos.AppStandardWordII;
import com.digiwin.chatbi.beans.pojos.KMData;
import com.digiwin.chatbi.beans.pojos.ReportDto;
import com.digiwin.chatbi.beans.pojos.StandardWordData;
import com.digiwin.chatbi.beans.pojos.StandardWordDataII;
import com.digiwin.chatbi.beans.pojos.vector.DictioneryWord;
import com.digiwin.chatbi.common.AthenaDeployerServiceInvoker;
import com.digiwin.chatbi.common.DmlServiceInvoker;
import com.digiwin.chatbi.common.IamServiceInvoker;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.reasoning.search.EsQueryExecutor;
import com.digiwin.chatbi.reasoning.search.config.GroundModelConfig;
import com.digiwin.chatbi.reasoning.search.dto.BulkDto;
import com.digiwin.chatbi.reasoning.search.util.DslUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OperateESService {
    private static final Logger log = LoggerFactory.getLogger(OperateESService.class);
    @Autowired
    private OperateESAsync operateESAsync;
    @Autowired
    private DmlServiceInvoker dmlServiceInvoker;
    @Resource
    private EsQueryExecutor esQueryExecutor;
    @Autowired
    private AthenaDeployerServiceInvoker athenaDeployerServiceInvoker;
    @Autowired
    private IamServiceInvoker iamServiceInvoker;
    @Autowired
    private GroundModelConfig groundModelConfig;
    @Value(value="${scrumbi.matchtable.switch:false}")
    private String scrumbiMatchtableSwitch;
    public static final String TEMPLATE_CODE = "templateCode";
    public static final String DATASOURCE_ID = "datasourceId";
    public static final String APPLICATIONCODE = "applicationCode";
    public static final String VERSION = "version";
    public static final String SCENECODE = "sceneCode";
    public static final String NAME = "name";
    public static final String SCHEMA = "schemas";
    public static final String CONNECTOR_SYMBOL = "    ";
    public static final String SENTENCES_CONNECTOR_SYMBOL = "|";
    public static final Integer MAX_COUNT = 5;

    public JSONObject pushKMDatas(List<KMData> kmDatas) {
        if (CollectionUtils.isEmpty(kmDatas)) {
            log.info("\u63a8\u9001\u6570\u636e\u4e3a\u7a7a");
            return new JSONObject();
        }
        log.info("km\u5f00\u59cb\u63a8\u9001\u6570\u636e:{}", (Object)JSON.toJSONString(kmDatas));
        ArrayList list = new ArrayList();
        for (KMData kmData : kmDatas) {
            if (!StringUtils.isNotEmpty((CharSequence)kmData.getApplicationCode()) || !StringUtils.isNotEmpty((CharSequence)kmData.getVersion())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(APPLICATIONCODE, kmData.getApplicationCode());
            map.put(VERSION, kmData.getVersion());
            list.add(map);
        }
        Retrieve.TEMPLATE.deleteByConditionList(list);
        Retrieve.TARGET.deleteByConditionList(list);
        Retrieve.DIMENSION.deleteByConditionList(list);
        Retrieve.SCENE.deleteByConditionListWithOutKeyWord(list);
        for (KMData kmData : kmDatas) {
            String applicationCode = StringUtils.isEmpty((CharSequence)kmData.getApplicationCode()) ? "" : kmData.getApplicationCode();
            String version = StringUtils.isEmpty((CharSequence)kmData.getVersion()) ? "" : kmData.getVersion();
            this.commonBulkInsert(kmData.getTemplate(), applicationCode, version, TEMPLATE_CODE, Retrieve.TEMPLATE);
            this.commonBulkInsert(kmData.getDatasource(), applicationCode, version, DATASOURCE_ID, Retrieve.TARGET);
            this.commonBulkInsert(kmData.getDimensions(), applicationCode, version, NAME, Retrieve.DIMENSION);
            this.commonBulkInsert(kmData.getScenes(), applicationCode, version, SCENECODE, Retrieve.SCENE);
        }
        log.info("km\u7ed3\u675f\u63a8\u9001\u6570\u636e");
        return new JSONObject();
    }

    private void commonBulkInsert(List<JSONObject> commonJsonObjects, String applicationCode, String version, String key, Retrieve retrieve) {
        if (CollectionUtil.isNotEmpty(commonJsonObjects)) {
            List bulkDtos = commonJsonObjects.stream().map(json -> {
                json.put(APPLICATIONCODE, (Object)applicationCode);
                json.put(VERSION, (Object)version);
                BulkDto bulkDto = new BulkDto();
                bulkDto.setId(version + "_" + applicationCode + "_" + json.getString(key));
                bulkDto.setSource(json);
                return bulkDto;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            this.bulkInsert(retrieve, bulkDtos);
        }
    }

    public void pushKMDatasV2(List<KMData> kmDatasV2) {
        if (CollectionUtils.isEmpty(kmDatasV2)) {
            log.info("\u63a8\u9001\u6570\u636eV2\u4e3a\u7a7a");
            return;
        }
        log.info("km\u5f00\u59cb\u63a8\u9001\u6570\u636eV2:{}", (Object)JSON.toJSONString(kmDatasV2));
        for (KMData kmDataV2 : kmDatasV2) {
            if (!CollectionUtils.isNotEmpty((Collection)kmDataV2.getScenes())) continue;
            for (JSONObject scene2 : kmDataV2.getScenes()) {
                scene2.put("applicationName", (Object)kmDataV2.getApplicationName());
            }
            JSONObject param = new JSONObject();
            param.put("applicationCodes", Arrays.asList(kmDataV2.getApplicationCode()));
            param.put(VERSION, (Object)kmDataV2.getVersion());
            HashMap allSchemasInApp = ((List)Optional.ofNullable(Retrieve.DICTIONARY.retrieve(param)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList())).stream().collect(HashMap::new, (map, json) -> map.put(json.getString(NAME), json.getString("title")), HashMap::putAll);
            ArrayList datasources = new ArrayList();
            kmDataV2.getScenes().stream().collect(Collectors.groupingBy(scene -> scene.getString("targetId"))).entrySet().stream().forEach(entry -> {
                List scenes = (List)entry.getValue();
                JSONObject datasource = new JSONObject();
                datasource.put(DATASOURCE_ID, entry.getKey());
                datasource.put("datasourceName", (Object)((JSONObject)scenes.get(0)).getString("targetName"));
                HashSet schemaNames = new HashSet();
                datasource.put(SCHEMA, (Object)scenes.stream().flatMap(scene -> scene.getJSONArray(SCHEMA).stream()).map(obj -> {
                    JSONObject o = (JSONObject)JSON.toJSON((Object)obj);
                    String name = (String)allSchemasInApp.get(o.getString(NAME));
                    if (StringUtils.isNotEmpty((CharSequence)name)) {
                        o.put("title", (Object)name);
                    }
                    return o;
                }).filter(schema -> schemaNames.add(schema.getString(NAME))).collect(Collectors.toCollection(JSONArray::new)));
                ArrayList intentions = new ArrayList();
                scenes.forEach(s -> {
                    intentions.addAll(Optional.ofNullable(s.getJSONArray("intentions")).orElse(new JSONArray()).toJavaList(String.class));
                    JSONArray dimensionKeys = s.getJSONArray("dimensionKeys");
                    if (CollectionUtils.isNotEmpty((Collection)dimensionKeys)) {
                        ArrayList<JSONObject> dimensions = new ArrayList<JSONObject>();
                        for (Object dimensionKey : dimensionKeys) {
                            if (CollectionUtils.isNotEmpty((Collection)kmDataV2.getDimensions())) {
                                for (JSONObject dimension : kmDataV2.getDimensions()) {
                                    if (!dimensionKey.toString().equals(dimension.getString(NAME))) continue;
                                    dimensions.add(dimension);
                                }
                                continue;
                            }
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put(NAME, dimensionKey);
                            dimensions.add(jsonObject);
                        }
                        s.put("dimensions", dimensions);
                    }
                });
                datasource.put("intentions", intentions.stream().distinct().collect(Collectors.toList()));
                datasource.put("appCode", (Object)kmDataV2.getApplicationCode());
                datasource.put(VERSION, (Object)kmDataV2.getVersion());
                datasources.add(datasource);
            });
            kmDataV2.setDatasource(datasources);
        }
        this.pushKMDatas(kmDatasV2);
    }

    JSONObject operateESIndex(Retrieve indexEnum, String prefix, String idSource, JSONObject tempJson) {
        if (!tempJson.containsKey((Object)idSource)) {
            return null;
        }
        return indexEnum.index(tempObj -> prefix + tempObj.getString(idSource), tempJson);
    }

    JSONObject operateESDocIndex(Retrieve indexEnum, JSONObject tempJson) {
        return indexEnum.indexDoc(tempJson);
    }

    JSONObject upsertESDocIndex(Retrieve indexEnum, JSONObject tempJson, String id) {
        return indexEnum.insertByIdDoc(tempJson, id);
    }

    public JSONObject pushStandardWordData(StandardWordData swData) {
        if (CollectionUtil.isNotEmpty((Collection)swData.getStandardWordDatas())) {
            swData.getStandardWordDatas().stream().map(JSON::toJSON).map(tempJSON -> this.operateESDocIndex(Retrieve.ENTITY, (JSONObject)tempJSON)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return new JSONObject();
    }

    public JSONObject pushStandardWordDataII(StandardWordDataII standardWordDataII, String token, boolean isSync) {
        if (isSync) {
            this.operateESAsync.pushStandardWordDataIISync(standardWordDataII, token);
        } else {
            this.operateESAsync.pushStandardWordDataIIAsync(standardWordDataII, token);
        }
        return new JSONObject();
    }

    public void pushAppStandardWord(List<AppStandardWordII> appStandardWordIIS) {
        if (CollectionUtils.isEmpty(appStandardWordIIS)) {
            log.info("\u5e94\u7528\u7ea7\u6807\u51c6\u8bcd\u63a8\u9001\u4e3a\u7a7a");
        }
        String application_code = appStandardWordIIS.get(0).getApplication_code();
        String version = appStandardWordIIS.get(0).getVersion();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("application_code", application_code);
        map.put(VERSION, version);
        Retrieve.APP_WORDS.deleteByCondition(map, Boolean.valueOf(true));
        List bulkDtos = appStandardWordIIS.stream().map(in -> {
            BulkDto bulkDto = new BulkDto();
            bulkDto.setId(in.getId());
            bulkDto.setSource((JSONObject)JSONObject.toJSON((Object)in));
            return bulkDto;
        }).collect(Collectors.toList());
        this.bulkInsert(Retrieve.APP_WORDS, bulkDtos);
    }

    JSONObject bulkInsert(Retrieve indexEnum, List<BulkDto> param) {
        return indexEnum.bulkInsert(param);
    }

    public void pushDictionary(List<DictioneryWord> dictioneryWords) {
        if (CollectionUtils.isEmpty(dictioneryWords)) {
            log.info("\u5b57\u5178\u63a8\u9001\u4e3a\u7a7a");
        }
        ArrayList list = new ArrayList();
        for (DictioneryWord dictioneryWord : dictioneryWords) {
            if (!StringUtils.isNotEmpty((CharSequence)dictioneryWord.getApplicationCode()) || !StringUtils.isNotEmpty((CharSequence)dictioneryWord.getVersion())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(APPLICATIONCODE, dictioneryWord.getApplicationCode());
            map.put(VERSION, dictioneryWord.getVersion());
            list.add(map);
        }
        Retrieve.DICTIONARY.deleteByConditionList(list);
        List bulkDtos = dictioneryWords.stream().map(in -> {
            BulkDto bulkDto = new BulkDto();
            bulkDto.setId(in.getApplicationCode() + "_" + in.getVersion() + "_" + in.getName());
            bulkDto.setSource((JSONObject)JSONObject.toJSON((Object)in));
            return bulkDto;
        }).collect(Collectors.toList());
        this.bulkInsert(Retrieve.DICTIONARY, bulkDtos);
    }

    public void pushReport(ReportDto reportDto) {
        if (Objects.isNull(reportDto) || Objects.isNull(reportDto.getReport())) {
            log.info("\u62a5\u8868\u63a8\u9001\u4e3a\u7a7a");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantId", reportDto.getTenantId());
        map.put("userId", reportDto.getUserId());
        Retrieve.REPORT.deleteByCondition(map, Boolean.valueOf(false));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tenantId", (Object)reportDto.getTenantId());
        jsonObject.put("userId", (Object)reportDto.getUserId());
        jsonObject.put("report", (Object)reportDto.getReport());
        Retrieve.REPORT.insertByIdDoc(jsonObject, reportDto.getTenantId() + reportDto.getUserId());
    }

    public void pushIndicatorDataAndDataSetV1(JSONObject pushData, String token, String locale) throws BussinessException {
        if (Objects.isNull(pushData)) {
            log.info("\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        JSONArray metricArray = pushData.getJSONArray("metric");
        JSONArray dataSetArray = pushData.getJSONArray("table");
        List indicatorList = metricArray.toJavaList(JSONObject.class);
        List dataSetV1List = dataSetArray.toJavaList(JSONObject.class);
        if (CollectionUtils.isEmpty((Collection)indicatorList) && CollectionUtils.isEmpty((Collection)dataSetV1List)) {
            log.info("\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)dataSetV1List)) {
            for (JSONObject jsonObject : dataSetV1List) {
                if (StringUtils.isEmpty((CharSequence)jsonObject.getString("datasetId"))) {
                    jsonObject.put("datasetId", (Object)jsonObject.getString("metricId"));
                    jsonObject.put("datasetName", (Object)jsonObject.getString("metricName"));
                }
                jsonObject.remove((Object)"metricName");
                jsonObject.remove((Object)"metricId");
            }
        }
        this.pushIndicatorDataOrDataSetV1(indicatorList, "metricId", Retrieve.METRIC);
        this.pushIndicatorDataOrDataSetV1(dataSetV1List, "datasetId", Retrieve.DATASET_V1);
        if (CollectionUtils.isEmpty((Collection)dataSetV1List)) {
            return;
        }
        if ("true".equals(this.scrumbiMatchtableSwitch)) {
            this.pushAiDataSetV1(dataSetV1List, token, locale);
        }
    }

    public void pushIndicatorDataOrDataSetV1(List<JSONObject> list, String key, Retrieve retrieve) {
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList delList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                String applicationCode = list.get(i).getString(APPLICATIONCODE);
                String version = list.get(i).getString(VERSION);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(APPLICATIONCODE, applicationCode);
                map.put(VERSION, version);
                delList.add(map);
            }
            retrieve.deleteByConditionListWithOutKeyWord(delList);
            List bulkDtos = list.stream().filter(indicator -> StringUtils.isNotEmpty((CharSequence)indicator.getString(key))).map(in -> {
                BulkDto bulkDto = new BulkDto();
                String id = in.getString(key) + "_" + in.getString(VERSION);
                if (CollectionUtils.isNotEmpty((Collection)in.getJSONArray("fieldSchema"))) {
                    for (Object o : in.getJSONArray("fieldSchema")) {
                        if (!Objects.nonNull(o) || !Objects.nonNull(((HashMap)o).get("businessType"))) continue;
                        HashMap bussinessType = (HashMap)((HashMap)o).get("businessType");
                        ((HashMap)o).put("businessType", bussinessType.get("code"));
                    }
                }
                bulkDto.setId(id);
                bulkDto.setSource((JSONObject)JSONObject.toJSON((Object)in));
                return bulkDto;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(bulkDtos)) {
                this.bulkInsert(retrieve, bulkDtos);
            }
        }
    }

    public void pushDataSet(List<DataSetPushDto> list, String token, String locale, String routerKey) throws BussinessException {
        if (CollectionUtils.isNotEmpty(list)) {
            try {
                this.pushScrumbiDataSet(list);
            }
            catch (Exception e) {
                throw new BussinessException("\u540c\u6b65\u8bed\u4e49\u6570\u636e\u96c6\u5f02\u5e38,{}", (Throwable)e);
            }
            if ("true".equals(this.scrumbiMatchtableSwitch)) {
                try {
                    this.pushAiDataSet(list, token, locale);
                }
                catch (Exception e) {
                    throw new BussinessException("\u540c\u6b65AI\u4e2d\u53f0\u6570\u636e\u96c6\u5f02\u5e38,{}", (Throwable)e);
                }
            }
        }
    }

    private Map<String, Map<String, Set<String>>> getTenantIdModelFieldCodesMap(List<DataSetPushDto> list, String token, String routerKey) {
        HashMap<String, Map<String, Set<String>>> tenantIdModelFieldCodesMap = new HashMap<String, Map<String, Set<String>>>();
        for (DataSetPushDto dataSetPushDto : list) {
            List tenantIds;
            if (CollectionUtils.isEmpty((Collection)dataSetPushDto.getDataSetDto()) || CollectionUtils.isEmpty((Collection)(tenantIds = this.athenaDeployerServiceInvoker.getAppRelatenantVersion(token, routerKey, dataSetPushDto.getApplicationCode())))) continue;
            Map modelFieldCodes = this.getModelFieldCodesMap(dataSetPushDto);
            this.buildTenantIdModelFieldCodesMap(tenantIdModelFieldCodesMap, tenantIds, modelFieldCodes);
        }
        return tenantIdModelFieldCodesMap;
    }

    public void buildTenantIdModelFieldCodesMap(Map<String, Map<String, Set<String>>> tenantIdModelFieldCodesMap, List<String> tenantIds, Map<String, Set<String>> modelFieldCodes) {
        for (String tenantId : tenantIds) {
            if (Objects.isNull(tenantIdModelFieldCodesMap.get(tenantId))) {
                tenantIdModelFieldCodesMap.put(tenantId, modelFieldCodes);
                continue;
            }
            for (Map.Entry<String, Set<String>> entry : modelFieldCodes.entrySet()) {
                String modelCode = entry.getKey();
                Set<String> fieldCodes = entry.getValue();
                if (CollectionUtils.isEmpty((Collection)tenantIdModelFieldCodesMap.get(tenantId).get(modelCode))) {
                    tenantIdModelFieldCodesMap.get(tenantId).put(modelCode, fieldCodes);
                    continue;
                }
                Set<String> addFieldCodes = tenantIdModelFieldCodesMap.get(tenantId).get(modelCode);
                fieldCodes.addAll(addFieldCodes);
                tenantIdModelFieldCodesMap.get(tenantId).put(modelCode, fieldCodes);
            }
        }
    }

    public Map<String, Set<String>> getModelFieldCodesMap(DataSetPushDto dataSetPushDto) {
        Map<String, List<DataSetDto>> modelDatasetGroup = dataSetPushDto.getDataSetDto().stream().collect(Collectors.groupingBy(dataset -> dataset.getModelCode()));
        HashMap<String, Set<String>> modelFieldCodes = new HashMap<String, Set<String>>();
        for (Map.Entry<String, List<DataSetDto>> modelDataset : modelDatasetGroup.entrySet()) {
            String modeCode = modelDataset.getKey();
            HashSet<String> fieldCodes = new HashSet<String>();
            List<DataSetDto> dataSetDtos = modelDataset.getValue();
            for (DataSetDto dataSetDto : dataSetDtos) {
                for (Object o : dataSetDto.getFieldSchema()) {
                    fieldCodes.add(((JSONObject)o).getString(NAME));
                }
            }
            modelFieldCodes.put(modeCode, fieldCodes);
        }
        return modelFieldCodes;
    }

    private void pushAiDataSetV1(List<JSONObject> list, String token, String locale) throws BussinessException {
        AiDataSetPushDto aiDataSetPushDto = new AiDataSetPushDto();
        Data data = new Data();
        ArrayList<DataInfo> dataInfos = new ArrayList<DataInfo>();
        DataInfo dataInfo = new DataInfo();
        dataInfo.setApplicationCode(list.get(0).getString(APPLICATIONCODE));
        dataInfo.setApplicationName(list.get(0).getString("applicationName"));
        dataInfo.setVersion(list.get(0).getString(VERSION));
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        for (JSONObject dataSetDto : list) {
            LangDto name;
            DatasetLang lang;
            Dataset dataset = new Dataset();
            dataset.setDatasetId(dataSetDto.getString("datasetId"));
            dataset.setDatasetDesc(StringUtils.isNotEmpty((CharSequence)dataSetDto.getString("description")) ? dataSetDto.getString("description") : "");
            dataset.setDatasetName(dataSetDto.getString("datasetName"));
            ArrayList<FieldSchema> fieldSchemas = new ArrayList<FieldSchema>();
            if (CollectionUtils.isNotEmpty((Collection)dataSetDto.getJSONArray("fieldSchema"))) {
                for (Object o : dataSetDto.getJSONArray("fieldSchema")) {
                    LangDto name2;
                    FieldSchemaLang lang2;
                    JSONObject field = JSON.parseObject((String)JSON.toJSONString(o));
                    FieldSchema fieldSchema = new FieldSchema();
                    fieldSchema.setFieldName(field.getString(NAME));
                    fieldSchema.setFieldTitle(field.getString("title"));
                    fieldSchema.setFieldDesc(StringUtils.isNotEmpty((CharSequence)field.getString("description")) ? field.getString("description") : "");
                    fieldSchema.setFieldType(field.getString("dataType"));
                    if (Objects.nonNull(field.getJSONObject("lang"))) {
                        LangDto desc;
                        lang2 = new FieldSchemaLang();
                        if (Objects.nonNull(field.getJSONObject("lang").getJSONObject("title"))) {
                            name2 = new LangDto();
                            name2.setZh_CN(StringUtils.isNotEmpty((CharSequence)field.getJSONObject("lang").getJSONObject("title").getString("zh_CN")) ? field.getJSONObject("lang").getJSONObject("title").getString("zh_CN") : "");
                            name2.setZh_TW(StringUtils.isNotEmpty((CharSequence)field.getJSONObject("lang").getJSONObject("title").getString("zh_TW")) ? field.getJSONObject("lang").getJSONObject("title").getString("zh_TW") : "");
                            name2.setEn_US(StringUtils.isNotEmpty((CharSequence)field.getJSONObject("lang").getJSONObject("title").getString("en_US")) ? field.getJSONObject("lang").getJSONObject("title").getString("en_US") : "");
                            lang2.setName(name2);
                        } else {
                            name2 = new LangDto();
                            lang2.setName(name2);
                        }
                        if (Objects.nonNull(field.getJSONObject("lang").getJSONObject("description"))) {
                            desc = new LangDto();
                            desc.setZh_CN(StringUtils.isNotEmpty((CharSequence)field.getJSONObject("lang").getJSONObject("description").getString("zh_CN")) ? field.getJSONObject("lang").getJSONObject("description").getString("zh_CN") : "");
                            desc.setZh_TW(StringUtils.isNotEmpty((CharSequence)field.getJSONObject("lang").getJSONObject("description").getString("zh_TW")) ? field.getJSONObject("lang").getJSONObject("description").getString("zh_TW") : "");
                            desc.setEn_US(StringUtils.isNotEmpty((CharSequence)field.getJSONObject("lang").getJSONObject("description").getString("en_US")) ? field.getJSONObject("lang").getJSONObject("description").getString("en_US") : "");
                            lang2.setDesc(desc);
                        } else {
                            desc = new LangDto();
                            lang2.setDesc(desc);
                        }
                        fieldSchema.setLang(lang2);
                    } else {
                        lang2 = new FieldSchemaLang();
                        name2 = new LangDto();
                        LangDto desc = new LangDto();
                        lang2.setDesc(desc);
                        lang2.setName(name2);
                        fieldSchema.setLang(lang2);
                    }
                    fieldSchemas.add(fieldSchema);
                }
            }
            dataset.setFieldSchema(fieldSchemas);
            if (Objects.nonNull(dataSetDto.getJSONObject("lang"))) {
                LangDto desc;
                lang = new DatasetLang();
                if (Objects.nonNull(dataSetDto.getJSONObject("lang").getJSONObject(NAME))) {
                    name = new LangDto();
                    name.setZh_CN(StringUtils.isNotEmpty((CharSequence)dataSetDto.getJSONObject("lang").getJSONObject("sentenceTitle").getString("zh_CN")) ? dataSetDto.getJSONObject("lang").getJSONObject("sentenceTitle").getString("zh_CN") : "");
                    name.setZh_TW(StringUtils.isNotEmpty((CharSequence)dataSetDto.getJSONObject("lang").getJSONObject("sentenceTitle").getString("zh_TW")) ? dataSetDto.getJSONObject("lang").getJSONObject("sentenceTitle").getString("zh_TW") : "");
                    name.setEn_US(StringUtils.isNotEmpty((CharSequence)dataSetDto.getJSONObject("lang").getJSONObject("sentenceTitle").getString("en_US")) ? dataSetDto.getJSONObject("lang").getJSONObject("sentenceTitle").getString("en_US") : "");
                    lang.setName(name);
                } else {
                    name = new LangDto();
                    lang.setName(name);
                }
                if (Objects.nonNull(dataSetDto.getJSONObject("lang").getJSONObject("description"))) {
                    desc = new LangDto();
                    desc.setZh_CN(StringUtils.isNotEmpty((CharSequence)dataSetDto.getJSONObject("lang").getJSONObject("description").getString("zh_CN")) ? dataSetDto.getJSONObject("lang").getJSONObject("description").getString("zh_CN") : "");
                    desc.setZh_TW(StringUtils.isNotEmpty((CharSequence)dataSetDto.getJSONObject("lang").getJSONObject("description").getString("zh_TW")) ? dataSetDto.getJSONObject("lang").getJSONObject("description").getString("zh_TW") : "");
                    desc.setEn_US(StringUtils.isNotEmpty((CharSequence)dataSetDto.getJSONObject("lang").getJSONObject("description").getString("en_US")) ? dataSetDto.getJSONObject("lang").getJSONObject("description").getString("en_US") : "");
                    lang.setDesc(desc);
                } else {
                    desc = new LangDto();
                    lang.setDesc(desc);
                }
                dataset.setLang(lang);
            } else {
                lang = new DatasetLang();
                name = new LangDto();
                LangDto desc = new LangDto();
                lang.setDesc(desc);
                lang.setName(name);
                dataset.setLang(lang);
            }
            datasets.add(dataset);
        }
        dataInfo.setDataset(datasets);
        dataInfos.add(dataInfo);
        data.setDataInfo(dataInfos);
        aiDataSetPushDto.setData(data);
        aiDataSetPushDto.setDataSource("scrumbi");
        this.dmlServiceInvoker.saveDatasetSchema(aiDataSetPushDto, token, locale);
    }

    private void pushAiDataSet(List<DataSetPushDto> list, String token, String locale) throws BussinessException {
        AiDataSetPushDto aiDataSetPushDto = new AiDataSetPushDto();
        Data data = new Data();
        ArrayList<DataInfo> dataInfos = new ArrayList<DataInfo>();
        for (DataSetPushDto dataSetPushDto : list) {
            DataInfo dataInfo = new DataInfo();
            dataInfo.setApplicationCode(dataSetPushDto.getApplicationCode());
            dataInfo.setApplicationName(dataSetPushDto.getApplicationName());
            dataInfo.setVersion(dataSetPushDto.getVersion());
            ArrayList<Dataset> datasets = new ArrayList<Dataset>();
            if (CollectionUtils.isEmpty((Collection)dataSetPushDto.getDataSetDto())) {
                dataInfo.setDataset(datasets);
                dataInfos.add(dataInfo);
                data.setDataInfo(dataInfos);
                continue;
            }
            for (DataSetDto dataSetDto : dataSetPushDto.getDataSetDto()) {
                LangDto name;
                DatasetLang lang;
                LangDto desc;
                LangDto desc2;
                LangDto name2;
                FieldSchemaLang lang2;
                FieldSchema fieldSchema;
                Dataset dataset = new Dataset();
                dataset.setDatasetId(dataSetDto.getDatasetId());
                dataset.setDatasetDesc(StringUtils.isNotEmpty((CharSequence)dataSetDto.getDescription()) ? dataSetDto.getDescription() : "");
                dataset.setDatasetName(dataSetDto.getDatasetName());
                ArrayList<FieldSchema> fieldSchemas = new ArrayList<FieldSchema>();
                if (CollectionUtils.isNotEmpty((Collection)dataSetDto.getMeasures())) {
                    for (FieldSchemaDto measure : dataSetDto.getMeasures()) {
                        fieldSchema = new FieldSchema();
                        fieldSchema.setFieldName(measure.getName());
                        fieldSchema.setFieldTitle(measure.getData_name());
                        fieldSchema.setFieldDesc(StringUtils.isNotEmpty((CharSequence)measure.getDescription()) ? measure.getDescription() : "");
                        fieldSchema.setFieldType(measure.getData_type());
                        if (Objects.nonNull(measure.getLang())) {
                            lang2 = new FieldSchemaLang();
                            if (Objects.nonNull(measure.getLang().getName())) {
                                name2 = new LangDto();
                                name2.setZh_CN(StringUtils.isNotEmpty((CharSequence)measure.getLang().getName().getZh_CN()) ? measure.getLang().getName().getZh_CN() : "");
                                name2.setZh_TW(StringUtils.isNotEmpty((CharSequence)measure.getLang().getName().getZh_TW()) ? measure.getLang().getName().getZh_TW() : "");
                                name2.setEn_US(StringUtils.isNotEmpty((CharSequence)measure.getLang().getName().getEn_US()) ? measure.getLang().getName().getEn_US() : "");
                                lang2.setName(name2);
                            } else {
                                name2 = new LangDto();
                                lang2.setName(name2);
                            }
                            if (Objects.nonNull(measure.getLang().getDescription())) {
                                desc2 = new LangDto();
                                desc2.setZh_CN(StringUtils.isNotEmpty((CharSequence)measure.getLang().getDescription().getZh_CN()) ? measure.getLang().getDescription().getZh_CN() : "");
                                desc2.setZh_TW(StringUtils.isNotEmpty((CharSequence)measure.getLang().getDescription().getZh_TW()) ? measure.getLang().getDescription().getZh_TW() : "");
                                desc2.setEn_US(StringUtils.isNotEmpty((CharSequence)measure.getLang().getDescription().getEn_US()) ? measure.getLang().getDescription().getEn_US() : "");
                                lang2.setDesc(desc2);
                            } else {
                                desc2 = new LangDto();
                                lang2.setDesc(desc2);
                            }
                            fieldSchema.setLang(lang2);
                        } else {
                            lang2 = new FieldSchemaLang();
                            name2 = new LangDto();
                            desc = new LangDto();
                            lang2.setDesc(desc);
                            lang2.setName(name2);
                            fieldSchema.setLang(lang2);
                        }
                        fieldSchemas.add(fieldSchema);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)dataSetDto.getDimensions())) {
                    for (FieldSchemaDto dimension : dataSetDto.getDimensions()) {
                        fieldSchema = new FieldSchema();
                        fieldSchema.setFieldName(dimension.getName());
                        fieldSchema.setFieldTitle(dimension.getData_name());
                        fieldSchema.setFieldDesc(StringUtils.isNotEmpty((CharSequence)dimension.getDescription()) ? dimension.getDescription() : "");
                        fieldSchema.setFieldType(dimension.getData_type());
                        if (Objects.nonNull(dimension.getLang())) {
                            lang2 = new FieldSchemaLang();
                            if (Objects.nonNull(dimension.getLang().getName())) {
                                name2 = new LangDto();
                                name2.setZh_CN(StringUtils.isNotEmpty((CharSequence)dimension.getLang().getName().getZh_CN()) ? dimension.getLang().getName().getZh_CN() : "");
                                name2.setZh_TW(StringUtils.isNotEmpty((CharSequence)dimension.getLang().getName().getZh_TW()) ? dimension.getLang().getName().getZh_TW() : "");
                                name2.setEn_US(StringUtils.isNotEmpty((CharSequence)dimension.getLang().getName().getEn_US()) ? dimension.getLang().getName().getEn_US() : "");
                                lang2.setName(name2);
                            } else {
                                name2 = new LangDto();
                                lang2.setName(name2);
                            }
                            if (Objects.nonNull(dimension.getLang().getDescription())) {
                                desc2 = new LangDto();
                                desc2.setZh_CN(StringUtils.isNotEmpty((CharSequence)dimension.getLang().getDescription().getZh_CN()) ? dimension.getLang().getDescription().getZh_CN() : "");
                                desc2.setZh_TW(StringUtils.isNotEmpty((CharSequence)dimension.getLang().getDescription().getZh_TW()) ? dimension.getLang().getDescription().getZh_TW() : "");
                                desc2.setEn_US(StringUtils.isNotEmpty((CharSequence)dimension.getLang().getDescription().getEn_US()) ? dimension.getLang().getDescription().getEn_US() : "");
                                lang2.setDesc(desc2);
                            } else {
                                desc2 = new LangDto();
                                lang2.setDesc(desc2);
                            }
                            fieldSchema.setLang(lang2);
                        } else {
                            lang2 = new FieldSchemaLang();
                            name2 = new LangDto();
                            desc = new LangDto();
                            lang2.setDesc(desc);
                            lang2.setName(name2);
                            fieldSchema.setLang(lang2);
                        }
                        fieldSchemas.add(fieldSchema);
                    }
                }
                dataset.setFieldSchema(fieldSchemas);
                if (Objects.nonNull(dataSetDto.getLang())) {
                    LangDto desc3;
                    lang = new DatasetLang();
                    if (Objects.nonNull(dataSetDto.getLang().getName())) {
                        name = new LangDto();
                        name.setZh_CN(StringUtils.isNotEmpty((CharSequence)dataSetDto.getLang().getName().getZh_CN()) ? dataSetDto.getLang().getName().getZh_CN() : "");
                        name.setZh_TW(StringUtils.isNotEmpty((CharSequence)dataSetDto.getLang().getName().getZh_TW()) ? dataSetDto.getLang().getName().getZh_TW() : "");
                        name.setEn_US(StringUtils.isNotEmpty((CharSequence)dataSetDto.getLang().getName().getEn_US()) ? dataSetDto.getLang().getName().getEn_US() : "");
                        lang.setName(name);
                    } else {
                        name = new LangDto();
                        lang.setName(name);
                    }
                    if (Objects.nonNull(dataSetDto.getLang().getDescription())) {
                        desc3 = new LangDto();
                        desc3.setZh_CN(StringUtils.isNotEmpty((CharSequence)dataSetDto.getLang().getDescription().getZh_CN()) ? dataSetDto.getLang().getDescription().getZh_CN() : "");
                        desc3.setZh_TW(StringUtils.isNotEmpty((CharSequence)dataSetDto.getLang().getDescription().getZh_TW()) ? dataSetDto.getLang().getDescription().getZh_TW() : "");
                        desc3.setEn_US(StringUtils.isNotEmpty((CharSequence)dataSetDto.getLang().getDescription().getEn_US()) ? dataSetDto.getLang().getDescription().getEn_US() : "");
                        lang.setDesc(desc3);
                    } else {
                        desc3 = new LangDto();
                        lang.setDesc(desc3);
                    }
                    dataset.setLang(lang);
                } else {
                    lang = new DatasetLang();
                    name = new LangDto();
                    LangDto desc4 = new LangDto();
                    lang.setDesc(desc4);
                    lang.setName(name);
                    dataset.setLang(lang);
                }
                datasets.add(dataset);
            }
            dataInfo.setDataset(datasets);
            dataInfos.add(dataInfo);
            data.setDataInfo(dataInfos);
        }
        aiDataSetPushDto.setData(data);
        aiDataSetPushDto.setDataSource("scrumbi");
        this.dmlServiceInvoker.saveDatasetSchema(aiDataSetPushDto, token, locale);
    }

    private void pushScrumbiDataSet(List<DataSetPushDto> dataSetPushDtos) throws BussinessException {
        ArrayList<Object> delList = new ArrayList<Object>();
        for (int i = 0; i < dataSetPushDtos.size(); ++i) {
            String applicationCode = dataSetPushDtos.get(i).getApplicationCode();
            String version = dataSetPushDtos.get(i).getVersion();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(APPLICATIONCODE, applicationCode);
            map.put(VERSION, version);
            delList.add(map);
        }
        Retrieve.DATASET_V2.deleteByConditionListWithOutKeyWord(delList);
        for (DataSetPushDto dataSetPushDto : dataSetPushDtos) {
            List list = dataSetPushDto.getDataSetDto();
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            for (DataSetDto dataSetDto : list) {
                dataSetDto.setApplicationCode(dataSetPushDto.getApplicationCode());
                dataSetDto.setApplicationName(dataSetPushDto.getApplicationName());
                dataSetDto.setVersion(dataSetPushDto.getVersion());
            }
            ArrayList<BulkDto> bulkDtos = new ArrayList<BulkDto>();
            for (DataSetDto in : list) {
                JSONObject fieldSchema;
                if (StringUtils.isEmpty((CharSequence)in.getDatasetId())) continue;
                BulkDto bulkDto = new BulkDto();
                String id = in.getDatasetId() + "_" + in.getVersion();
                JSONArray fieldSchemas = new JSONArray();
                if (CollectionUtils.isNotEmpty((Collection)in.getDimensions())) {
                    for (FieldSchemaDto dimension : in.getDimensions()) {
                        fieldSchema = new JSONObject();
                        this.dataSet2fieldSchema(dimension, fieldSchema);
                        fieldSchemas.add((Object)fieldSchema);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)in.getMeasures())) {
                    for (FieldSchemaDto measure : in.getMeasures()) {
                        fieldSchema = new JSONObject();
                        this.dataSet2fieldSchema(measure, fieldSchema);
                        fieldSchemas.add((Object)fieldSchema);
                    }
                }
                in.setFieldSchema(fieldSchemas);
                bulkDto.setId(id);
                bulkDto.setSource((JSONObject)JSONObject.toJSON((Object)in));
                bulkDtos.add(bulkDto);
            }
            if (!CollectionUtils.isNotEmpty(bulkDtos)) continue;
            this.bulkInsert(Retrieve.DATASET_V2, bulkDtos);
        }
    }

    private void dataSet2fieldSchema(FieldSchemaDto dimension, JSONObject fieldSchema) throws BussinessException {
        if (StringUtils.isEmpty((CharSequence)dimension.getMap_field())) {
            throw new BussinessException("\u8868\u540d__\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        fieldSchema.put(NAME, (Object)dimension.getData_name());
        fieldSchema.put("title", (Object)dimension.getName());
        fieldSchema.put("description", (Object)dimension.getDescription());
        fieldSchema.put("businessType", (Object)dimension.getBusinessType());
        if (Objects.nonNull(dimension.getLang())) {
            JSONObject lang = new JSONObject();
            if (Objects.nonNull(dimension.getLang().getName())) {
                JSONObject title = new JSONObject();
                title.put("zh_CN", (Object)dimension.getLang().getName().getZh_CN());
                title.put("zh_TW", (Object)dimension.getLang().getName().getZh_TW());
                title.put("en_US", (Object)dimension.getLang().getName().getEn_US());
                lang.put("title", (Object)title);
            }
            if (Objects.nonNull(dimension.getLang().getDescription())) {
                JSONObject description = new JSONObject();
                description.put("zh_CN", (Object)dimension.getLang().getDescription().getZh_CN());
                description.put("zh_TW", (Object)dimension.getLang().getDescription().getZh_TW());
                description.put("en_US", (Object)dimension.getLang().getDescription().getEn_US());
                lang.put("description", (Object)description);
            }
            fieldSchema.put("lang", (Object)lang);
        }
        fieldSchema.put("dataType", (Object)dimension.getData_type());
        fieldSchema.put("nullStyle", (Object)dimension.getNullStyle());
        fieldSchema.put("enums", (Object)dimension.getEnums());
        fieldSchema.put("needPullData", (Object)dimension.isNeedPullData());
    }

    public void pushNounKnowledge(List<NounKnowledgeDto> knowledges) {
        if (CollectionUtils.isEmpty(knowledges)) {
            log.info("\u5e94\u7528\u7ea7\u540d\u8bcd\u77e5\u8bc6\u63a8\u9001\u4e3a\u7a7a");
        }
        String application_code = knowledges.get(0).getApplicationCode();
        String version = knowledges.get(0).getVersion();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(APPLICATIONCODE, application_code);
        map.put(VERSION, version);
        Retrieve.NOUNKNOWLEDGE.deleteByCondition(map, Boolean.valueOf(true));
        List bulkDtos = knowledges.stream().map(in -> {
            BulkDto bulkDto = new BulkDto();
            String id = in.getId() + "_" + in.getVersion();
            bulkDto.setId(id);
            bulkDto.setSource((JSONObject)JSONObject.toJSON((Object)in));
            return bulkDto;
        }).collect(Collectors.toList());
        this.bulkInsert(Retrieve.NOUNKNOWLEDGE, bulkDtos);
    }

    public void pushHabitualKnowledge(List<HabitualKnowledgeDto> knowledges) {
        if (CollectionUtils.isEmpty(knowledges)) {
            log.info("\u5e94\u7528\u7ea7\u4e60\u60ef\u77e5\u8bc6\u63a8\u9001\u4e3a\u7a7a");
        }
        String application_code = knowledges.get(0).getApplicationCode();
        String version = knowledges.get(0).getVersion();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(APPLICATIONCODE, application_code);
        map.put(VERSION, version);
        Retrieve.HABITUALKNOWLEDGE.deleteByCondition(map, Boolean.valueOf(true));
        List bulkDtos = knowledges.stream().map(in -> {
            BulkDto bulkDto = new BulkDto();
            String id = in.getId() + "_" + in.getVersion();
            bulkDto.setId(id);
            bulkDto.setSource((JSONObject)JSONObject.toJSON((Object)in));
            return bulkDto;
        }).collect(Collectors.toList());
        this.bulkInsert(Retrieve.HABITUALKNOWLEDGE, bulkDtos);
    }

    public List<JSONObject> fewShotFormatSearch(JSONObject param) {
        JSONObject jsonObject = this.esQueryExecutor.queryByParam("scrumbi_metric_fewshot", DslUtil.JsonToString((JSONObject)param), null);
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        JSONArray jsonArray = jsonObject.getJSONObject("hits").getJSONArray("hits");
        for (Object o : jsonArray) {
            JSONObject hit = (JSONObject)o;
            JSONObject item = new JSONObject();
            item.put("id", (Object)hit.getString("_id"));
            item.put("source", (Object)hit.getJSONObject("_source"));
            result.add(item);
        }
        return result;
    }
}

