/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.Initializer;

import com.digiwin.chatbi.reasoning.search.config.GroundModelConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class ApolloControlInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LoggerFactory.getLogger(ApolloControlInitializer.class);

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        Binder binder = Binder.get((Environment)environment);
        GroundModelConfig groundConfig = (GroundModelConfig)binder.bind("ground-config", Bindable.of(GroundModelConfig.class)).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230 ground-config \u914d\u7f6e"));
        boolean enableApollo = "cloud".equals(groundConfig.getGroundDeployment());
        System.setProperty("apollo.bootstrap.enabled", String.valueOf(enableApollo));
        if (enableApollo) {
            log.info("\u5f53\u524d\u4e3a cloud \u6a21\u5f0f\uff0c\u5f00\u542f Apollo");
        } else {
            log.info("\u5f53\u524d\u4e3a\u975e cloud \u6a21\u5f0f\uff0c\u5173\u95ed Apollo");
        }
    }
}

