/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.AgileDataEchoParam;
import com.digiwin.chatbi.beans.pojos.AgileDataEchoSchema;
import com.digiwin.chatbi.reasoning.search.config.AgileDataEchoHostConfig;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class AgileDataEchoServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(AgileDataEchoServiceInvoker.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private AgileDataEchoHostConfig agileDataEchoHostConfig;
    private static final String APP_CODE = "SCRUMBI";
    private static final String APP_NAME = "\u8bed\u4e49\u670d\u52a1\u7ec4\u4ef6";
    private static final String AGILE_DATA_ECHO_LOG_URL = "/api/ai/agile/echo/exception/submit";
    private static final String AGILE_DATA_SCHEMA_URL = "/api/ai/agile/echo/schema/submit";
    private static final String AGILE_DATA_QUERY_URL = "/api/ai/agile/echo/exception/queryInfo/{messageId}";
    private String LOG_ERR_MESSAGE = "\u4e0a\u62a5agileDataEcho\u65e5\u5fd7\u7cfb\u7edf\u5f02\u5e38";
    private String SCHEMA_ERR_MESSAGE = "\u4e0a\u62a5agileDataEcho\u8981\u7d20\u89e3\u6790\u7cfb\u7edf\u5f02\u5e38";

    public void agileDataEchoLog(AgileDataEchoParam reqParam, String token, String routerKey) {
        log.info("AgileDataEchoServiceInvoker \u4e0a\u62a5agileDataEcho\u65e5\u5fd7 reqParam {}", (Object)reqParam);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("token", token);
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appCode", APP_CODE);
        params.put("appName", APP_NAME);
        params.put("informationType", "1");
        params.put("description", reqParam.getDescription());
        params.put("content", reqParam.getContent());
        params.put("extend", reqParam.getExtend());
        params.put("messageId", reqParam.getMessageId());
        params.put("pixBackendId", reqParam.getPixBackendId());
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.agileDataEchoHostConfig.getUrl().concat(AGILE_DATA_ECHO_LOG_URL), HttpMethod.POST, httpEntity, String.class, new Object[0]);
            log.info("agileDataEchoLog responseEntity\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                log.info("AgileDataEchoServiceInvoker \u4e0a\u62a5agileDataEcho\u65e5\u5fd7\u6210\u529f");
            } else {
                log.info("AgileDataEchoServiceInvoker \u4e0a\u62a5agileDataEcho\u65e5\u5fd7\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.LOG_ERR_MESSAGE));
            }
        }
        catch (RestClientException e2) {
            log.error("AgileDataEchoServiceInvoker \u4e0a\u62a5agileDataEcho\u65e5\u5fd7\u62a5\u9519\uff1a{} ", (Object)e2.getMessage());
        }
    }

    public void agileDataEchoSchema(AgileDataEchoSchema schemaParam, String token, String routerKey) {
        log.info("AgileDataEchoServiceInvoker \u4e0a\u62a5agileDataEcho\u8bed\u4e49\u89e3\u6790\u8981\u7d20 schemaParam {}", (Object)schemaParam);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("token", token);
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        JSONObject params = JSONObject.parseObject((String)JSONObject.toJSONString((Object)schemaParam));
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.agileDataEchoHostConfig.getUrl().concat(AGILE_DATA_SCHEMA_URL), HttpMethod.POST, httpEntity, String.class, new Object[0]);
            log.info("agileDataEchoSchema responseEntity\uff1a{}", responseEntity.getBody());
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                log.info("AgileDataEchoServiceInvoker \u4e0a\u62a5agileDataEcho\u8bed\u4e49\u89e3\u6790\u8981\u7d20\u6210\u529f");
            } else {
                log.info("AgileDataEchoServiceInvoker \u4e0a\u62a5agileDataEcho\u8bed\u4e49\u89e3\u6790\u8981\u7d20\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.SCHEMA_ERR_MESSAGE));
            }
        }
        catch (RestClientException e2) {
            log.error("AgileDataEchoServiceInvoker\u4e0a\u62a5agileDataEcho\u8bed\u4e49\u89e3\u6790\u8981\u7d20\u62a5\u9519:{}", (Object)e2.getMessage());
        }
    }
}

