/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.beans.pojos.StepFieldInfo;
import com.digiwin.chatbi.common.constant.Constants;
import com.digiwin.chatbi.common.constant.SolutionStepConstants;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import com.digiwin.chatbi.service.EocService;
import com.digiwin.chatbi.service.KnowledgemapsService;
import com.github.houbb.opencc4j.util.ZhTwConverterUtil;
import com.google.common.collect.Lists;
import groovy.lang.Tuple3;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConvertorJsonCommonMethod {
    private static final Logger log = LoggerFactory.getLogger(ConvertorJsonCommonMethod.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_DECIMAL = "decimal";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_DATE_TIME = "datetime";
    public static final String OP_GROWTHRATE = "GROWTHRATE";
    public static final String OP_ADD = "ADD";
    public static final String OP_ABS = "ABS";
    public static final String OP_MINUS = "MINUS";
    public static final String OP_MULTIPLY = "MULTIPLY";
    public static final String OP_DIVIDE = "DIVIDE";
    public static final String OP_SUM = "SUM";
    public static final String OP_AVERAGE = "AVERAGE";
    public static final String OP_COUNT = "COUNT";
    public static final String OP_MAX = "MAX";
    public static final String OP_MIN = "MIN";
    public static final String OP_STDDEV = "STDDEV";
    public static final String OP_ROWNUMBER = "ROWNUMBER";
    public static final String OP_DATEFORMAT = "DATEFORMAT";
    public static final String OP_DATESERIES = "DATESERIES";
    public static final String OP_LAG = "LAG";
    private static final Set<String> OP_RETURNS_FIRST_TYPE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("SUM", "MIN", "ABS")));
    private static final Set<String> OP_REQUIRES_HIGHEST_PRECISION = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ADD", "MINUS", "MULTIPLY")));
    private static final Set<String> OP_ALWAYS_RETURNS_DECIMAL = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("DIVIDE", "AVERAGE", "GROWTHRATE", "STDDEV")));
    private static final Set<String> VALID_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("number", "decimal")));
    private static final Set<String> VALID_TYPES_SUM = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("string", "number", "decimal", "datetime")));
    private static final Set<String> VALID_TYPES_4_MAX = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("number", "decimal", "datetime")));
    private static final Map<String, Integer> TYPE_PRECEDENCE = new HashMap();

    private ConvertorJsonCommonMethod() {
    }

    public static String synonymReplaceStandard(String leftVal, String rightVal, JSONObject step, JSONObject context) {
        try {
            Object metric;
            JSONObject metricObj;
            JSONArray schemas;
            JSONArray metricInfo = step.getJSONArray("metricInfo");
            Iterator iterator = metricInfo.iterator();
            while (iterator.hasNext() && !CollectionUtils.isEmpty((Collection)(schemas = (metricObj = (JSONObject)(metric = iterator.next())).getJSONArray("fieldSchema")))) {
                Map synon2Detail;
                List schemasNames = schemas.stream().map(JSONObject.class::cast).map(schema -> schema.getString("name")).collect(Collectors.toList());
                Map map = synon2Detail = context.containsKey((Object)"synonymsMap") ? (Map)context.get((Object)"synonymsMap") : Collections.emptyMap();
                if (!schemasNames.contains(leftVal) || !synon2Detail.keySet().contains(rightVal)) continue;
                String standardName = (String)((Tuple3)synon2Detail.get(rightVal)).getV1();
                String fieldNameEn = (String)((Tuple3)synon2Detail.get(rightVal)).getV2();
                if (Objects.isNull(fieldNameEn) || !fieldNameEn.equals(leftVal)) continue;
                return standardName;
            }
        }
        catch (Exception e) {
            log.error("synonymReplaceStandard is error:", (Throwable)e);
        }
        return rightVal;
    }

    public static void buildSynonymsMap(JSONObject context) {
        JSONArray metricInfo = ConvertorJsonCommonMethod.getMetricInfo((JSONObject)context);
        HashMap synon2Detail = new HashMap();
        List standardLexicon = (List)context.getObject("standard_lexicon", List.class);
        if (CollectionUtils.isNotEmpty((Collection)standardLexicon)) {
            for (JSONObject jsonObject : standardLexicon) {
                if (!StringUtils.isNotEmpty((CharSequence)jsonObject.getString("match_words"))) continue;
                List synonyms = (List)jsonObject.getObject("match_words", List.class);
                String entityType = jsonObject.getString("c_name");
                String standardName = jsonObject.getString("standard_name");
                for (Object o : metricInfo) {
                    JSONObject metricObj = (JSONObject)o;
                    JSONArray fieldSchema = metricObj.getJSONArray("fieldSchema");
                    if (!CollectionUtils.isNotEmpty((Collection)fieldSchema)) continue;
                    String schemaEnName = fieldSchema.stream().map(JSONObject.class::cast).filter(schema -> entityType.equals(schema.getString("title").trim())).findFirst().orElse(new JSONObject()).getString("name");
                    synonyms.forEach(sy -> synon2Detail.put(sy, new Tuple3((Object)standardName, (Object)schemaEnName, (Object)entityType)));
                }
            }
        }
        context.put("synonymsMap", synon2Detail);
    }

    public static String getPostDotElement(String str) {
        int dotIndex = str.indexOf(46);
        if (dotIndex == -1) {
            return str;
        }
        return str.substring(dotIndex + 1);
    }

    public static void buildSimpleShowDefine(JSONObject context, JSONObject easySqlJson) {
        try {
            JSONObject showDefineObj = new JSONObject();
            String title = easySqlJson.getString("T");
            String value = easySqlJson.getString("V");
            if (StringUtils.isBlank((CharSequence)title) && StringUtils.isBlank((CharSequence)value)) {
                log.error("title and value is empty");
                return;
            }
            showDefineObj.put("aliasGrain", context.getOrDefault((Object)"aliasGrain", new ArrayList()));
            JSONArray typeList = new JSONArray();
            JSONObject typeJSONObject = new JSONObject();
            typeJSONObject.put("title", (Object)title);
            typeJSONObject.put("value", (Object)value);
            JSONObject languageTitle = new JSONObject();
            JSONObject language = new JSONObject();
            languageTitle.put("zh_CN", (Object)ZhTwConverterUtil.toSimple((String)title));
            languageTitle.put("zh_TW", (Object)ZhTwConverterUtil.toTraditional((String)title));
            language.put("title", (Object)languageTitle);
            typeJSONObject.put("language", (Object)language);
            typeList.add((Object)typeJSONObject);
            JSONArray showTypeNewList = new JSONArray();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)typeList);
            jsonObject.put("actionId", (Object)ConvertorJsonCommonMethod.getActionId((JSONObject)context));
            showTypeNewList.add((Object)jsonObject);
            showDefineObj.put("showType", (Object)showTypeNewList);
            context.put("showDefine", (Object)showDefineObj);
        }
        catch (Exception e) {
            log.error("build showDefine error: ", (Throwable)e);
        }
    }

    public static void buildGeneralShowDefine(JSONObject context, JSONObject easySqlJson) {
        try {
            JSONObject showDefine;
            JSONObject showTypeObj;
            JSONObject showDefineObj = easySqlJson.getJSONObject("showDefine");
            if (null != showDefineObj && !showDefineObj.isEmpty() && showDefineObj.containsKey((Object)"showType") && null != (showTypeObj = (showDefine = (JSONObject)JSON.parseObject((String)showDefineObj.toJSONString(), JSONObject.class)).getJSONObject("showType")) && !showTypeObj.isEmpty()) {
                JSONArray showTypeNewList = new JSONArray();
                JSONObject jsonObject = new JSONObject();
                JSONArray typeList = new JSONArray();
                JSONObject type = showTypeObj.getJSONObject("type");
                if (null != type && !type.isEmpty()) {
                    String string = (String)type.getOrDefault((Object)"value", (Object)"");
                }
                JSONObject newType = showTypeObj.getJSONObject("type");
                JSONObject languageTitle = new JSONObject();
                JSONObject language = new JSONObject();
                languageTitle.put("zh_CN", (Object)ZhTwConverterUtil.toSimple((String)newType.getString("title")));
                languageTitle.put("zh_TW", (Object)ZhTwConverterUtil.toTraditional((String)newType.getString("title")));
                language.put("title", (Object)languageTitle);
                newType.put("language", (Object)language);
                typeList.add((Object)newType);
                jsonObject.put("type", (Object)typeList);
                jsonObject.put("actionId", (Object)ConvertorJsonCommonMethod.getActionId((JSONObject)context));
                showTypeNewList.add((Object)jsonObject);
                showDefine.put("showType", (Object)showTypeNewList);
                showDefine.put("show", easySqlJson.getOrDefault((Object)"show", (Object)new JSONArray()));
                showDefine.put("aliasGrain", context.getOrDefault((Object)"aliasGrain", new ArrayList()));
                context.put("showDefine", (Object)showDefine);
            }
        }
        catch (Exception e) {
            log.error("build showDefine error: ", (Throwable)e);
        }
    }

    private static String getActionId(JSONObject context) {
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "").replace("\\\"", "\"");
        log.info("combination question: {}", (Object)question);
        String questionHash = ConvertorJsonCommonMethod.getSHA256Hash((String)question).substring(0, 16);
        JSONArray finalMetric = context.getJSONArray("final_metric");
        if (context.containsKey((Object)"scelect_dataSet")) {
            finalMetric = context.getJSONArray("final_dataSet");
        }
        if (CollectionUtils.isEmpty((Collection)finalMetric)) {
            log.error("get metric info is empty");
            return "";
        }
        String metricIdSortStr = finalMetric.stream().map(obj -> ((JSONObject)obj).getString("metricId")).filter(Objects::nonNull).sorted().collect(Collectors.joining("-"));
        return questionHash + "-" + metricIdSortStr;
    }

    public static void processLimit(JSONObject simpleJson, JSONObject step) {
        JSONArray limitArray = simpleJson.getJSONArray("L");
        if (CollectionUtils.isNotEmpty((Collection)limitArray) && limitArray.size() == 2) {
            try {
                Integer startPos = Integer.parseInt(limitArray.get(0).toString());
                Integer endPos = Integer.parseInt(limitArray.get(1).toString());
                JSONObject limitJson = new JSONObject();
                limitJson.put("startPos", (Object)startPos);
                limitJson.put("endPos", (Object)endPos);
                step.put("limit", (Object)limitJson);
            }
            catch (NumberFormatException e) {
                log.error("Invalid limit parameters: {}. Error: {}", (Object)limitArray, (Object)e.getMessage());
            }
        }
    }

    public static JSONArray getMetricInfo(JSONObject context) {
        JSONArray finalMetric = context.containsKey((Object)"scelect_dataSet") ? context.getJSONArray("final_dataSet") : context.getJSONArray("final_metric");
        if (CollectionUtils.isEmpty((Collection)finalMetric)) {
            log.error("get metric info is empty");
            return new JSONArray();
        }
        log.info("getMetricInfo metricInfo: {}", (Object)finalMetric);
        return finalMetric;
    }

    public static void getLanguage(JSONObject fieldSchema, JSONObject language) {
        JSONObject titleJsonObject = Optional.ofNullable(fieldSchema.getJSONObject("lang")).map(lang -> lang.getJSONObject("title")).orElse(new JSONObject());
        if (!titleJsonObject.isEmpty()) {
            titleJsonObject.remove((Object)"en_US");
            language.put("title", (Object)titleJsonObject);
        }
    }

    public static String getSHA256Hash(String input) {
        String hash = "";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = md.digest(input.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            hash = hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Error generating SHA-256 hash: ", (Throwable)e);
        }
        return hash;
    }

    public static String getRightType(String[] splitOrBlankItem) {
        return splitOrBlankItem.length == 4 ? splitOrBlankItem[3] : "const";
    }

    public static boolean checkFieldInSchema(String fieldName, JSONObject step, JSONArray solutionSteps) {
        JSONObject datasetObject;
        String datasetType;
        if (fieldName.contains(".")) {
            fieldName = fieldName.split("\\.")[1];
        }
        if ("step".equals(datasetType = (datasetObject = step.getJSONObject("datasetObject")).getString("datasetType"))) {
            return false;
        }
        if ("dual".equals(datasetType)) {
            return false;
        }
        if (ConvertorJsonCommonMethod.checkFromMetric((String)fieldName, (JSONObject)step, (JSONObject)datasetObject)) {
            return false;
        }
        JSONObject computeObj = step.getJSONObject("computeList");
        if (null != computeObj && computeObj.containsKey((Object)fieldName)) {
            return false;
        }
        if (CollectionUtils.isNotEmpty((Collection)solutionSteps)) {
            for (Object solutionStep : solutionSteps) {
                JSONObject solutionStepObj = (JSONObject)solutionStep;
                JSONObject allCompute = solutionStepObj.getJSONObject("computeList");
                if (allCompute != null && allCompute.containsKey((Object)fieldName)) {
                    return false;
                }
                JSONArray selects = solutionStepObj.getJSONArray("select");
                if (!CollectionUtils.isNotEmpty((Collection)selects)) continue;
                for (int i = 0; i < selects.size(); ++i) {
                    JSONObject select = selects.getJSONObject(i);
                    JSONObject dataObject = select.getJSONObject("dataObject");
                    if (!fieldName.equals(dataObject.getString("alias")) && !fieldName.equals(dataObject.getString("content"))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkFromMetric(String fieldName, JSONObject step, JSONObject datasetObject) {
        String datasetType;
        if (null != datasetObject && SolutionStepConstants.ALL_DATA_DATASET_TYPE.contains(datasetType = datasetObject.getString("datasetType"))) {
            JSONArray metricList = step.getJSONArray("metricInfo");
            for (Object object : metricList) {
                JSONObject metricObj = (JSONObject)object;
                if (ConvertorJsonCommonMethod.checkInDatasetObject((JSONObject)metricObj, (JSONObject)datasetObject, (String)fieldName)) {
                    return true;
                }
                JSONArray join = step.getJSONArray("join");
                if (!CollectionUtils.isNotEmpty((Collection)join)) continue;
                for (int i = 0; i < join.size(); ++i) {
                    JSONObject dataset = (JSONObject)join.get(i);
                    JSONObject datasetObject1 = dataset.getJSONObject("datasetObject");
                    if (!Objects.nonNull(datasetObject1) || !ConvertorJsonCommonMethod.checkInDatasetObject((JSONObject)metricObj, (JSONObject)datasetObject1, (String)fieldName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean checkInDatasetObject(JSONObject metricObj, JSONObject datasetObject, String fieldName) {
        List fieldList;
        return metricObj.getString("metricId").equals(datasetObject.getString("metric")) && (fieldList = metricObj.getJSONArray("fieldSchema").stream().map(obj -> ((JSONObject)obj).getString("name")).filter(Objects::nonNull).collect(Collectors.toList())).contains(fieldName);
    }

    public static void setDimensionCount(JSONObject step, JSONObject context) {
        try {
            JSONArray selectList = step.getJSONArray("select");
            if (CollectionUtils.isNotEmpty((Collection)selectList)) {
                int dimensionCount = 0;
                for (Object select : selectList) {
                    JSONObject jsonObjectItem = (JSONObject)select;
                    JSONObject datasetObject = jsonObjectItem.getJSONObject("dataObject");
                    String dataType = datasetObject.getString("dataType");
                    if (!"string".equals(dataType) && !"datetime".equals(dataType)) continue;
                    ++dimensionCount;
                }
                context.put("dimensionCnt", (Object)dimensionCount);
            }
        }
        catch (Exception e) {
            log.error("setDimensionCount is error", (Throwable)e);
        }
    }

    public static List<String> improveAliases(List<String> allSelectVariables, List<Map<String, List<StepFieldInfo>>> steps) {
        ArrayList<String> result = new ArrayList<String>();
        if (CollectionUtils.isEmpty(allSelectVariables) || CollectionUtils.isEmpty(steps)) {
            log.info("\u5b8c\u5584\u522b\u540d\u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        List selectVariablesGrouped = allSelectVariables.stream().collect(Collectors.groupingBy(s -> s)).values().stream().collect(Collectors.toList());
        for (List group : selectVariablesGrouped) {
            int startIndex = 0;
            block1: for (int i = 0; i < group.size(); ++i) {
                String selectVariable = (String)group.get(i);
                for (int j = startIndex; j < steps.size(); ++j) {
                    Map<String, List<StepFieldInfo>> step = steps.get(j);
                    Map.Entry<String, List<StepFieldInfo>> entry = step.entrySet().iterator().next();
                    String stepName = entry.getKey();
                    List<StepFieldInfo> value = entry.getValue();
                    boolean ifSearched = false;
                    for (StepFieldInfo stepFieldInfo : value) {
                        if (selectVariable.equals(stepFieldInfo.getAliasName())) {
                            result.add(stepName + "." + stepFieldInfo.getAliasName());
                            ifSearched = true;
                            startIndex = j + 1;
                            break;
                        }
                        if (!selectVariable.equals(stepFieldInfo.getFieldName())) continue;
                        result.add(stepName + "." + (StringUtils.isEmpty((CharSequence)stepFieldInfo.getAliasName()) ? stepFieldInfo.getFieldName() : stepFieldInfo.getAliasName()));
                        ifSearched = true;
                        startIndex = j + 1;
                        break;
                    }
                    if (ifSearched) continue block1;
                }
            }
        }
        return result;
    }

    public static String[] customSplit(String input) {
        int firstSpaceIndex = (input = ConvertorJsonCommonMethod.replaceNotInWithNin((String)input)).indexOf(32);
        if (firstSpaceIndex == -1) {
            return new String[]{input};
        }
        int secondSpaceIndex = input.indexOf(32, firstSpaceIndex + 1);
        if (secondSpaceIndex == -1) {
            return new String[]{input.substring(0, firstSpaceIndex), input.substring(firstSpaceIndex + 1)};
        }
        int lastSpaceIndex = input.lastIndexOf(32);
        if (lastSpaceIndex == secondSpaceIndex) {
            return new String[]{input.substring(0, firstSpaceIndex), input.substring(firstSpaceIndex + 1)};
        }
        return new String[]{input.substring(0, firstSpaceIndex), input.substring(firstSpaceIndex + 1, secondSpaceIndex), input.substring(secondSpaceIndex + 1, lastSpaceIndex), input.substring(lastSpaceIndex + 1)};
    }

    public static List<String> queryPermissionSceneOrMetric(JSONObject context, List<JSONObject> metricList) {
        String userId = ((Question)context.getObject("question", Question.class)).getUserId();
        String token = ((Question)context.getObject("question", Question.class)).getToken();
        String routerKey = ((Question)context.getObject("question", Question.class)).getRouterKey();
        List applicationCodes = metricList.stream().map(t -> t.getString("applicationCode")).distinct().collect(Collectors.toList());
        List<String> metricIdList = metricList.stream().map(t -> t.getString("metricId")).distinct().collect(Collectors.toList());
        KnowledgemapsService bean = (KnowledgemapsService)SpringContextUtil.getBean(KnowledgemapsService.class);
        try {
            JSONObject res = bean.queryPermissionSceneOrMetric(token, routerKey, userId, applicationCodes, metricIdList);
            if (res != null) {
                ArrayList<String> permissionList;
                List<String> list = permissionList = Objects.isNull(res.getObject("response", List.class)) ? new ArrayList<String>() : (List)res.getObject("response", List.class);
                if (CollectionUtils.isNotEmpty(permissionList)) {
                    return permissionList;
                }
                return null;
            }
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u573a\u666f\u6307\u6807\u6743\u9650\u83b7\u53d6\u5931\u8d25:{}", (Throwable)e);
        }
        return metricIdList;
    }

    public static List<JSONObject> filterMetricPermission(JSONObject context, List<JSONObject> metrics) {
        List metricIdList = ConvertorJsonCommonMethod.queryPermissionSceneOrMetric((JSONObject)context, metrics);
        if (metricIdList == null || CollectionUtils.isEmpty((Collection)metricIdList)) {
            context.put("noPermissionMetrics", metrics.stream().map(metric -> metric.getString("metricId")).collect(Collectors.toSet()));
            return null;
        }
        HashSet<String> noPermissionApps = new HashSet<String>();
        ArrayList<JSONObject> noPermissionMetrics = new ArrayList<JSONObject>();
        HashSet<String> noPermissionMetricIds = new HashSet<String>();
        for (JSONObject metric2 : metrics) {
            String appcode2 = metric2.getString("applicationCode");
            String metricId = metric2.getString("metricId");
            if (metricIdList.contains(metricId)) continue;
            JSONObject noPermissionMetric = new JSONObject();
            noPermissionMetric.put("metricId", (Object)metricId);
            noPermissionMetric.put("applicationCode", (Object)appcode2);
            noPermissionMetrics.add(noPermissionMetric);
            noPermissionMetricIds.add(metricId);
            noPermissionApps.add(appcode2);
        }
        context.put("noPermissionMetrics", noPermissionMetricIds);
        log.info("\u7528\u6237\u65e0\u6743\u9650\u67e5\u770b\u6307\u6807\u4ee5\u53ca\u5e94\u7528\uff1a{} ", noPermissionMetrics);
        if (CollectionUtils.isNotEmpty(noPermissionApps)) {
            noPermissionApps.forEach(appcode -> metrics.removeIf(metric -> metric.getString("applicationCode").equals(appcode)));
        }
        return metrics;
    }

    public static String getEocCompanyId(JSONObject context, String companyName) {
        try {
            EocService eocService = (EocService)SpringContextUtil.getBean(EocService.class);
            String token = ((Question)context.getObject("question", Question.class)).getToken();
            StopWatch stopWatch = StopWatch.createStarted();
            HashMap map = eocService.corpCompany(token);
            stopWatch.stop();
            log.info("getEocCompanyId from EOC elapsed time: {}ms", (Object)stopWatch.getTime());
            if (!map.isEmpty()) {
                return (String)map.get(companyName);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6EOC\u516c\u53f8ID\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return null;
    }

    public static String getEocCompanyName(JSONObject context, String companyId) {
        try {
            EocService eocService = (EocService)SpringContextUtil.getBean(EocService.class);
            String token = ((Question)context.getObject("question", Question.class)).getToken();
            StopWatch stopWatch = StopWatch.createStarted();
            HashMap map = eocService.getCompanyNameById(token);
            stopWatch.stop();
            log.info("getEocCompanyName from EOC elapsed time: {}ms", (Object)stopWatch.getTime());
            if (!map.isEmpty()) {
                return (String)map.get(companyId);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6EOC\u516c\u53f8name\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return null;
    }

    public static JSONObject getFormatObj(JSONObject filterJsonObj, String outLogical) {
        try {
            Object logicalJson;
            if (filterJsonObj.containsKey((Object)"and") && filterJsonObj.containsKey((Object)"or")) {
                JSONObject newFilterJson = new JSONObject();
                newFilterJson.put("and", (Object)filterJsonObj);
                return newFilterJson;
            }
            if ("and".equals(outLogical) && (logicalJson = filterJsonObj.get((Object)outLogical)) instanceof JSONArray) {
                boolean isNotFormat = false;
                JSONArray arr = (JSONArray)logicalJson;
                for (Object object : arr) {
                    JSONObject jsonObj;
                    if (!(object instanceof JSONObject) || !(jsonObj = (JSONObject)object).containsKey((Object)"or")) continue;
                    isNotFormat = true;
                }
                if (isNotFormat) {
                    JSONObject newFilterJson = new JSONObject();
                    JSONObject jsonObject = new JSONObject();
                    JSONArray andArr = new JSONArray();
                    JSONArray orArr = new JSONArray();
                    for (Object object : arr) {
                        JSONObject jsonObj;
                        if (object instanceof JSONObject && (jsonObj = (JSONObject)object).containsKey((Object)"or")) {
                            orArr = jsonObj.getJSONArray("or");
                        }
                        if (!(object instanceof String)) continue;
                        andArr.add(object);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)orArr)) {
                        jsonObject.put("or", (Object)orArr);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)andArr)) {
                        jsonObject.put("and", (Object)andArr);
                    }
                    newFilterJson.put("and", (Object)jsonObject);
                    return newFilterJson;
                }
            }
        }
        catch (Exception e) {
            log.error("filterJsonObj format error", (Throwable)e);
        }
        return filterJsonObj;
    }

    public static Boolean queryMetricSwitch(JSONObject context) {
        JSONObject jsonObject;
        context.put("switchName", (Object)"metric_permission_switch");
        List configList = Optional.ofNullable(Retrieve.SWITCH_CONFIG.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(Lists.newArrayList());
        if (CollectionUtils.isNotEmpty((Collection)configList) && Constants.APPCODE_PERMISSION_OPEN.equals((jsonObject = (JSONObject)configList.get(0)).getInteger("value"))) {
            return true;
        }
        return false;
    }

    public static JSONArray getFieldSchemaList(JSONObject step) {
        JSONArray fieldSchemaList = new JSONArray();
        JSONObject datasetObject = step.getJSONObject("datasetObject");
        String datasetType = datasetObject.getString("datasetType");
        if (!SolutionStepConstants.ALL_DATA_DATASET_TYPE.contains(datasetType)) {
            return new JSONArray();
        }
        String metricId = datasetObject.getString("metric");
        JSONArray metricList = step.getJSONArray("metricInfo");
        if (CollectionUtils.isEmpty((Collection)metricList)) {
            return fieldSchemaList;
        }
        for (Object metric : metricList) {
            JSONObject metricObj = (JSONObject)metric;
            if (!metricObj.getString("metricId").equals(metricId)) continue;
            fieldSchemaList = metricObj.getJSONArray("fieldSchema");
            break;
        }
        return fieldSchemaList;
    }

    public static List<JSONObject> getFieldEnumsList(JSONArray fieldSchemaList, String fieldName) {
        if (CollectionUtils.isEmpty((Collection)fieldSchemaList)) {
            return new ArrayList<JSONObject>();
        }
        HashMap enumFieldMap = new HashMap();
        fieldSchemaList.forEach(item -> {
            JSONObject fieldSchema = (JSONObject)item;
            List enums = (List)fieldSchema.getOrDefault((Object)"enums", new ArrayList());
            if (CollectionUtils.isNotEmpty((Collection)enums)) {
                enumFieldMap.put(fieldSchema.getString("name"), enums);
            }
        });
        if (enumFieldMap.isEmpty()) {
            return new ArrayList<JSONObject>();
        }
        if (!enumFieldMap.containsKey(fieldName)) {
            return new ArrayList<JSONObject>();
        }
        List jsonObjects = (List)enumFieldMap.get(fieldName);
        return jsonObjects;
    }

    public static JSONObject filterInvalidField(JSONObject step, JSONObject filterJsonObj, String outLogical) {
        JSONArray fieldSchemaList = ConvertorJsonCommonMethod.getFieldSchemaList((JSONObject)step);
        if (CollectionUtils.isEmpty((Collection)fieldSchemaList)) {
            return filterJsonObj;
        }
        List fieldNameList = fieldSchemaList.stream().map(obj -> ((JSONObject)obj).getString("name")).filter(Objects::nonNull).collect(Collectors.toList());
        Object logicalJson = filterJsonObj.get((Object)outLogical);
        if (Objects.isNull(logicalJson)) {
            return filterJsonObj;
        }
        if (logicalJson instanceof JSONObject) {
            JSONArray newOrItems = new JSONArray();
            JSONArray orItems = ((JSONObject)logicalJson).getJSONArray("or");
            for (int i = 0; i < orItems.size(); ++i) {
                String[] filterItem = ConvertorJsonCommonMethod.customSplit((String)orItems.get(i).toString());
                if (filterItem.length != 4) continue;
                ConvertorJsonCommonMethod.checkIsInEnums((String)orItems.get(i).toString(), (String[])filterItem, fieldNameList, (JSONArray)fieldSchemaList, (JSONArray)newOrItems);
            }
            JSONArray andItems = ((JSONObject)logicalJson).getJSONArray("and");
            JSONArray newAndItems = new JSONArray();
            for (int i = 0; i < andItems.size(); ++i) {
                String[] filterItem = ConvertorJsonCommonMethod.customSplit((String)andItems.get(i).toString());
                if (filterItem.length != 4) continue;
                ConvertorJsonCommonMethod.checkIsInEnums((String)andItems.get(i).toString(), (String[])filterItem, fieldNameList, (JSONArray)fieldSchemaList, (JSONArray)newAndItems);
            }
            JSONObject newFilterJson = new JSONObject();
            if (CollectionUtils.isNotEmpty((Collection)newOrItems) && CollectionUtils.isNotEmpty((Collection)newAndItems)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("or", (Object)newOrItems);
                jsonObject.put("and", (Object)newAndItems);
                newFilterJson.put("and", (Object)jsonObject);
            }
            if (CollectionUtils.isNotEmpty((Collection)newOrItems) && CollectionUtils.isEmpty((Collection)newAndItems)) {
                newFilterJson.put("or", (Object)newOrItems);
            }
            if (CollectionUtils.isNotEmpty((Collection)newAndItems) && CollectionUtils.isEmpty((Collection)newOrItems)) {
                newFilterJson.put("and", (Object)newAndItems);
            }
            filterJsonObj = newFilterJson;
            return filterJsonObj;
        }
        if (logicalJson instanceof JSONArray) {
            JSONArray newItems = new JSONArray();
            JSONArray jsonArray = (JSONArray)logicalJson;
            for (int i = 0; i < jsonArray.size(); ++i) {
                String[] filterItem = ConvertorJsonCommonMethod.customSplit((String)jsonArray.getString(i).toString());
                if (filterItem.length != 4) continue;
                ConvertorJsonCommonMethod.checkIsInEnums((String)jsonArray.getString(i).toString(), (String[])filterItem, fieldNameList, (JSONArray)fieldSchemaList, (JSONArray)newItems);
            }
            if (CollectionUtils.isEmpty((Collection)newItems)) {
                return new JSONObject();
            }
            filterJsonObj.put(outLogical, (Object)newItems);
            return filterJsonObj;
        }
        return filterJsonObj;
    }

    public static void checkIsInEnums(String item, String[] filterItem, List<String> fieldNameList, JSONArray fieldSchemaList, JSONArray newItems) {
        String fieldName = filterItem[0].trim();
        String operate = filterItem[1].trim();
        String content = filterItem[2].trim();
        String constant = filterItem[3].trim();
        if (fieldNameList.contains(fieldName)) {
            List fieldEnumsList = ConvertorJsonCommonMethod.getFieldEnumsList((JSONArray)fieldSchemaList, (String)fieldName);
            if (CollectionUtils.isNotEmpty((Collection)fieldEnumsList)) {
                if ("=".equals(operate)) {
                    String enumValue = ConvertorJsonCommonMethod.checkAndReplaceValueByEqual((String)content, (List)fieldEnumsList);
                    if (StringUtils.isNotEmpty((CharSequence)enumValue)) {
                        String newItem = fieldName.concat(" ").concat(operate).concat(" ").concat(enumValue).concat(" ").concat(constant);
                        newItems.add((Object)newItem);
                    }
                } else if ("in".equals(operate) || "not_in".equals(operate)) {
                    String trimmedInput = content.substring(1, content.length() - 1);
                    String[] inContentArr = trimmedInput.split(",");
                    List<String> stringList = Arrays.asList(inContentArr);
                    ArrayList<String> contentList = new ArrayList<String>();
                    for (String contentValue : stringList) {
                        String enumValue = ConvertorJsonCommonMethod.checkAndReplaceValueByEqual((String)contentValue, (List)fieldEnumsList);
                        if (!StringUtils.isNotEmpty((CharSequence)enumValue)) continue;
                        contentList.add(enumValue);
                    }
                    if (CollectionUtils.isNotEmpty(contentList)) {
                        String newContent = contentList.stream().collect(Collectors.joining(",", "(", ")"));
                        String newItem = fieldName.concat(" ").concat(operate).concat(" ").concat(newContent).concat(" ").concat(constant);
                        newItems.add((Object)newItem);
                    }
                }
            } else if ("=".equals(operate) && "date".equals(ConvertorJsonCommonMethod.getDataTypeByFieldName((String)fieldName, (JSONArray)fieldSchemaList))) {
                String newItem = fieldName.concat(" ").concat("btw").concat(" ").concat(content).concat("#").concat(content).concat(" ").concat(constant);
                newItems.add((Object)newItem);
            } else {
                newItems.add((Object)item.toString());
            }
        } else {
            newItems.add((Object)item.toString());
        }
    }

    private static String getDataTypeByFieldName(String fieldName, JSONArray fieldSchemaList) {
        for (Object field : fieldSchemaList) {
            JSONObject fieldObj;
            String name;
            if (!(field instanceof JSONObject) || !fieldName.equals(name = (fieldObj = (JSONObject)field).getString("name"))) continue;
            return fieldObj.getString("dataType");
        }
        return null;
    }

    private static String checkAndReplaceValueByEqual(String content, List<JSONObject> fieldEnumsList) {
        for (JSONObject fieldEnum : fieldEnumsList) {
            if (content.equals(fieldEnum.getString("value"))) {
                return content;
            }
            if (content.equals(fieldEnum.getString("description"))) {
                return fieldEnum.getString("value");
            }
            JSONObject descJsonObject = Optional.ofNullable(fieldEnum.getJSONObject("lang")).map(lang -> lang.getJSONObject("description")).orElse(new JSONObject());
            if (descJsonObject.isEmpty() || !content.equals(descJsonObject.getString("zh_TW")) && !content.equals(descJsonObject.getString("zh_CN"))) continue;
            return fieldEnum.getString("value");
        }
        return null;
    }

    public static boolean checkIsNeedAddSort(JSONObject step) {
        return !step.containsKey((Object)"sort") || CollectionUtils.isEmpty((Collection)step.getJSONArray("sort"));
    }

    public static boolean checkEasyIsDetailSelect(JSONObject GPTJson) {
        JSONArray selectArray;
        return CollectionUtils.isNotEmpty((Collection)GPTJson.getJSONArray("S")) && (selectArray = GPTJson.getJSONArray("S")).size() == 1 && selectArray.get(0).equals("*");
    }

    public static boolean checkGeneralIsDetailSelect(JSONObject stepItemJson) {
        JSONArray selectArray;
        JSONObject selectJson = stepItemJson.getJSONObject("S");
        return stepItemJson.getJSONObject("S") != null && (selectArray = selectJson.getJSONArray("field")).size() == 1 && selectArray.get(0).equals("*");
    }

    public static void addDefaultSort(JSONObject step) {
        JSONArray selectList = step.getJSONArray("select");
        if (CollectionUtils.isNotEmpty((Collection)selectList)) {
            JSONArray sortArray = new JSONArray();
            for (Object select : selectList) {
                JSONObject jsonObjectItem = (JSONObject)select;
                JSONObject datasetObject = jsonObjectItem.getJSONObject("dataObject");
                String dataType = datasetObject.getString("dataType");
                if (!"string".equals(dataType) && !"datetime".equals(dataType)) continue;
                JSONObject orderByJson = new JSONObject();
                JSONObject dataObject = new JSONObject();
                dataObject.put("content", (Object)datasetObject.getString("content"));
                dataObject.put("source", (Object)datasetObject.getString("source"));
                dataObject.put("dataType", (Object)dataType);
                dataObject.put("contentType", (Object)datasetObject.getString("contentType"));
                orderByJson.put("order", (Object)"asc");
                orderByJson.put("dataObject", (Object)dataObject);
                sortArray.add((Object)orderByJson);
            }
            if (CollectionUtils.isNotEmpty((Collection)sortArray)) {
                step.put("sort", (Object)sortArray);
            }
        }
    }

    public static String[] supplementFilterDateFormat(String[] btwDateItem, JSONObject metricFieldSchema) {
        return btwDateItem;
    }

    public static String getYMDDateContent(String dateContent, String operator, JSONObject fieldSchema) {
        String[] dateItem = new String[]{dateContent, dateContent};
        dateItem = ConvertorJsonCommonMethod.supplementFilterDateFormat((String[])dateItem, (JSONObject)fieldSchema);
        if ("gte".equals(operator)) {
            return dateItem[0];
        }
        if ("lte".equals(operator)) {
            return dateItem[1];
        }
        return dateContent;
    }

    public static boolean checkFilterDateFormat(String dateString) {
        try {
            LocalDateTime.parse(dateString, DATE_TIME_FORMATTER);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private static String convertDateTimeToDate(String dateContent) {
        try {
            LocalDateTime dateTime = LocalDateTime.parse(dateContent, DATE_TIME_FORMATTER);
            String dateStr = dateTime.format(DATE_FORMATTER);
            return dateStr;
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u683c\u5f0fHHmmss\u8f6cyyyyMMdd\u5f02\u5e38", (Throwable)e);
            return dateContent;
        }
    }

    public static String convertDateToDateTime(String dateString, int i) {
        try {
            LocalDate date = LocalDate.parse(dateString, DATE_FORMATTER);
            if (i == 0) {
                LocalDateTime dateTime = date.atStartOfDay();
                return dateTime.format(DATE_TIME_FORMATTER);
            }
            LocalDateTime dateTime = date.atTime(23, 59, 59);
            return dateTime.format(DATE_TIME_FORMATTER);
        }
        catch (DateTimeParseException e) {
            log.error("\u65e5\u671f\u683c\u5f0fyyyyMMdd\u8f6cHHmmss\u5f02\u5e38", (Throwable)e);
            return dateString;
        }
    }

    public static JSONObject buildDataObject(String content, String source, String dataType, String contentType) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("content", (Object)content);
        dataObject.put("source", (Object)source);
        dataObject.put("dataType", (Object)dataType);
        dataObject.put("contentType", (Object)contentType);
        return dataObject;
    }

    public static String replaceNotInWithNin(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return input;
        }
        String regex = "\\bnot\\s+in\\b";
        String result = input.replaceAll(regex, "nin");
        return result;
    }

    public static String getDatasetType(JSONObject context) {
        Question question = (Question)context.getObject("question", Question.class);
        String productVersion = question.getProductVersion();
        boolean ifMetric = context.containsKey((Object)"scelect_metric");
        if (ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion)) {
            return "dataset";
        }
        if (ifMetric) {
            return "metric";
        }
        return "metricDataset";
    }

    public static String getAliasBySourceAndContent(JSONArray solutionSteps, String source, String content, List<Map<String, List<StepFieldInfo>>> selectInfoCacheList) {
        try {
            for (Object solutionStepObj : solutionSteps) {
                if (!((JSONObject)solutionStepObj).getString("alias").equals(source)) continue;
                for (Object selectObj : ((JSONObject)solutionStepObj).getJSONArray("select")) {
                    if (!content.equals(((JSONObject)selectObj).getJSONObject("dataObject").getString("content"))) continue;
                    return ((JSONObject)selectObj).getJSONObject("dataObject").getString("alias");
                }
            }
        }
        catch (Exception e) {
            log.error("getAliasBySourceAndContent\u5f02\u5e38:{}", (Throwable)e);
            return content;
        }
        return ConvertorJsonCommonMethod.getContentAlias((String)content, (String)source, selectInfoCacheList);
    }

    public static String getContentAlias(String content, String source, List<Map<String, List<StepFieldInfo>>> selectInfoCacheList) {
        String alias = ConvertorJsonCommonMethod.replaceAlias((String)content, (String)source, selectInfoCacheList);
        if (StringUtils.isNotEmpty((CharSequence)alias)) {
            return alias;
        }
        return content;
    }

    public static String replaceAlias(String fieldName, String source, List<Map<String, List<StepFieldInfo>>> fromJoinList) {
        for (Map<String, List<StepFieldInfo>> map : fromJoinList) {
            for (Map.Entry<String, List<StepFieldInfo>> entry : map.entrySet()) {
                String key = entry.getKey();
                if (!key.equals(source)) continue;
                List<StepFieldInfo> fieldInfos = entry.getValue();
                for (StepFieldInfo fieldInfo : fieldInfos) {
                    if (!fieldName.equals(fieldInfo.getFieldName())) continue;
                    return fieldInfo.getAliasName();
                }
            }
        }
        return fieldName;
    }

    public static Boolean ifConst(JSONObject step, JSONArray solutionSteps, String rightContent) {
        List metricIdsOrAlias = step.getJSONArray("metricInfo").stream().map(m -> ((JSONObject)m).getString("metricId")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)solutionSteps)) {
            List aliasList = solutionSteps.stream().map(solutionStep -> ((JSONObject)solutionStep).getString("alias")).collect(Collectors.toList());
            metricIdsOrAlias.addAll(aliasList);
        }
        if (!metricIdsOrAlias.contains(rightContent.split("\\.")[0])) {
            return true;
        }
        return false;
    }

    public static String[] getContentWithIfConst(JSONObject step, JSONArray solutionSteps, String rightContent) {
        String[] rightContentSplit = ConvertorJsonCommonMethod.ifConst((JSONObject)step, (JSONArray)solutionSteps, (String)rightContent) != false ? new String[]{rightContent} : rightContent.split("\\.");
        return rightContentSplit;
    }

    public static String findOrgField(String selectContent, int currentIndex, JSONArray solutionSteps, int count) {
        String content;
        String res;
        String alias;
        if (++count > 500) {
            log.error("\u51fa\u73b0\u9012\u5f52\u5f02\u5e38");
            return null;
        }
        if (solutionSteps.size() < currentIndex + 1) {
            return null;
        }
        JSONObject currentStep = solutionSteps.getJSONObject(currentIndex);
        JSONArray sorts = currentStep.getJSONArray("sort");
        if (CollectionUtils.isNotEmpty((Collection)sorts)) {
            for (Object sort : sorts) {
                String sortContent = ((JSONObject)sort).getJSONObject("dataObject").getString("content");
                if (!sortContent.equals(selectContent)) continue;
                return ((JSONObject)sort).getString("order");
            }
        }
        if (currentIndex == 0) {
            return null;
        }
        List previousSolutionSteps = solutionSteps.subList(0, currentIndex);
        for (int i = 0; i < previousSolutionSteps.size(); ++i) {
            JSONArray previousSelects = ((JSONObject)previousSolutionSteps.get(i)).getJSONArray("select");
            if (CollectionUtils.isEmpty((Collection)previousSelects)) continue;
            for (Object previousSelectObj : previousSelects) {
                JSONObject previousSelect = (JSONObject)previousSelectObj;
                alias = previousSelect.getJSONObject("dataObject").getString("alias");
                if (!alias.equals(selectContent) || !StringUtils.isNotEmpty((CharSequence)(res = ConvertorJsonCommonMethod.findOrgField((String)(content = previousSelect.getJSONObject("dataObject").getString("content")), (int)i, (JSONArray)solutionSteps, (int)count)))) continue;
                return res;
            }
        }
        if (Objects.isNull(currentStep.getJSONObject("computeList")) || CollectionUtils.isEmpty((Collection)currentStep.getJSONObject("computeList").getJSONArray(selectContent))) {
            return null;
        }
        JSONObject compute = (JSONObject)currentStep.getJSONObject("computeList").getJSONArray(selectContent).get(0);
        if (Objects.isNull(compute)) {
            return null;
        }
        if (!compute.getString("calFunction").equalsIgnoreCase("DateFormat")) {
            return null;
        }
        String paramContent = ((JSONObject)compute.getJSONArray("params").get(0)).getString("content");
        String paramSource = ((JSONObject)compute.getJSONArray("params").get(0)).getString("source");
        for (int i = 0; i < previousSolutionSteps.size(); ++i) {
            JSONArray previousSelects = ((JSONObject)previousSolutionSteps.get(i)).getJSONArray("select");
            alias = ((JSONObject)previousSolutionSteps.get(i)).getString("alias");
            if (!paramSource.equals(alias)) continue;
            content = ConvertorJsonCommonMethod.getSelectContent((String)paramContent, (JSONArray)previousSelects);
            if (StringUtils.isEmpty((CharSequence)content)) {
                return null;
            }
            res = ConvertorJsonCommonMethod.findOrgField((String)content, (int)i, (JSONArray)solutionSteps, (int)count);
            if (!StringUtils.isNotEmpty((CharSequence)res)) continue;
            return res;
        }
        return null;
    }

    private static String getSelectContent(String paramContent, JSONArray previousSelects) {
        if (CollectionUtils.isEmpty((Collection)previousSelects)) {
            return null;
        }
        for (Object previousSelectObj : previousSelects) {
            JSONObject previousSelect = (JSONObject)previousSelectObj;
            String selectAlias = previousSelect.getJSONObject("dataObject").getString("alias");
            if (!selectAlias.equals(paramContent)) continue;
            String content = previousSelect.getJSONObject("dataObject").getString("content");
            return content;
        }
        return null;
    }

    public static void reBuildSorts(JSONArray solutionSteps, JSONArray select) {
        boolean haveMeasureSort = false;
        for (Object solutionStep : solutionSteps) {
            JSONArray sorts = ((JSONObject)solutionStep).getJSONArray("sort");
            if (CollectionUtils.isEmpty((Collection)sorts)) continue;
            for (Object sort : sorts) {
                String dataType = ((JSONObject)sort).getJSONObject("dataObject").getString("dataType");
                if (!ConvertorJsonCommonMethod.isMeasure((String)dataType)) continue;
                haveMeasureSort = true;
            }
        }
        if (haveMeasureSort) {
            return;
        }
        JSONArray reBuildSorts = new JSONArray();
        for (Object o : select) {
            String dataType = ((JSONObject)o).getJSONObject("dataObject").getString("dataType");
            if (ConvertorJsonCommonMethod.isMeasure((String)dataType)) continue;
            String selectContent = ((JSONObject)o).getJSONObject("dataObject").getString("content");
            int currentIndex = solutionSteps.size() - 1;
            String sortOrder = ConvertorJsonCommonMethod.findOrgField((String)selectContent, (int)currentIndex, (JSONArray)JSONArray.parseArray((String)solutionSteps.toJSONString()), (int)0);
            reBuildSorts.add((Object)ConvertorJsonCommonMethod.buildSort((JSONObject)((JSONObject)o), (String)sortOrder));
        }
        if (CollectionUtils.isNotEmpty((Collection)reBuildSorts)) {
            solutionSteps.getJSONObject(solutionSteps.size() - 1).put("sort", (Object)reBuildSorts);
        }
    }

    public static JSONObject buildSort(JSONObject o, String sortOrder) {
        JSONObject sortJson = new JSONObject();
        JSONObject sortDataObj = new JSONObject();
        sortDataObj.put("dataType", (Object)o.getJSONObject("dataObject").getString("dataType"));
        sortDataObj.put("source", (Object)o.getJSONObject("dataObject").getString("source"));
        sortDataObj.put("content", (Object)o.getJSONObject("dataObject").getString("content"));
        sortDataObj.put("contentType", (Object)o.getJSONObject("dataObject").getString("contentType"));
        sortJson.put("dataObject", (Object)sortDataObj);
        sortJson.put("order", (Object)(StringUtils.isNotEmpty((CharSequence)sortOrder) ? sortOrder : "asc"));
        return sortJson;
    }

    public static List<JSONObject> buildFieldTypeInDataTag(List<JSONObject> dataTagList, JSONArray select, List<String> allTypeFields, String type) {
        if (CollectionUtils.isEmpty(allTypeFields)) {
            return dataTagList;
        }
        for (Object o : select) {
            String alias = ((JSONObject)o).getJSONObject("dataObject").getString("alias");
            if (!allTypeFields.contains(StringUtil.getStringAfterLastChar((String)alias, (String)"#"))) continue;
            Optional<JSONObject> first = dataTagList.stream().filter(d -> alias.equals(d.getString("alias"))).findFirst();
            if (first.isPresent()) {
                for (JSONObject dataTag : dataTagList) {
                    if (!alias.equals(dataTag.getString("alias"))) continue;
                    dataTag.put(type, (Object)true);
                }
                continue;
            }
            JSONObject dataTag = new JSONObject();
            dataTag.put("alias", (Object)alias);
            dataTag.put(type, (Object)true);
            dataTagList.add(dataTag);
        }
        return dataTagList;
    }

    public static String getOrgDataType(JSONArray previousSolutionSteps, String content, String stepName) {
        for (int i = 0; i < previousSolutionSteps.size(); ++i) {
            JSONArray previousSelects = ((JSONObject)previousSolutionSteps.get(i)).getJSONArray("select");
            if (CollectionUtils.isEmpty((Collection)previousSelects) || !stepName.equals(((JSONObject)previousSolutionSteps.get(i)).getString("alias"))) continue;
            for (Object previousSelectObj : previousSelects) {
                JSONObject previousSelect = (JSONObject)previousSelectObj;
                String alias = previousSelect.getJSONObject("dataObject").getString("alias");
                if (!alias.equals(content)) continue;
                String dataType = previousSelect.getJSONObject("dataObject").getString("dataType");
                return dataType;
            }
        }
        return null;
    }

    public static String determineResultType(String operation, String firstType, String secondType) {
        ConvertorJsonCommonMethod.validateInputOperation((String)operation);
        if ("MAX".equalsIgnoreCase(operation)) {
            ConvertorJsonCommonMethod.validateInputType((String)firstType, (String)secondType, (Set)VALID_TYPES_4_MAX);
            return firstType;
        }
        if (OP_RETURNS_FIRST_TYPE.contains(operation)) {
            ConvertorJsonCommonMethod.validateInputType((String)firstType, (String)secondType, (Set)VALID_TYPES);
            return firstType;
        }
        if (OP_REQUIRES_HIGHEST_PRECISION.contains(operation)) {
            ConvertorJsonCommonMethod.validateInputType((String)firstType, (String)secondType, (Set)VALID_TYPES);
            return ConvertorJsonCommonMethod.getHigherPriorityType((String)firstType, (String)secondType);
        }
        if (OP_ALWAYS_RETURNS_DECIMAL.contains(operation)) {
            ConvertorJsonCommonMethod.validateInputType((String)firstType, (String)secondType, (Set)VALID_TYPES);
            return "decimal";
        }
        if ("ROWNUMBER".equals(operation)) {
            ConvertorJsonCommonMethod.validateInputType((String)firstType, (String)secondType, (Set)VALID_TYPES);
            return "number";
        }
        if ("COUNT".equals(operation)) {
            ConvertorJsonCommonMethod.validateInputType((String)firstType, (String)secondType, (Set)VALID_TYPES_SUM);
            return "number";
        }
        if ("DATEFORMAT".equals(operation)) {
            return "string";
        }
        return firstType;
    }

    private static String getHigherPriorityType(String type1, String type2) {
        int precedence2;
        if (StringUtils.isEmpty((CharSequence)type1)) {
            return type2;
        }
        if (StringUtils.isEmpty((CharSequence)type2)) {
            return type1;
        }
        int precedence1 = TYPE_PRECEDENCE.getOrDefault(type1, 0);
        return precedence1 >= (precedence2 = TYPE_PRECEDENCE.getOrDefault(type2, 0).intValue()) ? type1 : type2;
    }

    private static void validateInputOperation(String operation) {
        if (!Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("GROWTHRATE", "ADD", "ABS", "MINUS", "MULTIPLY", "DIVIDE", "SUM", "AVERAGE", "COUNT", "MAX", "MIN", "STDDEV", "ROWNUMBER", "DATEFORMAT", "DATESERIES", "LAG"))).contains(operation)) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8fd0\u7b97\u51fd\u6570\u540d\uff1a" + operation);
        }
    }

    private static void validateInputType(String firstType, String secondType, Set<String> validTypes) {
        if (StringUtils.isEmpty((CharSequence)firstType) || !validTypes.contains(firstType.toLowerCase())) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u7b2c\u4e00\u4e2a\u5b57\u6bb5\u7c7b\u578b\uff1a" + firstType);
        }
        if (StringUtils.isNotEmpty((CharSequence)secondType) && !validTypes.contains(secondType.toLowerCase())) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u7b2c\u4e8c\u4e2a\u5b57\u6bb5\u7c7b\u578b\uff1a" + secondType);
        }
    }

    public static void main(String[] args) {
        System.out.println(ConvertorJsonCommonMethod.determineResultType((String)"COUNT", (String)"decimal", null));
    }

    public static boolean checkFromCurrentMetric(String fieldName, JSONObject step, String metricId) {
        if (StringUtils.isEmpty((CharSequence)metricId)) {
            return false;
        }
        JSONArray metricList = step.getJSONArray("metricInfo");
        for (Object object : metricList) {
            List fieldList;
            JSONObject metricObj = (JSONObject)object;
            if (!metricObj.getString("metricId").equals(metricId) || !(fieldList = metricObj.getJSONArray("fieldSchema").stream().map(obj -> ((JSONObject)obj).getString("name")).filter(Objects::nonNull).collect(Collectors.toList())).contains(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMeasure(String dataType) {
        return "number".equalsIgnoreCase(dataType) || "decimal".equalsIgnoreCase(dataType);
    }

    static {
        TYPE_PRECEDENCE.put("number", 1);
        TYPE_PRECEDENCE.put("decimal", 2);
    }
}

