/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.common.util.MdcUtil;
import com.digiwin.chatbi.reasoning.search.config.AppTokenConfig;
import com.digiwin.chatbi.reasoning.search.config.DmpHostConfig;
import io.github.resilience4j.timelimiter.annotation.TimeLimiter;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class DmpServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(DmpServiceInvoker.class);
    @Autowired
    private DmpHostConfig dmpHostConfig;
    @Autowired
    private AppTokenConfig appTokenConfig;
    @Autowired
    private RestTemplate restTemplate;
    private static final String QUERY_DISTINCT_DIMENSION_DATA = "/search/external/model/query-distinct-dimension-data";
    private String ERR_MESSAGE = "\u67e5\u8be2dmp\u7cfb\u7edf\u5f02\u5e38";

    @TimeLimiter(name="queryDistinctDimensionDataApi", fallbackMethod="timeOutFallback")
    public CompletableFuture<JSONArray> queryDistinctDimensionData(JSONObject param, String token, String sid, String routerKey, String ptxId) {
        log.info("queryDistinctDimensionData\u5165\u53c2:{},sid:{}", (Object)param, (Object)sid);
        return CompletableFuture.supplyAsync(() -> {
            if (StringUtils.isNotEmpty((CharSequence)ptxId)) {
                MdcUtil.setTraceId((String)ptxId);
            }
            HttpHeaders headers = new HttpHeaders();
            if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
                headers.add("routerKey", routerKey);
            }
            headers.add("Content-Type", "application/json");
            headers.add("digi-middleware-auth-app", this.appTokenConfig.getAthena());
            headers.add("digi-middleware-auth-user", token);
            headers.add("digi-Middleware-Tenant-Id", sid);
            HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
            try {
                ResponseEntity responseEntity = this.restTemplate.postForEntity(this.dmpHostConfig.getUrl().concat(QUERY_DISTINCT_DIMENSION_DATA), (Object)httpEntity, String.class, new Object[0]);
                log.info("queryDistinctDimensionData\u51fa\u53c2\uff1a{}", responseEntity.getBody());
                if (responseEntity.getStatusCode().is2xxSuccessful()) {
                    JSONArray rows = JSONObject.parseObject((String)((String)responseEntity.getBody())).getJSONArray("data");
                    if (CollectionUtils.isNotEmpty((Collection)rows)) {
                        JSONArray jSONArray = rows;
                        return jSONArray;
                    }
                    JSONArray jSONArray = new JSONArray();
                    return jSONArray;
                }
                log.info("dmp\u67e5\u8be2\u7ef4\u5ea6\u5931\u8d25:{}", (Object)Optional.ofNullable(JSONObject.parseObject((String)((String)responseEntity.getBody()))).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
            }
            catch (Exception e2) {
                log.error("{}, \u8bf7\u6c42code\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{"dmp\u67e5\u8be2\u7ef4\u5ea6\u5931\u8d25", param, e2});
            }
            finally {
                MdcUtil.clear();
            }
            return new JSONArray();
        });
    }

    public CompletableFuture<JSONArray> timeOutFallback(Exception e) {
        log.error("dmp\u67e5\u8be2\u7ef4\u5ea6\u63a5\u53e3\u8c03\u7528\u8d85\u65f6\uff0c\u5df2\u964d\u7ea7\u5904\u7406");
        return CompletableFuture.supplyAsync(() -> new JSONArray());
    }
}

