/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class QuickChartGenerator {
    static final String targetPrefix = "https://quickchart.io/chart?c=";
    public static String test2 = "%7B%22type%22%3A%22line%22%2C%22data%22%3A%7B%22labels%22%3A%5B%222022%22%2C%222023%22%2C%222024%22%5D%2C%22datasets%22%3A%5B%7B%22label%22%3A%22\u534e\u5317\u5730\u533a%22%2C%22data%22%3A%5B8500%2C7225%2C9100%5D%2C%22borderColor%22%3A%22%234e79a7%22%2C%22backgroundColor%22%3A%22rgba(78%2C121%2C167%2C0.1)%22%7D%2C%7B%22label%22%3A%22\u534e\u4e1c\u5730\u533a%22%2C%22data%22%3A%5B10200%2C10650%2C11800%5D%2C%22borderColor%22%3A%22%2359a14f%22%2C%22backgroundColor%22%3A%22rgba(89%2C161%2C79%2C0.1)%22%7D%2C%7B%22label%22%3A%22\u534e\u5357\u5730\u533a%22%2C%22data%22%3A%5B7800%2C8650%2C9750%5D%2C%22borderColor%22%3A%22%239c755f%22%2C%22backgroundColor%22%3A%22rgba(156%2C117%2C95%2C0.1)%22%7D%5D%7D%2C%22options%22%3A%7B%22responsive%22%3Atrue%2C%22plugins%22%3A%7B%22legend%22%3A%7B%22position%22%3A%22top%22%7D%2C%22title%22%3A%7B%22display%22%3Atrue%2C%22text%22%3A%22AthenaNjTest%202022-2024%E5%B9%B4%E4%B8%BB%E8%A6%81%E5%8C%BA%E5%9F%9F%E8%90%A5%E6%94%B6%E8%B6%8B%E5%8A%BF%22%7D%7D%2C%22scales%22%3A%7B%22y%22%3A%7B%22beginAtZero%22%3Atrue%2C%22title%22%3A%7B%22display%22%3Atrue%2C%22text%22%3A%22%E8%90%A9%E6%8E%A5%20(%E4%B8%87%E5%85%83)%22%7D%7D%7D%7D%7D";
    public static String test = "{\n  \"type\": \"line\",\n  \"data\": {\n    \"labels\": [\"2022\", \"2023\", \"2024\"],\n    \"datasets\": [\n      {\n        \"label\": \"\u534e\u5317\u5730\u533a\",\n        \"data\": [8500, 7225, 9100],\n        \"borderColor\": \"#4e79a7\",\n        \"backgroundColor\": \"rgba(78,121,167,0.1)\"\n      },\n      {\n        \"label\": \"\u534e\u4e1c\u5730\u533a\",\n        \"data\": [10200, 10650, 11800],\n        \"borderColor\": \"#59a14f\",\n        \"backgroundColor\": \"rgba(89,161,79,0.1)\"\n      },\n      {\n        \"label\": \"\u534e\u5357\u5730\u533a\",\n        \"data\": [7800, 8650, 9750],\n        \"borderColor\": \"#9c755f\",\n        \"backgroundColor\": \"rgba(156,117,95,0.1)\"\n      }\n    ]\n  },\n  \"options\": {\n    \"responsive\": true,\n    \"plugins\": {\n      \"legend\": {\n        \"position\": \"top\"\n      },\n      \"title\": {\n        \"display\": true,\n        \"text\": \"AthenaNjTest 2022-2024\u5e74\u4e3b\u8981\u533a\u57df\u8425\u6536\u8d8b\u52bf\"\n      }\n    },\n    \"scales\": {\n      \"y\": {\n        \"beginAtZero\": true,\n        \"title\": {\n          \"display\": true,\n          \"text\": \"\u8425\u6536\uff08\u5343\u4e07\u5143\uff09\"\n        }\n      }\n    }\n  }\n}";
    public static JSONObject testJson = JSONObject.parseObject((String)test);

    public static String reGenerate(String url) {
        try {
            String param = QuickChartGenerator.urlReGenerate((String)url.replace("https://quickchart.io/chart?c=", ""));
            if (StringUtils.isEmpty((CharSequence)param)) {
                return "";
            }
            return "https://quickchart.io/chart?c=" + param;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String urlReGenerate(String param) {
        try {
            return QuickChartGenerator.generateQuickChartUrlParamFromJson((JSONObject)QuickChartGenerator.parseQuickChartParam((String)param));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String generateQuickChartUrlParam(String type, List<String> labels, JSONArray datasets, String title, JSONObject options) {
        JSONObject chartOptions;
        if (type == null || type.trim().isEmpty()) {
            throw new IllegalArgumentException("Chart type cannot be null or empty.");
        }
        if (labels == null || labels.isEmpty()) {
            throw new IllegalArgumentException("Labels list cannot be null or empty.");
        }
        if (datasets == null || datasets.isEmpty()) {
            throw new IllegalArgumentException("Datasets array cannot be null or empty.");
        }
        JSONObject data = new JSONObject();
        data.put("labels", labels);
        data.put("datasets", (Object)datasets);
        data.put("version", (Object)4);
        JSONObject jSONObject = chartOptions = options != null ? options : new JSONObject();
        if (title != null && !title.trim().isEmpty()) {
            JSONObject titleObject = new JSONObject();
            titleObject.put("display", (Object)true);
            titleObject.put("text", (Object)title);
            chartOptions.put("title", (Object)titleObject);
        }
        JSONObject chartConfig = new JSONObject();
        chartConfig.put("type", (Object)type);
        chartConfig.put("data", (Object)data);
        if (!chartOptions.isEmpty()) {
            chartConfig.put("options", (Object)chartOptions);
        }
        String jsonString = chartConfig.toJSONString();
        try {
            return URLEncoder.encode(jsonString, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String generateQuickChartUrlParamFromJson(JSONObject chartConfigJson) {
        if (chartConfigJson == null) {
            throw new IllegalArgumentException("Input JSON object cannot be null.");
        }
        String type = chartConfigJson.getString("type");
        JSONObject dataObject = chartConfigJson.getJSONObject("data");
        JSONArray datasetsArray = dataObject.getJSONArray("datasets");
        List labels = dataObject.getJSONArray("labels").toJavaList(String.class);
        String title = null;
        JSONObject options = null;
        if (chartConfigJson.containsKey((Object)"options") && (options = chartConfigJson.getJSONObject("options")).containsKey((Object)"title")) {
            title = options.getJSONObject("title").getString("text");
        }
        return QuickChartGenerator.generateQuickChartUrlParam((String)type, (List)labels, (JSONArray)datasetsArray, title, (JSONObject)options);
    }

    private static boolean isUrlEncoded(String s) {
        return s != null && s.contains("%");
    }

    public static JSONObject parseQuickChartParam(String quickChartParam) {
        if (quickChartParam == null || quickChartParam.trim().isEmpty()) {
            System.err.println("Input parameter string is null or empty.");
            return null;
        }
        String decodedString = quickChartParam;
        if (QuickChartGenerator.isUrlEncoded((String)quickChartParam)) {
            try {
                decodedString = URLDecoder.decode(quickChartParam, StandardCharsets.UTF_8.toString());
                System.err.println(decodedString);
            }
            catch (Exception e) {
                System.err.println("Failed to URL decode the string: " + e.getMessage());
                return null;
            }
        }
        String validJsonString = decodedString.replace('\'', '\"');
        try {
            return JSONObject.parseObject((String)validJsonString);
        }
        catch (Exception e) {
            System.err.println("Failed to parse JSON string. Please check the format: " + e.getMessage());
            return null;
        }
    }

    public static void main(String[] args) {
        JSONObject params = QuickChartGenerator.parseQuickChartParam((String)test2);
        String encodedParamFromJson = QuickChartGenerator.generateQuickChartUrlParamFromJson((JSONObject)params);
        System.out.println("\n---");
        System.out.println("\u793a\u4f8b (\u4f7f\u7528 JSON \u5bf9\u8c61) URL: \nhttps://quickchart.io/chart?c=" + encodedParamFromJson);
    }
}

