/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.ResultBean;
import com.digiwin.chatbi.beans.dtos.chart.DataSetPushDto;
import com.digiwin.chatbi.beans.dtos.chart.HabitualKnowledgeDto;
import com.digiwin.chatbi.beans.dtos.chart.NounKnowledgeDto;
import com.digiwin.chatbi.beans.dtos.chart.TableRelationsPushDto;
import com.digiwin.chatbi.beans.pojos.AppStandardWordII;
import com.digiwin.chatbi.beans.pojos.KMData;
import com.digiwin.chatbi.beans.pojos.ReportDto;
import com.digiwin.chatbi.beans.pojos.StandardWordData;
import com.digiwin.chatbi.beans.pojos.StandardWordDataII;
import com.digiwin.chatbi.beans.pojos.vector.DictioneryWord;
import com.digiwin.chatbi.common.exception.BussinessException;
import com.digiwin.chatbi.service.OperateESService;
import com.digiwin.chatbi.service.SyncDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"scrumbi"})
@Api(value="ScrumBIDataPushController", tags={"ScrumBIDataPushController"})
public class ScrumBIDataPushController {
    private static final Logger log = LoggerFactory.getLogger(ScrumBIDataPushController.class);
    @Resource
    private OperateESService operateESService;
    @Resource
    private SyncDataService syncDataService;
    @Value(value="${push.words.size:1000}")
    private Integer push_words_size;

    @PostMapping(value={"/pushKMDatas"})
    @ApiOperation(value="\u63a8\u9001KM\u6570\u636e")
    public ResultBean<Void> pushKMDatas(@RequestBody List<KMData> kmData) {
        this.operateESService.pushKMDatas(kmData);
        return ResultBean.ok();
    }

    @PostMapping(value={"/pushKMDatas/V2"})
    @ApiOperation(value="\u63a8\u9001KM\u6570\u636eV2")
    public ResultBean<Void> pushKMDatasV2(@RequestBody List<KMData> kmData) {
        this.operateESService.pushKMDatasV2(kmData);
        return ResultBean.ok();
    }

    @PostMapping(value={"/pushStandardWordDatas"})
    @ApiOperation(value="\u5185\u90e8excel\u63a8\u9001\u6807\u51c6\u8bcd")
    public ResultBean<Void> pushStandardWordDatas(@RequestBody StandardWordData kmData) {
        this.operateESService.pushStandardWordData(kmData);
        return ResultBean.ok();
    }

    @PostMapping(value={"/pushStandardWord"})
    @ApiOperation(value="\u5bf9\u5916\u7528\u6237\u63a8\u9001\u6807\u51c6\u8bcd")
    public ResultBean<Void> pushWordDatas(@RequestBody StandardWordDataII standardWordDataII, @RequestHeader(value="digi-middleware-auth-user") String token) {
        long start = System.currentTimeMillis();
        if (Objects.isNull(standardWordDataII)) {
            log.info("pushWordDatas,standardWordDataII\u4e3a\u7a7a");
            return ResultBean.ok();
        }
        if (CollectionUtils.isEmpty((Collection)standardWordDataII.getStandardWordDatas())) {
            log.info("pushWordDatas,standardWordDataII.getStandardWordDatas\u4e3a\u7a7a");
            return ResultBean.ok();
        }
        if (Objects.nonNull(standardWordDataII) && CollectionUtils.isNotEmpty((Collection)standardWordDataII.getStandardWordDatas()) && standardWordDataII.getStandardWordDatas().size() < 50) {
            log.info("ScrumBIDataPushController#pushWordDatas,token:{}\uff0c standardWordDataII: {}", (Object)token, (Object)standardWordDataII);
        } else if (Objects.nonNull(standardWordDataII) && CollectionUtils.isNotEmpty((Collection)standardWordDataII.getStandardWordDatas()) && standardWordDataII.getStandardWordDatas().size() >= 50) {
            log.info("ScrumBIDataPushController#pushWordDatas,token:{}\uff0c \u6570\u636e\u957f\u5ea6: {}\uff0c\u957f\u5ea6{}\u6ee1\u8db3\u9884\u671f", new Object[]{token, standardWordDataII.getStandardWordDatas().size(), this.push_words_size.intValue() == standardWordDataII.getStandardWordDatas().size() ? "" : "\u4e0d"});
        } else {
            log.info("ScrumBIDataPushController#pushWordDataswe\u4e3a\u7a7a,token:{}\uff0c standardWordDataII: {}", (Object)token, (Object)standardWordDataII.getStandardWordDatas());
        }
        this.operateESService.pushStandardWordDataII(standardWordDataII, token, false);
        long end = System.currentTimeMillis();
        log.info("pushWordDatas\u63a5\u53e3\u8017\u65f6\uff1a{}ms", (Object)(end - start));
        return ResultBean.ok();
    }

    @PostMapping(value={"/sync/pushStandardWord"})
    @ApiOperation(value="\u5bf9\u5916\u7528\u6237\u63a8\u9001\u6807\u51c6\u8bcd\u540c\u6b65")
    public ResultBean<Void> pushWordDatasSync(@RequestBody StandardWordDataII standardWordDataII, @RequestHeader(value="digi-middleware-auth-user") String token) {
        long start = System.currentTimeMillis();
        if (Objects.isNull(standardWordDataII)) {
            log.info("pushWordDatasSync,standardWordDataII\u4e3a\u7a7a");
            return ResultBean.ok();
        }
        if (CollectionUtils.isEmpty((Collection)standardWordDataII.getStandardWordDatas())) {
            log.info("pushWordDatasSync,standardWordDataII.getStandardWordDatas\u4e3a\u7a7a");
            return ResultBean.ok();
        }
        if (Objects.nonNull(standardWordDataII) && CollectionUtils.isNotEmpty((Collection)standardWordDataII.getStandardWordDatas()) && standardWordDataII.getStandardWordDatas().size() < 50) {
            log.info("ScrumBIDataPushController#syncpushWordDatas,token:{}\uff0c standardWordDataII: {}", (Object)token, (Object)standardWordDataII);
        } else if (Objects.nonNull(standardWordDataII) && CollectionUtils.isNotEmpty((Collection)standardWordDataII.getStandardWordDatas()) && standardWordDataII.getStandardWordDatas().size() >= 50) {
            log.info("ScrumBIDataPushController#syncpushWordDatas,token:{}\uff0c \u6570\u636e\u957f\u5ea6: {}\uff0c\u957f\u5ea6{}\u6ee1\u8db3\u9884\u671f", new Object[]{token, standardWordDataII.getStandardWordDatas().size(), this.push_words_size.intValue() == standardWordDataII.getStandardWordDatas().size() ? "" : "\u4e0d"});
        } else {
            log.info("ScrumBIDataPushController#syncpushWordDataswe\u4e3a\u7a7a,token:{}\uff0c standardWordDataII: {}", (Object)token, (Object)standardWordDataII.getStandardWordDatas());
        }
        this.operateESService.pushStandardWordDataII(standardWordDataII, token, true);
        long end = System.currentTimeMillis();
        log.info("syncpushWordDatas\u63a5\u53e3\u8017\u65f6\uff1a{}ms", (Object)(end - start));
        return ResultBean.ok();
    }

    @PostMapping(value={"/pushAppStandardWord"})
    @ApiOperation(value="\u63a8\u9001\u5e94\u7528\u7ea7\u6807\u51c6\u8bcd")
    public ResultBean<Void> pushAppStandardWord(@RequestBody List<AppStandardWordII> appStandardWordIIS) {
        log.info("ScrumBIDataPushController#pushAppStandardWord appStandardWordIIS: {}", appStandardWordIIS);
        this.operateESService.pushAppStandardWord(appStandardWordIIS);
        return ResultBean.ok();
    }

    @PostMapping(value={"/pushDictionary"})
    @ApiOperation(value="\u63a8\u9001\u5b57\u5178")
    public ResultBean<Void> pushDictionary(@RequestBody List<DictioneryWord> dictioneryWords) {
        log.info("ScrumBIDataPushController#pushDictionary dictioneryWords: {}", dictioneryWords);
        this.operateESService.pushDictionary(dictioneryWords);
        return ResultBean.ok();
    }

    @PostMapping(value={"/pushReport"})
    @ApiOperation(value="\u63a8\u9001\u62a5\u8868")
    public ResultBean<Void> pushReport(@RequestBody ReportDto reportDto) {
        log.info("ScrumBIDataPushController#pushReport reportDto: {}", (Object)reportDto);
        this.operateESService.pushReport(reportDto);
        return ResultBean.ok();
    }

    @PostMapping(value={"/pushIndicatorData"})
    @ApiOperation(value="\u63a5\u6536\u6307\u6807/1.0\u6570\u636e\u96c6\u63a8\u9001\u63a5\u53e3")
    public ResultBean<Void> pushIndicatorData(@RequestBody JSONObject jsonObject, @RequestHeader(value="token") String token, @RequestHeader(value="locale", required=false) String locale) {
        log.info("ScrumBIDataPushController#pushIndicatorData JSONObject: {}", (Object)JSONObject.toJSONString((Object)jsonObject));
        try {
            this.operateESService.pushIndicatorDataAndDataSetV1(jsonObject, token, locale);
        }
        catch (Exception e) {
            log.error("pushIndicatorData\u5f02\u5e38\uff0c{}", (Throwable)e);
            return ResultBean.fail((String)e.getMessage());
        }
        return ResultBean.ok();
    }

    @PostMapping(value={"/addApplicationName"})
    @ApiOperation(value=" \u65b0\u589e\u5e94\u7528\u540d\u79f0")
    public ResultBean<Void> addApplicationName() throws Exception {
        this.syncDataService.addApplicationName();
        return ResultBean.ok();
    }

    @PostMapping(value={"/dataSet/push"})
    @ApiOperation(value="\u63a5\u6536\u6570\u636e\u96c6\u63a8\u9001\u63a5\u53e3")
    public ResultBean<Void> pushDataSet(@RequestBody List<DataSetPushDto> dataSetPushDtos, @RequestHeader(value="token") String token, @RequestHeader(value="routerKey") String routerKey, @RequestHeader(value="locale", required=false) String locale) throws BussinessException {
        log.info("ScrumBIDataPushController#pushDataSetV2 dataSetPushDtos: {}", (Object)JSONObject.toJSONString(dataSetPushDtos));
        try {
            this.operateESService.pushDataSet(dataSetPushDtos, token, locale, routerKey);
        }
        catch (BussinessException e) {
            log.error("pushDataSetV2\u5f02\u5e38\uff0c{}", (Throwable)e);
            return ResultBean.fail((String)e.getMessage());
        }
        return ResultBean.ok();
    }

    @PostMapping(value={"/nounKnowledge/push"})
    @ApiOperation(value="\u63a5\u6536\u540d\u8bcd\u77e5\u8bc6\u63a8\u9001\u63a5\u53e3")
    public ResultBean<Void> pushNounKnowledge(@RequestBody List<NounKnowledgeDto> knowledges) {
        log.info("ScrumBIDataPushController#pushNounKnowledge knowledges: {}", (Object)JSONObject.toJSONString(knowledges));
        this.operateESService.pushNounKnowledge(knowledges);
        return ResultBean.ok();
    }

    @PostMapping(value={"/habitualKnowledge/push"})
    @ApiOperation(value="\u63a5\u6536\u4e60\u60ef\u77e5\u8bc6\u63a8\u9001\u63a5\u53e3")
    public ResultBean<Void> pushHabitualKnowledge(@RequestBody List<HabitualKnowledgeDto> knowledges) {
        log.info("ScrumBIDataPushController#pushHabitualKnowledge knowledges: {}", (Object)JSONObject.toJSONString(knowledges));
        this.operateESService.pushHabitualKnowledge(knowledges);
        return ResultBean.ok();
    }

    @PostMapping(value={"/tableRelationships/push"})
    @ApiOperation(value="\u8868\u5173\u7cfb\u5b58\u50a8")
    public ResultBean<Void> pushTableRelationships(@RequestBody TableRelationsPushDto tableRelationsPushDto) {
        log.info("ScrumBIDataPushController#pushTableRelationships : {}", (Object)JSONObject.toJSONString((Object)tableRelationsPushDto));
        if (CollectionUtils.isEmpty((Collection)tableRelationsPushDto.getRelations())) {
            this.syncDataService.deleteAllRelations(tableRelationsPushDto.getApplicationCode(), tableRelationsPushDto.getVersion());
            return ResultBean.ok();
        }
        tableRelationsPushDto.getRelations().forEach(tableRelationshipsDto -> {
            tableRelationshipsDto.setApplicationCode(tableRelationsPushDto.getApplicationCode());
            tableRelationshipsDto.setVersion(tableRelationsPushDto.getVersion());
        });
        this.syncDataService.pushTableRelationships(tableRelationsPushDto.getRelations());
        tableRelationsPushDto.getAfterBFS().forEach(tableRelationsDto -> {
            tableRelationsDto.setApplicationCode(tableRelationsPushDto.getApplicationCode());
            tableRelationsDto.setVersion(tableRelationsPushDto.getVersion());
        });
        this.syncDataService.pushTableRelations(tableRelationsPushDto.getAfterBFS());
        return ResultBean.ok();
    }
}

