/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.boostEngine.chunk.model;

import com.alibaba.fastjson.JSON;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.rule.Rule;
import com.digiwin.chatbi.reasoning.boostEngine.chunk.factor.rule.RuleType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.regex.Matcher;

public class Token {
    private String token;
    private int start;
    private int end;
    @JsonIgnore
    private Matcher matcher;
    @JsonIgnore
    private Rule rule;
    private String tokenType;
    private JSON parseContent;

    public Token(String token, int start, int end) {
        this.token = token;
        this.start = start;
        this.end = end;
        this.tokenType = RuleType.MANUAL.toString();
    }

    public Token(String token, String tokenType, int start, int end) {
        this.token = token;
        this.start = start;
        this.end = end;
        this.tokenType = tokenType;
    }

    public Token(String token, Matcher matcher, Rule rule, int start, int end) {
        this.token = token;
        this.start = start;
        this.matcher = matcher;
        this.end = end;
        this.rule = rule;
        this.tokenType = rule.getRuleType().toString();
    }

    public String toString() {
        return "Token: " + this.token + " Start: " + this.start + " End: " + this.end + " tokenType: " + this.tokenType + " parserType: " + (null != this.getRule() ? this.getRule().getParserType() : "none") + " content: " + this.parseContent;
    }

    public static Token merge(Token t1, Token t2) {
        if (t1.end == t2.start && RuleType.MANUAL.is(t1.tokenType) && RuleType.MANUAL.is(t2.tokenType)) {
            return new Token(t1.token + t2.token, t1.start, t2.end);
        }
        return null;
    }

    public String getToken() {
        return this.token;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public Rule getRule() {
        return this.rule;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public JSON getParseContent() {
        return this.parseContent;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    @JsonIgnore
    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    @JsonIgnore
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setParseContent(JSON parseContent) {
        this.parseContent = parseContent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        if (this.getEnd() != other.getEnd()) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Matcher this$matcher = this.getMatcher();
        Matcher other$matcher = other.getMatcher();
        if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
            return false;
        }
        Rule this$rule = this.getRule();
        Rule other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        String this$tokenType = this.getTokenType();
        String other$tokenType = other.getTokenType();
        if (this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType)) {
            return false;
        }
        JSON this$parseContent = this.getParseContent();
        JSON other$parseContent = other.getParseContent();
        return !(this$parseContent == null ? other$parseContent != null : !this$parseContent.equals(other$parseContent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Token;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStart();
        result = result * 59 + this.getEnd();
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Matcher $matcher = this.getMatcher();
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        Rule $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        String $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        JSON $parseContent = this.getParseContent();
        result = result * 59 + ($parseContent == null ? 43 : $parseContent.hashCode());
        return result;
    }
}

