/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.constant;

import com.digiwin.chatbi.client.GPT_MODEL;
import com.digiwin.chatbi.reasoning.pipeline.Pipeline;
import com.digiwin.chatbi.reasoning.pipeline.PipelineFactory;
import java.util.function.Function;

public enum Strategy {
    SPEED(PipelineFactory.V1_PIPELINE, GPT_MODEL.GPT3_5_TURBO),
    BALANCE(PipelineFactory.V2_PIPELINE, PipelineFactory.V2_PIPELINE_MULTI, GPT_MODEL.GPT3_5_TURBO, message -> message),
    SUPER_ACCURATE(PipelineFactory.V2_PIPELINE, GPT_MODEL.GPT4, message -> message),
    FEW_SHOTS(PipelineFactory.V2_PIPELINE, GPT_MODEL.GPT4_TURBO, message -> message),
    DEMO(PipelineFactory.DEMO_PIPELINE, GPT_MODEL.GPT3_5_TURBO),
    LITE(PipelineFactory.LITE_PIPELINE, GPT_MODEL.GPT3_5_TURBO, message -> message),
    LITE_V2(PipelineFactory.LITE_PIPELINE_V2, GPT_MODEL.GPT3_5_TURBO, message -> message),
    METRIC(PipelineFactory.METRIC_PIPELINE, GPT_MODEL.GPT4, message -> message),
    METRIC_STREAM(PipelineFactory.METRIC_STREAM_PIPELINE, GPT_MODEL.GPT4, message -> message),
    METRIC_SCENE_MIX(PipelineFactory.METRIC_SCENE_MIX_PIPELINE, GPT_MODEL.GPT4, message -> message),
    METRIC_SCENE_MIX_4_VALIDATION(PipelineFactory.VALIDATION_PIPELINE, GPT_MODEL.GPT4, message -> message),
    DATASET(PipelineFactory.DATASET_PIPELINE, GPT_MODEL.GPT4, message -> message),
    FLUCTUATE(PipelineFactory.FLUCTUATE_PIPELINE, GPT_MODEL.GPT4, message -> message),
    DATA_ATTRIBUTION(PipelineFactory.DATA_ATTRIBUTION_PIPELINE, GPT_MODEL.GPT4, message -> message),
    DATA_ATTRIBUTION_REPORT(PipelineFactory.DATA_ATTRIBUTION_REPORT_PIPELINE, GPT_MODEL.GPT4, message -> message),
    QUESTION_PLANNING(PipelineFactory.QUESTION_PLANNING_PIPELINE, GPT_MODEL.GPT4, message -> message),
    QUESTION_REGENARATE_REQ(PipelineFactory.QUESTION_REGENARATE_REQ_PIPELINE, GPT_MODEL.GPT4, message -> message),
    PPT_GENERATE(PipelineFactory.PPT_GENERATE_PIPELINE, GPT_MODEL.GPT4, message -> message),
    INTENTION_CONFIRM(PipelineFactory.INTENTION_CONFIRM_PIPELINE, GPT_MODEL.GPT4, message -> message),
    REPORT_CREATE(PipelineFactory.REPORT_CREATE_PIPELINE, GPT_MODEL.GPT4, message -> message),
    CHART_PLAN(PipelineFactory.CHART_PLAN_PIPELINE, GPT_MODEL.GPT4, message -> message),
    LAYOUT_DESIGN(PipelineFactory.LAYOUT_DESIGN_PIPELINE, GPT_MODEL.GPT4, message -> message);

    private final Pipeline pipeline;
    private final Pipeline multiQuestionPipeline;
    private final GPT_MODEL gptModel;
    private Function<String, String> messageBooster = message -> message;

    private Strategy(Pipeline pipeline, GPT_MODEL gptModel) {
        this.pipeline = pipeline;
        this.multiQuestionPipeline = null;
        this.gptModel = gptModel;
    }

    private Strategy(Pipeline pipeline, GPT_MODEL gptModel, Function<String, String> messageBooster) {
        this.pipeline = pipeline;
        this.multiQuestionPipeline = null;
        this.gptModel = gptModel;
        this.messageBooster = messageBooster;
    }

    private Strategy(Pipeline pipeline, Pipeline multiQuestionPipeline, GPT_MODEL gptModel, Function<String, String> messageBooster) {
        this.pipeline = pipeline;
        this.multiQuestionPipeline = multiQuestionPipeline;
        this.gptModel = gptModel;
        this.messageBooster = messageBooster;
    }

    public String boostMessage(String message) {
        return (String)this.messageBooster.apply(message);
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public Pipeline getMultiQuestionPipeline() {
        return this.multiQuestionPipeline;
    }

    public GPT_MODEL getGptModel() {
        return this.gptModel;
    }

    public Function<String, String> getMessageBooster() {
        return this.messageBooster;
    }
}

