/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.search.EsQueryExecutor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCotExampleExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(AutoCotExampleExecutor.class);
    private static final String INDEX_NAME = "cot_index_003";
    private static final String DSL = "MATCHCOT";

    public Output doProcess(JSONObject context) {
        Map<String, JSONObject> schemaMap = context.getJSONArray("schemas").stream().map(schema -> (JSONObject)schema).collect(Collectors.toMap(schema -> schema.getString("datasourceId"), schema -> schema));
        String datasourceId = context.getJSONArray("schemas").stream().map(schema -> ((JSONObject)schema).getString("datasourceId")).reduce((x, y) -> "\"" + x + "\", \"" + y + "\"").orElse("\"\"").replace("\"\"", "\"");
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("use_question", (Object)question);
        jsonObject.put("datasourceId", (Object)datasourceId.replace("\"\"", "\""));
        JSONObject searchResult = ((EsQueryExecutor)SpringContextUtil.getBean(EsQueryExecutor.class)).queryByDslTemplate(INDEX_NAME, DSL, (Map)jsonObject);
        List cots = searchResult.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList());
        String examples = cots.stream().collect(Collectors.groupingBy(cot -> cot.getString("datasourceId"))).entrySet().stream().filter(entry -> schemaMap.containsKey(entry.getKey())).map(entry -> "<\u793a\u4f8b\u8868\u7ed3\u6784>\n" + ((JSONObject)schemaMap.get(entry.getKey())).toJSONString() + "\n" + ((List)entry.getValue()).stream().map(example -> "##\u793a\u4f8b##\n  -\u7528\u6237\u8bed\u53e5:\n    " + example.getString("question") + "\n  -\u8f93\u51fa:\n    " + example.getString("response")).reduce((x, y) -> x + "\n" + y).orElse("")).reduce((x, y) -> x + "\n" + y).orElse("");
        return Output.through((String)"examples", (Object)examples);
    }
}

