/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.enums.ProductVersionEnum;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildSentencesWithoutMetricExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(BuildSentencesWithoutMetricExecutor.class);

    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_metric");
    }

    public Output doProcess(JSONObject context) {
        ArrayList<String> sentences = new ArrayList<String>();
        try {
            String name = "none_metric_suggested_queries";
            String productVersion = ((Question)context.getObject("question", Question.class)).getProductVersion();
            if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.STANDARD_EDITION.getCode().equals(productVersion)) {
                name = name + "_V1";
            } else if (context.containsKey((Object)"scelect_dataSet") && ProductVersionEnum.FLAGSHIP_VERSION.getCode().equals(productVersion)) {
                name = name + "_V2";
            }
            if (!Objects.isNull(context.getJSONObject(name))) {
                JSONArray questions = context.getJSONObject(name).getJSONArray("questions");
                for (Object o : questions) {
                    if (!Objects.nonNull(o)) continue;
                    sentences.add(o.toString());
                }
            }
        }
        catch (Exception e) {
            log.error("\u65e0\u6307\u6807\u83b7\u53d6\u731c\u4f60\u60f3\u95ee\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return Output.finish((String)"sentences", sentences).keep("success", (Object)false);
    }
}

