/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.dtos.LogCheckDto;
import com.digiwin.chatbi.beans.pojos.Question;
import com.digiwin.chatbi.common.util.LogUtils;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class SearchDimensionSourceExecutor
implements Executor {
    public boolean onCondition(JSONObject context) {
        return context.containsKey((Object)"scelect_scene") || context.containsKey((Object)"scelect_scene_metric_mix");
    }

    public Output doProcess(JSONObject context) {
        List<LogCheckDto> logCheckDtos = Objects.isNull(context.get((Object)"logCheckDtos")) ? new CopyOnWriteArrayList() : (List)context.get((Object)"logCheckDtos");
        String question = ((Question)context.getObject("question", Question.class)).getMessage().replace("explain:", "");
        List originalDimensionWords = (List)context.get((Object)"originalDimensionWords");
        JSONObject input = new JSONObject();
        input.put("question", (Object)question);
        input.put("originalDimensionWords", (Object)originalDimensionWords);
        List<Object> jsonObjects = new ArrayList();
        List standardDictionarys = Optional.ofNullable(Retrieve.DICTIONARY.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
        HashMap standardDictionarysMap = new HashMap();
        standardDictionarys.forEach(standardDictionary -> {
            String key = standardDictionary.getString("applicationCode") + standardDictionary.getString("version");
            String name = standardDictionary.getString("name");
            if (standardDictionarysMap.containsKey(key)) {
                ((List)standardDictionarysMap.get(key)).add(name);
            } else {
                ArrayList<String> names = new ArrayList<String>();
                names.add(name);
                standardDictionarysMap.put(key, names);
            }
        });
        jsonObjects = Optional.ofNullable(Retrieve.DIMENSION.retrieveQuestion(question, context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> {
            JSONObject jsonObject = new JSONObject();
            String title = ((JSONObject)hit).getJSONObject("_source").getOrDefault((Object)"title", (Object)"").toString();
            jsonObject.put("title", (Object)title);
            String name = ((JSONObject)hit).getJSONObject("_source").getOrDefault((Object)"name", (Object)"").toString();
            jsonObject.put("name", (Object)name);
            if (CollectionUtils.isNotEmpty((Collection)originalDimensionWords)) {
                JSONArray synonymJsonArray = originalDimensionWords.stream().filter(odw -> title.equals(odw.getString("standard_name"))).findFirst().orElse(new JSONObject()).getJSONArray("synonyms");
                jsonObject.put("Synonyms_aliases", (Object)synonymJsonArray);
            }
            return jsonObject;
        }).filter(a -> {
            List standardNames = (List)standardDictionarysMap.get(a.getString("applicationCode") + a.getString("version"));
            return CollectionUtils.isNotEmpty((Collection)standardNames) && standardNames.contains(a.getString("name"));
        }).collect(Collectors.toList())).orElse(new ArrayList());
        jsonObjects = jsonObjects.stream().collect(Collectors.toMap(json -> json.getString("name"), json -> json, (existing, replacement) -> {
            JSONArray jsonArray;
            JSONArray jSONArray = jsonArray = CollectionUtils.isEmpty((Collection)existing.getJSONArray("Synonyms_aliases")) ? new JSONArray() : existing.getJSONArray("Synonyms_aliases");
            if (CollectionUtils.isNotEmpty((Collection)replacement.getJSONArray("Synonyms_aliases"))) {
                jsonArray.addAll((Collection)replacement.getJSONArray("Synonyms_aliases"));
            }
            existing.put("Synonyms_aliases", jsonArray.stream().distinct().collect(Collectors.toList()));
            return existing;
        })).entrySet().stream().map(e -> (JSONObject)e.getValue()).collect(Collectors.toList());
        ArrayList applicationCodes = Objects.isNull(context.getObject("applicationCodes", List.class)) ? new ArrayList() : (List)context.getObject("applicationCodes", List.class);
        String version = context.getString("version");
        List allDimension = Optional.ofNullable(Retrieve.DIMENSION_ALL.retrieveSentenceByApplicationCodes(applicationCodes, version, new String[]{"title", "name", "applicationCode", "version"})).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("title", ((JSONObject)hit).getJSONObject("_source").getOrDefault((Object)"title", (Object)""));
            jsonObject.put("name", ((JSONObject)hit).getJSONObject("_source").getOrDefault((Object)"name", (Object)""));
            jsonObject.put("applicationCode", ((JSONObject)hit).getJSONObject("_source").getOrDefault((Object)"applicationCode", (Object)""));
            jsonObject.put("version", ((JSONObject)hit).getJSONObject("_source").getOrDefault((Object)"version", (Object)""));
            return jsonObject;
        }).filter(a -> {
            List standardNames = (List)standardDictionarysMap.get(a.getString("applicationCode") + a.getString("version"));
            return CollectionUtils.isNotEmpty((Collection)standardNames) && standardNames.contains(a.getString("name"));
        }).collect(Collectors.toList())).orElse(new ArrayList());
        if (CollectionUtils.isEmpty(jsonObjects)) {
            allDimension.forEach(dimension -> {
                dimension.remove((Object)"applicationCode");
                dimension.remove((Object)"version");
            });
            jsonObjects.addAll(allDimension);
            jsonObjects = jsonObjects.stream().collect(Collectors.collectingAndThen(Collectors.toMap(jsonObj -> jsonObj.getString("name"), jsonObj -> jsonObj, (existing, replacement) -> CollectionUtils.isNotEmpty((Collection)existing.getJSONArray("Synonyms_aliases")) ? existing : replacement), map -> new ArrayList(map.values())));
        }
        LogCheckDto logCheckDto = new LogCheckDto();
        if (CollectionUtils.isNotEmpty(jsonObjects)) {
            JSONObject result = new JSONObject();
            List jsonObjects1 = JSON.parseArray((String)jsonObjects.toString(), JSONObject.class);
            result.put("dimensions", (Object)jsonObjects1);
            result.put("allDimensions", new ArrayList(new HashSet(allDimension)));
            logCheckDto.buildParams("SearchDimensionSource", LogUtils.SUCCESS, input.toJSONString(), result.toJSONString(), "");
        } else {
            logCheckDto.buildParams("SearchDimensionSource", LogUtils.WARING, input.toJSONString(), "\u6839\u636e\u95ee\u53e5\u67e5\u4e0d\u5230\u4efb\u4f55\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u540c\u4e49\u8bcd", "1.\u8fdb\u5165\u573a\u666f\u914d\u7f6e\u754c\u9762\uff0c\u67e5\u770b\u662f\u5426\u5df2\u914d\u7f6e\u95ee\u53e5\u4e2d\u7684\u7ef4\u5ea6\u3002\n2.\u82e5\u672a\u914d\u7f6e\uff0c\u6dfb\u52a0\u7ef4\u5ea6\u4fe1\u606f\u3002\n3.\u914d\u7f6e\u7ef4\u5ea6\u7684\u540c\u4e49\u8bcd\u3002\n4.\u8fdb\u884c\u53d1\u7248\u5207\u7248\u64cd\u4f5c\uff0c\u82e5\u6709\u95ee\u9898\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
        }
        logCheckDtos.add(logCheckDto);
        return Output.through((String)"dimensions", jsonObjects).keep("allDimensions", new ArrayList(new HashSet(allDimension))).keep("logCheckDtos", logCheckDtos);
    }
}

