/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.pojos.QuestionLite;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.IamService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchHistoryMessage4LiteExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchHistoryMessage4LiteExecutor.class);

    public Output doProcess(JSONObject context) {
        String userToken = ((QuestionLite)context.getObject("question", QuestionLite.class)).getToken();
        String routerKey = ((QuestionLite)context.getObject("question", QuestionLite.class)).getRouterKey();
        String sessionId = ((QuestionLite)context.getObject("question", QuestionLite.class)).getSessionId();
        String asaCode = ((QuestionLite)context.getObject("question", QuestionLite.class)).getAsaCode();
        List jsonObjects = null;
        StringBuilder bf = new StringBuilder("-\u7528\u6237\u6700\u8fd1\u51e0\u8f6e\u4ea4\u4e92\u4fe1\u606f: \" \"\u3002");
        bf.append("\n").append("-\u7528\u6237\u8bed\u53e5=\"").append(((QuestionLite)context.getObject("question", QuestionLite.class)).getMessage().replace("explain:", "")).append("\"");
        boolean isMultiDialogue = ((QuestionLite)context.getObject("question", QuestionLite.class)).isMultiDialogue();
        if (!isMultiDialogue) {
            return Output.through().keep("multi_question", (Object)bf);
        }
        try {
            IamService bean = (IamService)SpringContextUtil.getBean(IamService.class);
            jsonObjects = bean.getUserHistoryMessage(userToken, routerKey, sessionId, asaCode);
        }
        catch (Exception e) {
            log.error("\u5386\u53f2\u6570\u636e\u67e5\u8be2\u5931\u8d25");
            return Output.through().keep("multi_question", (Object)bf);
        }
        if (CollectionUtils.isEmpty((Collection)jsonObjects)) {
            return Output.through().keep("multi_question", (Object)bf);
        }
        StringBuilder stringBuilder = new StringBuilder("-\u7528\u6237\u6700\u8fd1\u51e0\u8f6e\u4ea4\u4e92\u4fe1\u606f:");
        try {
            jsonObjects = this.removeGuideChose(jsonObjects);
            if (CollectionUtils.isNotEmpty((Collection)jsonObjects)) {
                for (int i = 0; i < jsonObjects.size(); ++i) {
                    stringBuilder.append("\n\t").append(jsonObjects.size() - i).append(".\"");
                    String question = ((JSONObject)jsonObjects.get(i)).getJSONObject("msgBody").getString("question");
                    if (StringUtils.isBlank((CharSequence)question)) {
                        question = ((JSONObject)jsonObjects.get(i)).getJSONObject("msgBody").getString("scrumbiQuestion");
                    }
                    stringBuilder.append(question);
                    String questionUnderstand = ((JSONObject)jsonObjects.get(i)).getJSONObject("msgBody").getString("questionUnderstand");
                    if (StringUtils.isNotEmpty((CharSequence)questionUnderstand)) {
                        stringBuilder.append("\"").append(":\"").append(questionUnderstand);
                    } else {
                        String prompt = ((JSONObject)jsonObjects.get(i)).getJSONObject("msgBody").getString("prompt");
                        if (StringUtils.isNotEmpty((CharSequence)prompt)) {
                            stringBuilder.append("\"").append(":\"").append(prompt);
                        }
                    }
                    if (i == jsonObjects.size() - 1) {
                        stringBuilder.append("\"\u3002");
                        continue;
                    }
                    stringBuilder.append("\",");
                }
            }
        }
        catch (Exception e) {
            log.error("lite\u7248\u5386\u53f2\u6570\u636e\u8f6c\u6362JSON\u5931\u8d25", (Throwable)e);
        }
        String question = ((QuestionLite)context.getObject("question", QuestionLite.class)).getMessage().replace("explain:", "");
        stringBuilder.append("\n").append("\u7528\u6237\u8bed\u53e5=\"").append(question).append("\"");
        log.info("gpt\u591a\u8f6e\u95ee\u53e5\u62fc\u63a5\u7ed3\u679c\uff1a{}", (Object)stringBuilder);
        return Output.through((String)"multi_question", (Object)stringBuilder);
    }

    private List<JSONObject> removeGuideChose(List<JSONObject> jsonObjects) {
        ArrayList<JSONObject> newList = new ArrayList<JSONObject>();
        for (JSONObject jsonObject : jsonObjects) {
            Boolean isGuideChose = jsonObject.getJSONObject("msgBody").getBoolean("getMessageInfo");
            if (isGuideChose != null && isGuideChose.booleanValue() || !jsonObject.getString("msgType").equals("CUSTOM")) continue;
            newList.add(jsonObject);
        }
        return newList;
    }
}

