/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.reasoning.retrieve.Retrieve;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.init.ResourceReader;

public class SearchReportExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchReportExecutor.class);

    public Output doProcess(JSONObject context) {
        List reports = Optional.ofNullable(Retrieve.REPORT.retrieve(context)).map(temps -> temps.getJSONObject("hits").getJSONArray("hits").stream().map(hit -> ((JSONObject)hit).getJSONObject("_source")).collect(Collectors.toList())).orElse(new ArrayList());
        if (CollectionUtils.isEmpty((Collection)reports)) {
            String default_report_msg = this.getReport();
            if (StringUtils.isEmpty((CharSequence)default_report_msg)) {
                return Output.finish((String)"reply", (Object)"message.scrumbi.no.report");
            }
            return Output.through((String)"report", (Object)default_report_msg);
        }
        return Output.through((String)"report", (Object)((JSONObject)reports.get(0)).getString("report"));
    }

    private String getReport() {
        String string;
        InputStream inputStream = ResourceReader.class.getClassLoader().getResourceAsStream("report/report.text");
        if (inputStream == null) {
            System.out.println("\u8d44\u6e90\u6587\u4ef6\u672a\u627e\u5230");
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            String content;
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            string = content = result.toString(StandardCharsets.UTF_8.name());
        }
        catch (Throwable throwable) {
            try {
                try {
                    result.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("io\u5f02\u5e38\uff1a{}", (Throwable)e);
                return null;
            }
        }
        result.close();
        return string;
    }
}

