/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.chatbi.reasoning.executor.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.chatbi.beans.entity.UserReportRelationEntity;
import com.digiwin.chatbi.beans.entity.UserReportsEntity;
import com.digiwin.chatbi.beans.pojos.QuestionLite;
import com.digiwin.chatbi.common.constant.Constants;
import com.digiwin.chatbi.common.util.CommonUtil;
import com.digiwin.chatbi.common.util.SpringContextUtil;
import com.digiwin.chatbi.common.util.StringUtil;
import com.digiwin.chatbi.mapper.mysql.onlyRead.ReportReadMapper;
import com.digiwin.chatbi.reasoning.executor.Executor;
import com.digiwin.chatbi.reasoning.pipeline.result.Output;
import com.digiwin.chatbi.service.ReportService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchSchemasAndExampleData
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(SearchSchemasAndExampleData.class);
    public static final String CHOSE_TABLE = "chose_table";

    public Output doProcess(JSONObject context) {
        String tableName;
        JSONObject multiDialogueAndSelect = context.getJSONObject("Multi_dialogue_and_select");
        String tableNameId = ((QuestionLite)context.getObject("question", QuestionLite.class)).getTableId();
        if (!Objects.isNull(multiDialogueAndSelect)) {
            log.info("\u591a\u8868\u67e5\u8be2GPT\u8f93\u51fa\uff1a{}", (Object)multiDialogueAndSelect);
            JSONArray choseTableList = multiDialogueAndSelect.getJSONArray(CHOSE_TABLE);
            if (CollectionUtils.isEmpty((Collection)choseTableList)) {
                return Output.finish((String)"reply", (Object)"message.scrumbi.no.report").keep("success", (Object)false);
            }
            if (choseTableList.size() > 1) {
                ArrayList userReportsEntityList;
                List list = userReportsEntityList = Objects.isNull(context.getObject("sheet_list_info", List.class)) ? new ArrayList() : (List)context.getObject("sheet_list_info", List.class);
                if (CollectionUtils.isEmpty(userReportsEntityList)) {
                    return Output.finish((String)"reply", (Object)"message.scrumbi.no.report").keep("success", (Object)false);
                }
                ArrayList<JSONObject> moreSheetInfos = new ArrayList<JSONObject>();
                for (Object o : choseTableList) {
                    String tableId = (String)o;
                    JSONObject metricsAppInfo = new JSONObject();
                    for (UserReportsEntity userReportsEntity : userReportsEntityList) {
                        if (!tableId.equals(userReportsEntity.getTableName())) continue;
                        metricsAppInfo.put("tableName", (Object)userReportsEntity.getSheetName());
                        break;
                    }
                    metricsAppInfo.put("tableId", (Object)tableId);
                    moreSheetInfos.add(metricsAppInfo);
                }
                return Output.finish((String)"reply", (Object)"message.scrumbi.more.sheet").keep("more_sheet_check", (Object)"Y").keep("more_sheet_list", moreSheetInfos);
            }
            tableNameId = choseTableList.getString(0);
        }
        ReportReadMapper reportReadMapper = (ReportReadMapper)SpringContextUtil.getBean(ReportReadMapper.class);
        String string = tableName = StringUtils.isNotBlank((CharSequence)tableNameId) ? tableNameId : this.getTableName(context);
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return Output.finish((String)"reply", (Object)"message.scrumbi.no.report").keep("success", (Object)false);
        }
        ReportService reportService = (ReportService)SpringContextUtil.getBean(ReportService.class);
        String sheetName = reportService.getSheetNameByTableName(tableName);
        String tableDDL = null;
        String exampleDataStr = null;
        List tableSchemaList = null;
        try {
            Map createTableSQL = reportReadMapper.getCreatTableSQL(tableName);
            if (!createTableSQL.isEmpty()) {
                tableDDL = (String)createTableSQL.get("Create Table");
            }
            tableSchemaList = reportReadMapper.queryTableStructureInfo(tableName);
            Integer count = reportReadMapper.getCount(tableName);
            List sampleIndexs = StringUtil.fetchBalancedSampleIndexs((int)count, (int)5);
            List exampleDataList = reportReadMapper.getExampleData(tableName, sampleIndexs.stream().map(String::valueOf).collect(Collectors.joining(", ", "(", ")")));
            this.buildExampleData(tableSchemaList, exampleDataList);
            exampleDataStr = CommonUtil.mapToString((List)exampleDataList);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6570\u636e\u8868\u7ed3\u6784\u793a\u4f8b\u6570\u636e\u5931\u8d25\uff1a{} ", (Object)e.getMessage());
            return Output.finish((String)"reply", (Object)"message.scrumbi.no.report").keep("success", (Object)false);
        }
        return Output.through((String)"creatTableSQL", (Object)tableDDL).keep("sheetName", (Object)sheetName).keep("dataSample", (Object)exampleDataStr).keep("fieldNameMapping", (Object)tableSchemaList);
    }

    private String getTableName(JSONObject context) {
        String tableName = null;
        ReportService reportService = (ReportService)SpringContextUtil.getBean(ReportService.class);
        Integer useDemo = ((QuestionLite)context.getObject("question", QuestionLite.class)).getUseDemo();
        if (Constants.LITE_USE_DEMO.equals(useDemo)) {
            String fileUrl = ((QuestionLite)context.getObject("question", QuestionLite.class)).getFileUrl();
            if (StringUtils.isBlank((CharSequence)fileUrl)) {
                return null;
            }
            List userReportRelationEntities = reportService.selectCommonReport(fileUrl);
            if (CollectionUtils.isNotEmpty((Collection)userReportRelationEntities)) {
                tableName = "scrumbi_common_report_" + ((UserReportRelationEntity)userReportRelationEntities.get(0)).getId();
            }
        } else {
            String userId = context.getString("userId");
            String tenantId = context.getString("tenantId");
            if (userId == null || tenantId == null) {
                return null;
            }
            String tableId = reportService.selectByUserIdAndTenantId(userId, tenantId);
            if (StringUtils.isBlank((CharSequence)tableId)) {
                return null;
            }
            tableName = "scrumbi_user_report_" + tableId;
        }
        return tableName;
    }

    private void buildExampleData(List<LinkedHashMap<String, Object>> tableSchemaList, List<LinkedHashMap<String, Object>> exampleDataList) {
        if (CollectionUtils.isNotEmpty(exampleDataList)) {
            HashMap<String, String> schemaMap = new HashMap<String, String>();
            for (LinkedHashMap<String, Object> tableSchema : tableSchemaList) {
                String field = (String)tableSchema.get("field");
                String comment = (String)tableSchema.get("comment");
                schemaMap.put(field, comment != null && !comment.isEmpty() ? comment : field);
            }
            LinkedHashMap fieldComment = new LinkedHashMap();
            exampleDataList.get(0).keySet().forEach(key -> {
                String comment = schemaMap.getOrDefault(key, (String)key);
                fieldComment.put(key, comment);
            });
            exampleDataList.add(0, fieldComment);
        }
    }
}

